/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.check;

import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.ws.core.adapter.MetamodelResourceAdapter;
import com.sap.ide.ws.core.builder.ModularBuilderModuleI;
import com.sap.ide.ws.core.builder.result.BuildResult;
import com.sap.ide.ws.core.builder.result.BuildResultEntry;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.services.editors.MdoEditorUtils;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;

public abstract class MdoChecker
implements ModularBuilderModuleI {
    public void check(int kind, IProject project, IResourceDelta delta, BuildResult checkResult) {
        MainDevelopmentObject[] mdos = null;
        mdos = kind == 6 ? this.getAllMdos(project) : (kind == 9 ? this.getChangedMdos(delta, project) : this.getAllMdos(project));
        if (mdos == null || mdos.length < 1) {
            return;
        }
        this.deleteMarkersForMdos(mdos);
        this.doCheck(mdos, checkResult);
    }

    public void applyCheckResult(BuildResult checkResult) {
        ArrayList list = checkResult.getCheckResultEntries();
        int i = 0;
        while (i < list.size()) {
            BuildResultEntry checkResEntry = (BuildResultEntry)list.get(i);
            IResource lResource = checkResEntry.getResource();
            if (lResource != null) {
                try {
                    IMarker lMarker = lResource.createMarker(this.getMyCheckMarkerId());
                    if (lMarker != null) {
                        lMarker.setAttribute("message", (Object)checkResEntry.getMessage());
                        lMarker.setAttribute("severity", checkResEntry.getKind());
                        lMarker.setAttribute(this.getMyMarkerNameAttribute(), (Object)checkResEntry.getResource().getProjectRelativePath().toOSString());
                    }
                }
                catch (CoreException e) {
                    WebServiceCorePlugin.logError(e, this.getClass());
                }
            }
            ++i;
        }
    }

    public void updateOpenEditorIcons(BuildResult result, IProject project) {
        MainDevelopmentObject[] mdos = this.getAllMdos(project);
        int i = 0;
        while (i < mdos.length) {
            IEditorPart part = MdoEditorUtils.findEditorPartForMdo(mdos[i]);
            if (part != null && part instanceof IDevelopmentObjectEditor) {
                ((IDevelopmentObjectEditor)part).updateUI();
            }
            ++i;
        }
    }

    protected abstract MainDevelopmentObject[] getAllMdos(IProject var1);

    protected abstract String getMdoFileExtension();

    protected abstract String getMyCheckMarkerId();

    protected abstract String getMyMarkerNameAttribute();

    protected abstract void doCheck(MainDevelopmentObject[] var1, BuildResult var2);

    protected MainDevelopmentObject[] getChangedMdos(IResourceDelta delta, IProject project) {
        return this.getAllMdos(project);
    }

    private void deleteMarkersForMdos(MainDevelopmentObject[] mdos) {
        int i = 0;
        while (i < mdos.length) {
            try {
                IResource resource = MetamodelResourceAdapter.mdoToResource(mdos[i]);
                if (resource != null) {
                    resource.deleteMarkers(this.getMyCheckMarkerId(), false, 1);
                }
            }
            catch (Exception ex) {
                WebServiceCorePlugin.logError(ex, this.getClass());
            }
            ++i;
        }
    }

    public abstract String getModuleId();

    public abstract boolean isProjectRelevant(IProject var1);
}

