/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.services.archive;

import com.sap.ide.ws.core.files.FileFolderUtil;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IEarDescriptor;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IMutablePattern;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.RelativePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartLabelProvider;
import org.eclipse.ui.internal.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;

public abstract class WsGenericArchiveBuilder {
    private static final String EAR_EXTENSION = ".ear";
    private static final String WSAR_EXTENSION = ".wsar";
    private static final String TEMP_FOLDER_NAME = "temp";
    private static final String LIB_FOLDER_NAME = "lib";
    private IProject mProject = null;
    private IProgressMonitor mMonitor = null;
    private String mArchiveName = null;
    static /* synthetic */ Class class$com$sap$ide$ws$core$services$archive$WsGenericArchiveBuilder;

    public WsGenericArchiveBuilder(IProject project, IProgressMonitor monitor, String archiveName) {
        this.mProject = project;
        this.mMonitor = monitor;
        this.mArchiveName = archiveName;
        this.mArchiveName = this.mArchiveName.replace(' ', '_');
    }

    protected IProject getProject() {
        return this.mProject;
    }

    private String createTempFolder() {
        String folderName = null;
        IFolder folder = this.mProject.getFolder(TEMP_FOLDER_NAME);
        int i = 0;
        while (folder.exists()) {
            folder = this.mProject.getFolder(TEMP_FOLDER_NAME + i);
            ++i;
        }
        folderName = folder.getName();
        FileFolderUtil.createFolder(this.mProject, folderName);
        return folderName;
    }

    private void createWsArchive(String tempFolderName) {
        IArchiveDescriptor wsArchiveDescriptor = ArchiveDescriptionManager.newArchiveDescription();
        wsArchiveDescriptor.setDestPath(this.mProject, tempFolderName + "/" + this.mArchiveName + WSAR_EXTENSION);
        wsArchiveDescriptor.setCompressed(true);
        wsArchiveDescriptor.getComponentBuildInfo().setUseComponentBuild(true);
        wsArchiveDescriptor.getComponentBuildInfo().getComponent().setName(this.mArchiveName + "WSAR");
        this.mMonitor.worked(25);
        IProjectFileSet publicFiles = ArchiveDescriptionManager.getProjectFileSet();
        publicFiles.addRelativeFile(this.mProject, RelativePath.CLASSES, this.getOutputFilesPattern());
        wsArchiveDescriptor.addFileSet((IFileSet)publicFiles);
        IProjectFileSet wsDDFiles = ArchiveDescriptionManager.getProjectFileSet();
        wsDDFiles.addProjectFiles((IContainer)this.mProject, this.getMetaInfFolderPatternForWsar());
        wsArchiveDescriptor.addFileSet((IFileSet)wsDDFiles);
        this.mMonitor.worked(50);
        wsArchiveDescriptor.performBuild();
    }

    private void createWsArchiveContainingEar(String tempFolderName) {
        this.createTaskSpecificMetaFiles();
        IFile file = this.mProject.getFile(this.mArchiveName + EAR_EXTENSION);
        FileFolderUtil.deleteFileIfExists(file, this.mMonitor);
        IEarDescriptor earDescriptor = ArchiveDescriptionManager.newEarDescription();
        earDescriptor.setDestPath(this.mProject, "/" + this.mArchiveName + EAR_EXTENSION);
        earDescriptor.setCompressed(true);
        earDescriptor.getComponentBuildInfo().setUseComponentBuild(true);
        earDescriptor.getComponentBuildInfo().getComponent().setName(this.mArchiveName);
        this.mMonitor.worked(25);
        IProjectFileSet publicFiles = ArchiveDescriptionManager.getProjectFileSet();
        publicFiles.addProjectFiles((IContainer)this.mProject.getFolder(tempFolderName));
        earDescriptor.addFileSet((IFileSet)publicFiles);
        IProjectFileSet appXmlFiles = ArchiveDescriptionManager.getProjectFileSet();
        appXmlFiles.addProjectFiles((IContainer)this.mProject, this.getMetaInfFolderPatternForEar());
        earDescriptor.addFileSet((IFileSet)appXmlFiles);
        IProjectFileSet libFiles = ArchiveDescriptionManager.getProjectFileSet();
        libFiles.addProjectFiles((IContainer)this.mProject.getFolder(LIB_FOLDER_NAME), this.getLibFolderPattern(), "");
        earDescriptor.addFileSet((IFileSet)libFiles);
        earDescriptor.performBuild();
        try {
            file.refreshLocal(1, this.mMonitor);
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$services$archive$WsGenericArchiveBuilder == null ? (class$com$sap$ide$ws$core$services$archive$WsGenericArchiveBuilder = WsGenericArchiveBuilder.class$("com.sap.ide.ws.core.services.archive.WsGenericArchiveBuilder")) : class$com$sap$ide$ws$core$services$archive$WsGenericArchiveBuilder);
        }
    }

    private IPattern getLibFolderPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern("*.jar");
        return pattern;
    }

    public void run() {
        if (this.saveDirtyEditors()) {
            this.mMonitor.beginTask(WsCoreUiTexts.getString("WsGenericArchiveBuilder.Tasks.createArchive"), 100);
            this.mMonitor.setTaskName(WsCoreUiTexts.getString("WsGenericArchiveBuilder.Tasks.SubTask.createTemp"));
            String tempFolderName = this.createTempFolder();
            this.mMonitor.worked(25);
            this.mMonitor.setTaskName(WsCoreUiTexts.getString("WsGenericArchiveBuilder.Tasks.SubTask.createWsar"));
            this.createWsArchive(tempFolderName);
            this.mMonitor.worked(50);
            this.mMonitor.setTaskName(WsCoreUiTexts.getString("WsGenericArchiveBuilder.Tasks.SubTask.createEar"));
            this.createWsArchiveContainingEar(tempFolderName);
            this.mMonitor.worked(75);
            try {
                this.mMonitor.setTaskName(WsCoreUiTexts.getString("WsGenericArchiveBuilder.Tasks.SubTask.deleteTemp"));
                this.mProject.getFolder(tempFolderName).delete(true, null);
            }
            catch (CoreException e) {
                WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$services$archive$WsGenericArchiveBuilder == null ? (class$com$sap$ide$ws$core$services$archive$WsGenericArchiveBuilder = WsGenericArchiveBuilder.class$("com.sap.ide.ws.core.services.archive.WsGenericArchiveBuilder")) : class$com$sap$ide$ws$core$services$archive$WsGenericArchiveBuilder);
            }
            this.mMonitor.setTaskName(WsCoreUiTexts.getString("WsGenericArchiveBuilder.Tasks.SubTask.done"));
            this.mMonitor.worked(100);
        }
    }

    private boolean saveDirtyEditors() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        projects.add(this.mProject);
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        final List dirtyEditors = this.getDirtyEditors(projects);
        final List saveEditors = this.getEditorsToSave(dirtyEditors);
        if (saveEditors == null) {
            return false;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                Iterator iter = dirtyEditors.iterator();
                while (iter.hasNext()) {
                    IEditorPart editor = (IEditorPart)iter.next();
                    IWorkbenchPage page = editor.getEditorSite().getPage();
                    if (!saveEditors.contains(editor)) continue;
                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
            }
        });
        return true;
    }

    private List getEditorsToSave(List dirtyEditors) {
        if (dirtyEditors.isEmpty()) {
            return new ArrayList(0);
        }
        ArrayList<IEditorPart> saveEditors = new ArrayList<IEditorPart>(0);
        ArrayList<IFile> dirtyInputs = new ArrayList<IFile>(0);
        Iterator iter = dirtyEditors.iterator();
        while (iter.hasNext()) {
            IEditorPart editor = (IEditorPart)iter.next();
            IEditorInput input = editor.getEditorInput();
            IFile inputFile = ((IFileEditorInput)input).getFile();
            if (dirtyInputs.contains(inputFile)) continue;
            dirtyInputs.add(inputFile);
            saveEditors.add(editor);
        }
        AdaptableList input = new AdaptableList();
        input.add(saveEditors.iterator());
        ListSelectionDialog dlg = new ListSelectionDialog(Display.getCurrent().getActiveShell(), (Object)input, (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), WorkbenchMessages.getString((String)"EditorManager.saveResourcesMessage"));
        dlg.setInitialSelections(saveEditors.toArray(new Object[saveEditors.size()]));
        dlg.setTitle(WorkbenchMessages.getString((String)"EditorManager.saveResourcesTitle"));
        int result = dlg.open();
        if (result == 1) {
            return null;
        }
        return Arrays.asList(dlg.getResult());
    }

    private List getDirtyEditors(List projects) {
        ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>(0);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] editors = page.getDirtyEditors();
                int k = 0;
                while (k < editors.length) {
                    IFile inputFile;
                    IEditorPart editor = editors[k];
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IFileEditorInput && projects.contains((inputFile = ((IFileEditorInput)input).getFile()).getProject()) && editor.isDirty()) {
                        dirtyEditors.add(editor);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return dirtyEditors;
    }

    protected abstract IPattern getMetaInfFolderPatternForWsar();

    protected abstract IPattern getMetaInfFolderPatternForEar();

    protected abstract IPattern getOutputFilesPattern();

    protected abstract void createTaskSpecificMetaFiles();

    private IPattern getSourceFilesPattern() {
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addExcludePattern("**/*.java");
        return pattern;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

