/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.markers;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ResourceMarkerManager {
    public static final int FLAG_OK = 0;
    public static final int FLAG_WARNING = 1;
    public static final int FLAG_ERROR = 2;
    static /* synthetic */ Class class$com$sap$ide$ws$core$markers$ResourceMarkerManager;

    public static IMarker[] getResourceMarkers(String projectName, String relativeFilePath, String markerId) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile dd = project.getFile(relativeFilePath);
        try {
            IMarker[] markers = dd.findMarkers(markerId, false, 0);
            if (markers.length > 0) {
                return markers;
            }
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$markers$ResourceMarkerManager == null ? (class$com$sap$ide$ws$core$markers$ResourceMarkerManager = ResourceMarkerManager.class$("com.sap.ide.ws.core.markers.ResourceMarkerManager")) : class$com$sap$ide$ws$core$markers$ResourceMarkerManager);
        }
        return new IMarker[0];
    }

    public static IMarker[] getResourceMarkers(IResource resource, String checkMarkerId) {
        return ResourceMarkerManager.getResourceMarkers(resource, checkMarkerId, 1);
    }

    public static IMarker[] getResourceMarkers(IResource resource, String checkMarkerId, int depth) {
        if (resource != null) {
            try {
                IMarker[] markers = resource.findMarkers(checkMarkerId, false, depth);
                if (markers != null && markers.length > 0) {
                    return markers;
                }
            }
            catch (CoreException e) {
                WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$markers$ResourceMarkerManager == null ? (class$com$sap$ide$ws$core$markers$ResourceMarkerManager = ResourceMarkerManager.class$("com.sap.ide.ws.core.markers.ResourceMarkerManager")) : class$com$sap$ide$ws$core$markers$ResourceMarkerManager);
            }
        }
        return new IMarker[0];
    }

    public static IMarker[] getWsdFaultyMarkers(String projectName, String relativeFilePath, String markerId) {
        return ResourceMarkerManager.getResourceMarkers(projectName, relativeFilePath, markerId);
    }

    public static IMarker[] getConfigurationFaultyMarkers(String projectName, String relativeFilePath, String markerId, String webServiceName, String configName) {
        ArrayList<IMarker> markersList = new ArrayList<IMarker>();
        try {
            IMarker[] markers = ResourceMarkerManager.getResourceMarkers(projectName, relativeFilePath, markerId);
            int i = 0;
            while (i < markers.length) {
                String serviceCfgName = (String)markers[i].getAttribute("location");
                if (serviceCfgName.equals(webServiceName + '/' + configName)) {
                    markersList.add(markers[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$markers$ResourceMarkerManager == null ? (class$com$sap$ide$ws$core$markers$ResourceMarkerManager = ResourceMarkerManager.class$("com.sap.ide.ws.core.markers.ResourceMarkerManager")) : class$com$sap$ide$ws$core$markers$ResourceMarkerManager);
        }
        return markersList.toArray(new IMarker[markersList.size()]);
    }

    public static IMarker[] getWebServiceFaultyMarkers(String projectName, String relativeFilePath, String markerId, String webServiceName) {
        ArrayList<IMarker> markersList = new ArrayList<IMarker>();
        try {
            IMarker[] markers = ResourceMarkerManager.getResourceMarkers(projectName, relativeFilePath, markerId);
            int i = 0;
            while (i < markers.length) {
                String serviceName = (String)markers[i].getAttribute("location");
                if (serviceName.equals(webServiceName)) {
                    markersList.add(markers[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            WebServiceCorePlugin.logError(e, class$com$sap$ide$ws$core$markers$ResourceMarkerManager == null ? (class$com$sap$ide$ws$core$markers$ResourceMarkerManager = ResourceMarkerManager.class$("com.sap.ide.ws.core.markers.ResourceMarkerManager")) : class$com$sap$ide$ws$core$markers$ResourceMarkerManager);
        }
        return markersList.toArray(new IMarker[markersList.size()]);
    }

    public static int getMostSevere(IMarker[] markers) {
        int currentHighest = 0;
        int i = 0;
        while (i < markers.length) {
            if (ResourceMarkerManager.getSeverity(markers[i]) > currentHighest && (currentHighest = ResourceMarkerManager.getSeverity(markers[i])) == 2) {
                return currentHighest;
            }
            ++i;
        }
        return currentHighest;
    }

    private static int getSeverity(IMarker marker) {
        int ret = 0;
        int priority = marker.getAttribute("severity", 0);
        if (priority == 1) {
            ret = 1;
        } else if (priority == 2) {
            ret = 2;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

