/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.editors;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.ws.core.adapter.MetamodelResourceAdapter;
import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.services.dtr.MdoDtrService;
import com.sap.ide.ws.core.services.dtr.WsDtrService;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class MdoReadOnlyStateHandler
implements HandleReadOnlyStateI {
    private MainDevelopmentObject mdo;

    public MdoReadOnlyStateHandler(MainDevelopmentObject mdo) {
        this.mdo = mdo;
    }

    protected MainDevelopmentObject getMdo() {
        return this.mdo;
    }

    public boolean isReadOnly() {
        return MdoDtrService.isMdoOrLanguageFileReadOnly(this.mdo);
    }

    public boolean isDtrRelevant() {
        return WsDtrService.isDtrRelevant(this.mdo.getAbsolutePath());
    }

    public boolean checkOutFromDtr() {
        return !MdoDtrService.checkOutMdoAndLanguageFiles(this.mdo).hasFailedFilePaths();
    }

    public boolean changeFileReadOnlyFlag() {
        return this.changeReadOnlyFlag(this.mdo);
    }

    protected boolean changeReadOnlyFlag(MainDevelopmentObject mdo) {
        MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Info", null, WsCoreUiTexts.getString("WsCore.Messages.Info.fileReadOnly", mdo.getAbsolutePath()), 2, new String[]{"Yes", "No"}, 1);
        if (dialog.open() == 0) {
            this.changeMdoReadOnlyFlag();
            return true;
        }
        return false;
    }

    protected void changeMdoReadOnlyFlag() {
        MetamodelResourceAdapter.mdoToResource(this.getMdo()).setReadOnly(false);
        String[] languages = this.getMdo().getTextPool().getAvailableLanguages();
        ArrayList list = new ArrayList();
        int j = 0;
        while (j < languages.length) {
            String languageFilePath = this.getMdo().getTextPool().getAbsolutePath(languages[j]);
            ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(languageFilePath)).setReadOnly(false);
            ++j;
        }
    }
}

