/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.editors;

import com.sap.ide.ws.core.editors.EditorItemI;
import com.sap.ide.ws.core.editors.GenericMultiPageEditorPage;
import com.sap.ide.ws.core.editors.GenericWsEditorActionContributor;
import com.sap.ide.ws.core.editors.ShellFocusChangedHandler;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class GenericMultiPageEditor
extends MultiPageEditorPart
implements EditorItemI {
    private boolean dirty;
    private boolean readOnly = false;
    private ShellFocusChangedHandler focusChangedHandler;

    public void doSave(IProgressMonitor monitor) {
        if (this.doSaveTask()) {
            this.dirty = false;
            this.firePropertyChange(257);
        }
        new WsRefreshAction().refresh(this.getProjectName());
    }

    public void setFocus() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof GenericWsEditorActionContributor) {
            if (this.getReadOnly()) {
                ((GenericWsEditorActionContributor)contributor).setReadOnlyText(WsCoreUiTexts.getString("WsCore.Labels.General.readOnly"));
            } else {
                ((GenericWsEditorActionContributor)contributor).setReadOnlyText(WsCoreUiTexts.getString("WsCore.Labels.General.writable"));
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void notifyOfChange() {
        this.dirty = true;
        this.firePropertyChange(257);
        this.refreshOutline();
    }

    public void doSaveAs() {
    }

    public void firePropertyChanged(int propertyID) {
        super.firePropertyChange(propertyID);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean getReadOnly() {
        return this.isEditedObjectReadOnly();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.focusChangedHandler = new ShellFocusChangedHandler((IWorkbenchPart)this);
        site.getWorkbenchWindow().getShell().addShellListener((ShellListener)this.focusChangedHandler);
    }

    public void updateStatusBar() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof GenericWsEditorActionContributor) {
            if (this.getReadOnly()) {
                ((GenericWsEditorActionContributor)contributor).setReadOnlyText(WsCoreUiTexts.getString("WsCore.Labels.General.readOnly"));
            } else {
                ((GenericWsEditorActionContributor)contributor).setReadOnlyText(WsCoreUiTexts.getString("WsCore.Labels.General.writable"));
            }
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.getSite().getShell().removeShellListener((ShellListener)this.focusChangedHandler);
    }

    public void gotoMarker(IMarker marker) {
    }

    protected void refreshOutline() {
    }

    protected abstract void setPageAndIndex(GenericMultiPageEditorPage var1, int var2);

    protected abstract boolean doSaveTask();

    protected abstract boolean isEditedObjectReadOnly();

    protected abstract String getProjectName();

    public abstract Object getEditingObject();
}

