/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.editors;

import com.sap.ide.ws.core.editors.HandleReadOnlyStateI;
import com.sap.ide.ws.core.services.dtr.WsDtrService;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class FileReadOnlyStateHandler
implements HandleReadOnlyStateI {
    private IFile file;

    public FileReadOnlyStateHandler(IFile file) {
        this.file = file;
    }

    public boolean isReadOnly() {
        return this.file.isReadOnly();
    }

    public boolean isDtrRelevant() {
        return WsDtrService.isDtrRelevant(this.file.getLocation().toOSString());
    }

    public boolean checkOutFromDtr() {
        return WsDtrService.checkOutFile(this.file.getLocation().toOSString());
    }

    public boolean changeFileReadOnlyFlag() {
        MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Info", null, WsCoreUiTexts.getString("WsCore.Messages.Info.fileReadOnly", this.file.getLocation().toOSString()), 2, new String[]{"Yes", "No"}, 1);
        if (dialog.open() == 0) {
            this.file.setReadOnly(false);
            return true;
        }
        return false;
    }
}

