/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.descriptors;

import com.sap.ide.ws.core.files.FileFolderUtil;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class J2eeDescriptorCreator {
    private static final String APPLICATION_XML_FILENAME = "application.xml";
    private static final String APPLICATION_J2EE_ENGINE_FILENAME = "application-j2ee-engine.xml";
    private static final String EMPTY_APPLICATION_XML_FORMAT_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE application PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\" \"http://java.sun.com/dtd/application_1_3.dtd\"><application><display-name>";
    private static final String EMPTY_APPLICATION_XML_FORMAT_END = "</display-name></application>";
    private static final String APPLICATION_J2EE_ENGINE_XML_FORMAT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE application-j2ee-engine SYSTEM 'application-j2ee-engine.dtd'><application-j2ee-engine><provider-name>sap.com</provider-name><fail-over-enable mode=\"disable\" /></application-j2ee-engine>";
    public static final String META_INF_FOLDER = "META-INF";

    public static IFile createApplicationXml(IProject project) {
        return J2eeDescriptorCreator.createApplicationXml(project, project.getName());
    }

    public static IFile createApplicationXml(IProject project, String applicationName) {
        byte[] buf = (EMPTY_APPLICATION_XML_FORMAT_START + applicationName + EMPTY_APPLICATION_XML_FORMAT_END).getBytes();
        IFile appXmlFile = project.getFile(META_INF_FOLDER + File.separator + APPLICATION_XML_FILENAME);
        if (FileFolderUtil.createFileWithContent(appXmlFile, buf)) {
            return appXmlFile;
        }
        return null;
    }

    public static IFile createAppJ2eeEngineXml(IProject project) {
        byte[] buf = APPLICATION_J2EE_ENGINE_XML_FORMAT.getBytes();
        IFile appJ2eeEngineXmlFile = project.getFile(META_INF_FOLDER + File.separator + APPLICATION_J2EE_ENGINE_FILENAME);
        if (FileFolderUtil.createFileWithContent(appJ2eeEngineXmlFile, buf)) {
            return appJ2eeEngineXmlFile;
        }
        return null;
    }
}

