/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.decorators;

import com.sap.ide.ws.core.decorators.DecoratedElementI;
import com.sap.ide.ws.core.decorators.ImageDescriptorImpl;
import com.sap.ide.ws.core.decorators.WsDecoreatedImageRegistry;
import com.sap.ide.ws.core.decorators.WsImageDescriptor;
import com.sap.ide.ws.core.markers.ResourceMarkerManager;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class WsLabelDecorator
implements ILabelDecorator {
    private WsDecoreatedImageRegistry imgReg = new WsDecoreatedImageRegistry();
    private IProblemChangedListener myProblemChangedListener;
    private ListenerList myListeners;
    private static WsLabelDecorator myDecorator = new WsLabelDecorator();
    private static final int DEFAULT_NO_ERROR_SEVERITY = 0;

    private WsLabelDecorator() {
    }

    public static WsLabelDecorator getInstance() {
        if (myDecorator == null) {
            myDecorator = new WsLabelDecorator();
        }
        return myDecorator;
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return null;
        }
        int deco = this.getDecorateFlag(element);
        Rectangle bounds = image.getBounds();
        Image ret = this.imgReg.get((ImageDescriptor)new WsImageDescriptor(new ImageDescriptorImpl(image), deco, new Point(bounds.width, bounds.height)));
        return ret;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private int getDecorateFlag(Object element) {
        if (element instanceof DecoratedElementI) {
            return ResourceMarkerManager.getMostSevere(((DecoratedElementI)element).getMarkers());
        }
        if (element instanceof IResource) {
            try {
                return ResourceMarkerManager.getMostSevere(((IResource)element).findMarkers(null, true, 2));
            }
            catch (CoreException e) {
                WebServiceCorePlugin.logError(e, this.getClass());
            }
        }
        return 0;
    }
}

