/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.decorators;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class WsDecoreatedImageRegistry {
    private HashMap myRegistry = new HashMap(10);
    private Display myDisplay;

    public WsDecoreatedImageRegistry() {
        this(null);
    }

    public WsDecoreatedImageRegistry(Display display) {
        if (display == null) {
            display = this.getDisplay();
        }
        this.myDisplay = display;
        this.hookDisplay();
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.myRegistry.get(descriptor)) != null) {
            return result;
        }
        result = descriptor.createImage();
        if (result != null) {
            this.myRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        Iterator iter = this.myRegistry.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.myRegistry.clear();
    }

    private void hookDisplay() {
        this.myDisplay.disposeExec(new Runnable(){

            public void run() {
                WsDecoreatedImageRegistry.this.dispose();
            }
        });
    }
}

