/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.builder;

import com.sap.ide.ws.core.builder.ModularBuilderModuleI;
import com.sap.ide.ws.core.builder.result.BuildResult;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ModularBuilder
extends IncrementalProjectBuilder {
    private Hashtable modules = new Hashtable();

    public ModularBuilder() {
        this.registerModules();
    }

    protected void addModule(ModularBuilderModuleI module) {
        this.modules.put(module.getModuleId(), module);
    }

    protected abstract void registerModules();

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        Enumeration keys = this.modules.keys();
        while (keys.hasMoreElements()) {
            ModularBuilderModuleI module = (ModularBuilderModuleI)this.modules.get(keys.nextElement());
            if (!module.isProjectRelevant(this.getProject())) continue;
            BuildResult result = new BuildResult();
            module.check(kind, this.getProject(), this.getDelta(this.getProject()), result);
            module.applyCheckResult(result);
            module.updateOpenEditorIcons(result, this.getProject());
        }
        return null;
    }
}

