/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ws.core.actions;

import com.sap.ide.ws.core.actions.GenericMultiAction;
import com.sap.ide.ws.core.services.resources.WsRefreshAction;
import com.sap.ide.ws.core.text.WsCoreUiTexts;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public abstract class GenericMultiDeleteAction
extends GenericMultiAction {
    private boolean askForMultipleDelete = true;
    private boolean multipleDeleteOK = false;
    private boolean multipleDeleteCancel = false;

    public GenericMultiDeleteAction(ICategory category, String actionName) {
        super(category, actionName);
    }

    protected boolean warnUserAboutDelete(String objectTypeName, String objectName) {
        if (this.askForMultipleDelete && this.isMultiplyAvailable()) {
            this.warnUserAboutMutipleDelete(objectTypeName);
            this.askForMultipleDelete = false;
        }
        if (this.multipleDeleteOK) {
            return true;
        }
        if (this.multipleDeleteCancel) {
            return false;
        }
        MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), WsCoreUiTexts.getString("DialogTitles.warning"), null, WsCoreUiTexts.getString("GenaralQuestions.deleteSingle", objectTypeName), 4, new String[]{WsCoreUiTexts.getString("WsCore.Labels.General.yes"), WsCoreUiTexts.getString("WsCore.Labels.General.no")}, 0);
        return dlg.open() == 0;
    }

    protected abstract boolean isMultiplyAvailable();

    private void warnUserAboutMutipleDelete(String objectTypeName) {
        MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), WsCoreUiTexts.getString("DialogTitles.warning"), null, WsCoreUiTexts.getString("GenaralQuestions.deleteAll", objectTypeName), 4, new String[]{WsCoreUiTexts.getString("WsCore.Labels.General.yes"), WsCoreUiTexts.getString("GenaralQuestions.forEach"), WsCoreUiTexts.getString("WsCore.Labels.General.no")}, 0);
        int result = dlg.open();
        if (result == 0) {
            this.multipleDeleteOK = true;
        } else if (result == 2) {
            this.multipleDeleteCancel = true;
        }
    }

    public void run(Element[] elements) {
        Vector<String> involvedProjects = new Vector<String>();
        int i = 0;
        while (i < elements.length) {
            String projectName = elements[i].getModel().getUniqueName().getName();
            if (!involvedProjects.contains(projectName)) {
                involvedProjects.add(projectName);
            }
            this.deleteSingleElement(elements[i], projectName);
            ++i;
        }
        int i2 = 0;
        while (i2 < involvedProjects.size()) {
            new WsRefreshAction().refresh((String)involvedProjects.elementAt(i2));
            ++i2;
        }
    }

    protected void deleteSingleElement(Element element, String projectName) {
    }
}

