/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.util.io;

import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.Info;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.error.LogEntry;
import com.sap.sql.sqlj.framework.error.Position;
import com.sap.sql.sqlj.framework.error.Warning;
import com.sap.sql.sqlj.framework.ide.TranslationLog;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public class ErrorLogger
implements ErrorLog {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$util$io$ErrorLogger == null ? (class$com$sap$sql$sqlj$util$io$ErrorLogger = ErrorLogger.class$("com.sap.sql.sqlj.util.io.ErrorLogger")) : class$com$sap$sql$sqlj$util$io$ErrorLogger));
    private static final int POS_UNSET = 0;
    private static final int START_POS_SET = 1;
    private static final int END_POS_SET = 2;
    private int m_pos_state;
    private static LogEntry first = new LogEntry("");
    private String m_file_name = null;
    private ErrorLogger m_el = null;
    private Vector m_children = new Vector(2);
    private Vector m_error = new Vector(2);
    private int m_sline;
    private int m_scol;
    private int m_eline;
    private int m_ecol;
    private String m_file;
    private int m_error_count;
    private int m_warning_count;
    private static final int LASTLINE = 999;
    static /* synthetic */ Class class$com$sap$sql$sqlj$util$io$ErrorLogger;

    public ErrorLogger(String fileName) {
        this.m_file_name = fileName;
        this.m_sline = -1;
        this.m_scol = -1;
        this.m_eline = -1;
        this.m_ecol = -1;
        this.m_pos_state = 0;
        this.m_error_count = 0;
        this.m_warning_count = 0;
    }

    public ErrorLogger() {
        this((String)null);
    }

    private ErrorLogger(ErrorLogger el) {
        this();
        this.m_el = el;
        if (el != null) {
            this.m_file_name = el.m_file_name;
        }
    }

    public void setFileName(String name) {
        this.m_file_name = name;
    }

    public String getFileName() {
        return this.m_file_name;
    }

    public ErrorLogger createChild() {
        ErrorLogger el = new ErrorLogger(this);
        this.m_children.addElement(el);
        el.m_file_name = this.m_file_name;
        return el;
    }

    public ErrorLogger createChild(String file) {
        ErrorLogger el = new ErrorLogger(this);
        this.m_children.addElement(el);
        el.m_sline = 1;
        el.m_scol = 1;
        el.m_file_name = file;
        return el;
    }

    protected void removeChild(ErrorLogger el) {
        this.m_children.removeElement(el);
    }

    public void abort() {
        this.m_el.removeChild(this);
        this.m_el = null;
        this.m_children = null;
        this.m_error = null;
    }

    public void close() {
        this.abort();
    }

    public void setStartPos(int line, int col) {
        if (this.m_pos_state != 0 && this.m_pos_state != 1) {
            throw new IllegalArgumentException("ErrorLogger.setStartPos(): illegal to change start pos.");
        }
        this.m_sline = line;
        this.m_scol = col;
        this.m_pos_state = 1;
    }

    public Position getDefaultRegion() {
        if (this.m_pos_state == 2) {
            return new Position(this.m_sline, this.m_scol, this.m_eline, this.m_ecol);
        }
        if (this.m_pos_state == 1) {
            return new Position(this.m_sline, this.m_scol);
        }
        return new Position();
    }

    public void setEndPos(int line, int col) {
        if (this.m_pos_state == 0) {
            throw new IllegalArgumentException("ErrorLogger.setEndPos(): must setStartPos() first.");
        }
        if (this.m_pos_state != 1) {
            throw new IllegalArgumentException("ErrorLogger.setStartPos(): illegal to change end pos.");
        }
        this.m_eline = line;
        this.m_ecol = col;
        this.m_pos_state = 2;
        Enumeration enumeration = this.m_error.elements();
        while (enumeration.hasMoreElements()) {
            LogEntry le = (LogEntry)enumeration.nextElement();
            if (!le.less(first)) continue;
            le.setRegion(this.m_sline, this.m_scol, this.m_eline, this.m_ecol);
        }
    }

    public void printLog(Writer w) {
        SortedVector svec = new SortedVector();
        ErrorLogger.collectLog(this, svec);
        Enumeration enumeration = svec.elements();
        while (enumeration.hasMoreElements()) {
            try {
                w.write(((LogEntry)enumeration.nextElement()).toString());
                w.write("\n");
            }
            catch (IOException exn) {
                LOCATION.traceThrowableT(500, "unexpected IOException ignored", (Throwable)exn);
            }
        }
    }

    public void printLog(TranslationLog jslog) {
        SortedVector svec = new SortedVector();
        ErrorLogger.collectLog(this, svec);
        Enumeration enumeration = svec.elements();
        while (enumeration.hasMoreElements()) {
            LogEntry le = (LogEntry)enumeration.nextElement();
            Position p = le.getPosition();
            if (p == null) {
                p = new Position();
            }
            if (le instanceof Warning) {
                jslog.logWarning(le.getMessage(), p.startLine(), p.startCol(), p.endLine(), p.endCol());
                continue;
            }
            if (le instanceof JSError) {
                jslog.logError(le.getMessage(), p.startLine(), p.startCol(), p.endLine(), p.endCol());
                continue;
            }
            jslog.logInfo(le.getMessage(), p.startLine(), p.startCol(), p.endLine(), p.endCol());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        SortedVector svec = new SortedVector();
        ErrorLogger.collectLog(this, svec);
        Enumeration enumeration = svec.elements();
        while (enumeration.hasMoreElements()) {
            sb.append(enumeration.nextElement().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void collectLog(ErrorLogger el, SortedVector sv) {
        Enumeration enumeration = el.m_error.elements();
        while (enumeration.hasMoreElements()) {
            sv.addOrderedElement((LogEntry)enumeration.nextElement());
        }
        el.m_error = new Vector(2);
        enumeration = el.m_children.elements();
        while (enumeration.hasMoreElements()) {
            ErrorLogger.collectLog((ErrorLogger)enumeration.nextElement(), sv);
        }
    }

    public void addEntry(LogEntry entry) {
        entry.setFileName(this.m_file_name);
        this.addEntryRegion(entry);
    }

    public void addEntryOffset(LogEntry entry, int offset) {
        this.addEntry(entry);
        if (offset > 0) {
            Position p = entry.getPosition();
            int myline = p.startLine() + offset - 1;
            if (myline == p.startLine()) {
                entry.setRegion(myline, p.startCol(), myline, 999);
            } else if (myline < p.endLine()) {
                entry.setRegion(myline, 1, myline, 999);
            } else if (myline == p.endLine()) {
                entry.setRegion(myline, 1, myline, p.endCol());
            }
        }
    }

    public void addEntry(LogEntry entry, int line, int col) {
        entry.setPosition(line, col);
        entry.setFileName(this.m_file_name);
        this.m_error.addElement(entry);
        if (entry instanceof JSError) {
            this.incErrorCount();
        } else if (entry instanceof Warning) {
            this.incWarningCount();
        }
    }

    public void addEntryRegion(LogEntry entry) {
        if (this.m_pos_state == 2) {
            entry.setRegion(this.m_sline, this.m_scol, this.m_eline, this.m_ecol);
        }
        entry.setFileName(this.m_file_name);
        this.m_error.addElement(entry);
        if (entry instanceof JSError) {
            this.incErrorCount();
        } else if (entry instanceof Warning) {
            this.incWarningCount();
        }
    }

    public void addEntryRegion(LogEntry entry, int startline, int startcol, int endline, int endcol) {
        entry.setRegion(startline, startcol, endline, endcol);
        entry.setFileName(this.m_file_name);
        this.m_error.addElement(entry);
        if (entry instanceof JSError) {
            this.incErrorCount();
        } else if (entry instanceof Warning) {
            this.incWarningCount();
        }
    }

    public void reportError(Object message) {
        JSError error = new JSError(message);
        error.setPosition(new Position());
        error.setFileName(this.m_file_name);
        this.m_error.addElement(error);
        this.incErrorCount();
    }

    public void reportError(int line, int col, Object message) {
        JSError error = new JSError(message);
        error.setPosition(line, col);
        error.setFileName(this.m_file_name);
        this.m_error.addElement(error);
        this.incErrorCount();
    }

    public void reportErrorRegion(Object message) {
        JSError error = new JSError(message);
        error.setPosition(new Position());
        error.setFileName(this.m_file_name);
        this.m_error.addElement(error);
        this.incErrorCount();
    }

    public void reportErrorRegion(int startline, int startcol, int endline, int endcol, Object message) {
        JSError error = new JSError(message);
        error.setRegion(startline, startcol, endline, endcol);
        error.setFileName(this.m_file_name);
        this.m_error.addElement(error);
        this.incErrorCount();
    }

    public void reportWarning(Object message) {
        Warning warning = new Warning(message);
        warning.setPosition(new Position());
        warning.setFileName(this.m_file_name);
        this.m_error.addElement(warning);
        this.incWarningCount();
    }

    public void reportWarning(int line, int col, Object message) {
        Warning warning = new Warning(message);
        warning.setPosition(line, col);
        warning.setFileName(this.m_file_name);
        this.m_error.addElement(warning);
        this.incWarningCount();
    }

    public void reportWarningRegion(Object message) {
        Warning warning = new Warning(message);
        warning.setPosition(new Position());
        warning.setFileName(this.m_file_name);
        this.m_error.addElement(warning);
        this.incWarningCount();
    }

    public void reportWarningRegion(int startline, int startcol, int endline, int endcol, Object message) {
        Warning warning = new Warning(message);
        warning.setRegion(startline, startcol, endline, endcol);
        warning.setFileName(this.m_file_name);
        this.m_error.addElement(warning);
        this.incWarningCount();
    }

    public void reportInfo(Object message) {
        Info info = new Info(message);
        info.setPosition(new Position());
        info.setFileName(this.m_file_name);
        this.m_error.addElement(info);
    }

    public void reportInfo(int line, int col, Object message) {
        Info info = new Info(message);
        info.setPosition(line, col);
        info.setFileName(this.m_file_name);
        this.m_error.addElement(info);
    }

    public void reportInfoRegion(Object message) {
        Info info = new Info(message);
        info.setPosition(new Position());
        info.setFileName(this.m_file_name);
        this.m_error.addElement(info);
    }

    public void reportInfoRegion(int startline, int startcol, int endline, int endcol, Object message) {
        Info info = new Info(message);
        info.setRegion(startline, startcol, endline, endcol);
        info.setFileName(this.m_file_name);
        this.m_error.addElement(info);
    }

    public void incErrorCount() {
        ++this.m_error_count;
    }

    public int errorCount() {
        int sum = 0;
        int i = 0;
        while (i < this.m_children.size()) {
            ErrorLogger el = (ErrorLogger)this.m_children.elementAt(i);
            if (el != null) {
                sum += el.errorCount();
            }
            ++i;
        }
        return sum + this.m_error_count;
    }

    public void incWarningCount() {
        ++this.m_warning_count;
    }

    public int warningCount() {
        int sum = 0;
        int i = 0;
        while (i < this.m_children.size()) {
            ErrorLogger el = (ErrorLogger)this.m_children.elementAt(i);
            if (el != null) {
                sum += el.warningCount();
            }
            ++i;
        }
        return sum + this.m_warning_count;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        first.setRegion(-99, -99, -99, -99);
    }

    class SortedVector
    extends Vector {
        SortedVector(int i) {
            super(i);
        }

        SortedVector() {
        }

        void addOrderedElement(LogEntry eo) {
            int s = this.size();
            boolean done = false;
            int i = 0;
            while (i < s && !done) {
                if (eo.less((LogEntry)this.elementAt(i))) {
                    this.insertElementAt(eo, i);
                    done = true;
                }
                ++i;
            }
            if (!done) {
                this.addElement(eo);
            }
        }
    }
}

