/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.translator;

import com.sap.sql.sqlj.codegen.ParseletFactory;
import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.Info;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.ide.TranslationOptionsQuery;
import com.sap.sql.sqlj.framework.options.HasOptions;
import com.sap.sql.sqlj.framework.options.InvalidOptionException;
import com.sap.sql.sqlj.framework.options.OptionGroup;
import com.sap.sql.sqlj.framework.options.PropertyList;
import com.sap.sql.sqlj.javac.JavaParserSub;
import com.sap.sql.sqlj.mesg.TranslatorErrors;
import com.sap.sql.sqlj.tools.SqljOptions;
import com.sap.sql.sqlj.translator.FileTranslationUnit;
import com.sap.sql.sqlj.translator.Main;
import com.sap.sql.sqlj.translator.TranslationUnit;
import com.sap.sql.sqlj.util.Disposable;
import com.sap.sql.sqlj.util.ParseContext;
import com.sap.sql.sqlj.util.ParseException;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.SqljPositions;
import com.sap.sql.sqlj.util.TranslationContext;
import com.sap.sql.sqlj.util.UnitDescriptor;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class Translator
implements HasOptions {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$translator$Translator == null ? (class$com$sap$sql$sqlj$translator$Translator = Translator.class$("com.sap.sql.sqlj.translator.Translator")) : class$com$sap$sql$sqlj$translator$Translator));
    private Disposable.Disposer disposer;
    private TranslationContext xlatCtx;
    private ParseletFactory parseletFactory;
    private ErrorLog m_log = null;
    private Vector m_units = new Vector();
    private Vector m_parselets = new Vector();
    private int m_numUnitsProcessed = 0;
    private OptionGroup m_options = null;
    private boolean m_force = false;
    static /* synthetic */ Class class$com$sap$sql$sqlj$translator$Translator;

    public Translator(TranslationOptionsQuery q) {
        this(q, null);
    }

    public Translator(TranslationOptionsQuery q, Map catalogReaders) {
        this.disposer = new Disposable.Disposer();
        this.xlatCtx = new TranslationContext(this.disposer, q);
        this.parseletFactory = new ParseletFactory(this.xlatCtx, catalogReaders);
    }

    public void setOptions(PropertyList props, ErrorLog log) throws InvalidOptionException {
        Boolean force = new Boolean(props.getProperty("force"));
        this.m_force = force;
        this.parseletFactory.setOptions(props, log);
        this.m_log = log;
    }

    public String[][] getOptionInfo() {
        return this.parseletFactory.getOptionInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addUnit(TranslationUnit unit) throws ParseException {
        ParseException parseException = null;
        ParseContext ctx = null;
        try {
            ctx = unit.getInput();
            if (Main.immediateStream != null) {
                Main.immediateStream.write(TranslatorErrors.msg("readingFile", ctx.getFileName()) + "\n");
                Main.immediateStream.flush();
            }
            Parselet p = new JavaParserSub(this.parseletFactory).parseSQLJUnit(ctx);
            try {
                ctx.getReader().close();
                if (unit instanceof FileTranslationUnit) {
                    ((FileTranslationUnit)unit).deleteInput();
                }
            }
            catch (IOException e) {
                LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)e);
            }
            UnitDescriptor td = (UnitDescriptor)p.getDescriptor();
            unit.setPackageName(td.getPackageName());
            this.m_parselets.addElement(p);
            this.m_units.addElement(unit);
        }
        catch (ParseException e) {
            LOCATION.catching((Throwable)e);
            parseException = e;
        }
        catch (IOException e) {
            String msg = "unexepectd IOException";
            LOCATION.traceThrowableT(500, "unexepectd IOException", (Throwable)e);
            parseException = new ParseException("unexepectd IOException");
        }
        if (parseException == null) {
            return;
        }
        try {
            try {
                unit.translationComplete(false);
            }
            catch (IOException e) {
                LOCATION.traceThrowableT(500, "unexpected IOException on closing a file", (Throwable)e);
                Object var8_12 = null;
                throw parseException;
            }
            Object var8_11 = null;
            throw parseException;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            throw parseException;
        }
    }

    public String getPackageName(TranslationUnit unit) throws ParseException {
        ParseContext ctx = null;
        try {
            ctx = unit.getInput();
            Parselet p = new JavaParserSub(this.parseletFactory).parseSQLJUnit(ctx);
            try {
                ctx.getReader().close();
            }
            catch (IOException e) {
                LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)e);
                return null;
            }
            UnitDescriptor td = (UnitDescriptor)p.getDescriptor();
            return td.getPackageName();
        }
        catch (ParseException e) {
            LOCATION.catching((Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)e);
            return null;
        }
    }

    public SqljPositions getSqljPositions(TranslationUnit unit) throws ParseException {
        ParseContext ctx = null;
        SqljPositions sp = new SqljPositions();
        try {
            ctx = unit.getInput();
            new JavaParserSub(this.parseletFactory).parseSQLJUnit(ctx);
            try {
                ctx.getReader().close();
            }
            catch (IOException e) {
                LOCATION.traceThrowableT(500, "unexpected IOException on closing a file", (Throwable)e);
                return null;
            }
            sp.setSqljPositions(ctx.getSqljPositions());
            sp.setHostvariablePositions(ctx.getHostvariablePositions());
            return sp;
        }
        catch (ParseException e) {
            LOCATION.catching((Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)e);
            return null;
        }
    }

    public boolean translate() {
        return this.translate(true);
    }

    public boolean translate(OptionGroup options) {
        this.m_options = options;
        return this.translate(true);
    }

    public boolean translate(boolean reset) {
        boolean totalSuccess = true;
        try {
            if (this.m_options != null) {
                Enumeration elem = this.m_options.elements();
                while (elem.hasMoreElements()) {
                    Object obj = elem.nextElement();
                    if (!(obj instanceof SqljOptions)) continue;
                    this.m_force = ((SqljOptions)obj).getBoolean("force");
                }
            }
            while (this.m_numUnitsProcessed < this.m_units.size()) {
                boolean unitSuccess;
                Parselet p = (Parselet)this.m_parselets.elementAt(this.m_numUnitsProcessed);
                TranslationUnit unit = (TranslationUnit)this.m_units.elementAt(this.m_numUnitsProcessed);
                if (Main.immediateStream != null) {
                    try {
                        Main.immediateStream.write(TranslatorErrors.msg("translatingFile", unit.getInput().getFileName()) + "\n");
                        Main.immediateStream.flush();
                    }
                    catch (IOException exn) {
                        LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)exn);
                    }
                }
                try {
                    File in = unit.getInFile();
                    File out = unit.getOutFile();
                    if (in != null && out != null && in.lastModified() > out.lastModified() || in == null || out == null || this.m_force) {
                        unitSuccess = p.generate(unit.getOutput());
                    } else {
                        this.m_log.addEntry(new Info(unit.getOutFile() + " is up to date"));
                        unitSuccess = true;
                    }
                }
                catch (IOException ex) {
                    String msg = TranslatorErrors.msg("output_io_error", ex.getMessage());
                    LOCATION.traceThrowableT(500, msg, (Throwable)ex);
                    this.m_log.addEntry(new JSError(msg));
                    unitSuccess = false;
                }
                catch (ConfigurationException ex) {
                    String message = TranslatorErrors.msg("configurationError", ex.getMessage());
                    LOCATION.traceThrowableT(400, message, (Throwable)ex);
                    this.m_log.addEntry(new JSError(message));
                    unitSuccess = false;
                }
                try {
                    unit.translationComplete(unitSuccess);
                }
                catch (IOException e) {
                    LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)e);
                }
                totalSuccess = unitSuccess && totalSuccess;
                ++this.m_numUnitsProcessed;
            }
            Object var10_13 = null;
            if (reset) {
                this.reset();
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (reset) {
                this.reset();
            }
            throw throwable;
        }
        return totalSuccess;
    }

    public void reset() {
        this.disposer.disposeTrash();
        this.m_units.clear();
        this.m_parselets.clear();
        this.m_numUnitsProcessed = 0;
        this.m_log = null;
    }

    public void resetTableDescription(String contextName, String tableName) {
        this.parseletFactory.resetTableDescription(contextName, tableName);
    }

    public void resetCatalogReader(String contextName) {
        this.parseletFactory.resetCatalogReader(contextName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

