/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.translator;

import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.mesg.TranslatorErrors;
import com.sap.sql.sqlj.translator.Main;
import com.sap.sql.sqlj.translator.TranslationUnit;
import com.sap.sql.sqlj.util.OutputContext;
import com.sap.sql.sqlj.util.ParseContext;
import com.sap.sql.sqlj.util.io.CharStream;
import com.sap.sql.sqlj.util.io.ErrorLogger;
import com.sap.sql.sqlj.util.io.SapOutputStreamWriter;
import com.sap.sql.sqlj.util.io.UCode_CharStream;
import com.sap.tc.logging.Location;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;

class FileTranslationUnit
implements TranslationUnit,
ParseContext,
OutputContext {
    private static final String JAVA_SUFFIX = ".java";
    private static final String JAVA_TMP_SUFFIX = ".java.tmp";
    private static final String SQLJ_SUFFIX = ".sqlj";
    private static final String PROFILE_SUFFIX = ".ser";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$translator$FileTranslationUnit == null ? (class$com$sap$sql$sqlj$translator$FileTranslationUnit = FileTranslationUnit.class$("com.sap.sql.sqlj.translator.FileTranslationUnit")) : class$com$sap$sql$sqlj$translator$FileTranslationUnit));
    public ArrayList sqljPositions = new ArrayList();
    public ArrayList hostvariablePositions = new ArrayList();
    private static ClassResolver m_resolver = null;
    private Reader m_reader = null;
    private UCode_CharStream m_charStream = null;
    private ErrorLogger m_log = null;
    private String m_package = "";
    private String m_resultDir;
    private String m_resultSerDir;
    private String m_encoding;
    private String m_name;
    private File m_infile;
    private int m_type;
    private StringWriter m_baseWriter = null;
    private Writer m_writer = null;
    private File m_tmpfile = null;
    static /* synthetic */ Class class$com$sap$sql$sqlj$translator$FileTranslationUnit;

    public void setSqljPositions(ArrayList p) {
        this.sqljPositions = p;
    }

    public ArrayList getHostvariablePositions() {
        return this.hostvariablePositions;
    }

    public void setHostvariablePositions(ArrayList p) {
        this.hostvariablePositions = p;
    }

    public ArrayList getSqljPositions() {
        return this.sqljPositions;
    }

    public FileTranslationUnit(String filename, String resultDir, String resultSerDir, String encoding, ErrorLogger log, ClassResolver resolver) throws IOException {
        this.m_infile = new File(filename);
        this.m_resultDir = resultDir;
        this.m_resultSerDir = resultSerDir;
        this.m_encoding = encoding;
        this.m_name = filename;
        this.m_log = log;
        m_resolver = resolver;
        this.m_log.setFileName(filename);
        if (filename.endsWith(JAVA_SUFFIX)) {
            this.m_type = 2;
        } else if (filename.endsWith(SQLJ_SUFFIX)) {
            this.m_type = 1;
        } else {
            String errorText = TranslatorErrors.illegal_input_extension(filename);
            this.m_log.addEntry(new JSError(errorText));
            throw new IOException(errorText);
        }
        if (!this.m_infile.canRead()) {
            String errorText = TranslatorErrors.input_file_not_readable(filename);
            this.m_log.addEntry(new JSError(errorText));
            throw new IOException(errorText);
        }
    }

    public String getFileName() {
        String s = this.m_infile.getName();
        if (s.endsWith(JAVA_SUFFIX)) {
            s = s.substring(0, s.length() - JAVA_SUFFIX.length());
        } else if (s.endsWith(SQLJ_SUFFIX)) {
            s = s.substring(0, s.length() - SQLJ_SUFFIX.length());
        }
        return s;
    }

    private String validateOutDir(String pkg, File oldFile) throws IOException {
        return this.validateOutDir(pkg, oldFile, null);
    }

    private String validateOutDir(String pkg, File oldFile, String suffix) throws IOException {
        String dir;
        String outDir;
        boolean isProfile = suffix != null && suffix.endsWith(PROFILE_SUFFIX) || oldFile.getName().endsWith(PROFILE_SUFFIX);
        String string = outDir = isProfile ? this.m_resultSerDir : this.m_resultDir;
        if (outDir == null) {
            dir = oldFile.getParent();
        } else {
            StringBuffer dirBuf = new StringBuffer(outDir);
            if (!outDir.endsWith(File.separator)) {
                dirBuf.append(File.separator);
            }
            if (pkg != null) {
                dirBuf.append(pkg.replace('.', File.separatorChar));
            }
            dir = dirBuf.toString();
        }
        if (!this.createDir(dir)) {
            String errorText = TranslatorErrors.cannot_create_package_dir(dir);
            this.getErrorLogger().addEntry(new JSError(errorText));
            throw new IOException(errorText);
        }
        if (Main.classFilesTable != null && suffix != null && suffix.endsWith(JAVA_SUFFIX)) {
            String oldFname = oldFile.toString();
            String butSuffix = oldFile.getName();
            butSuffix = butSuffix.substring(0, butSuffix.length() - 5);
            String javaFile = (dir == null ? "" : dir + File.separator) + butSuffix + JAVA_SUFFIX;
            Main.javaFilesTable.put(oldFname, javaFile);
            try {
                String classDir = this.validateOutDir(pkg, oldFile, PROFILE_SUFFIX);
                String classFile = (classDir == null ? "" : classDir + File.separator) + butSuffix + ".class";
                Main.classFilesTable.put(javaFile, classFile);
            }
            catch (IOException exn) {
                LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)exn);
            }
        }
        return dir;
    }

    private File newXXXXFile(String pkg, File oldFile, String newSuffix) throws IOException {
        String dir = this.validateOutDir(pkg, oldFile, newSuffix);
        String oldName = oldFile.getName();
        StringBuffer name = new StringBuffer(oldName);
        name.setLength(oldName.lastIndexOf(46));
        name.append(newSuffix);
        return new File(dir, name.toString());
    }

    private File newJavaFile(String pkg, File oldFile) throws IOException {
        return this.newXXXXFile(pkg, oldFile, JAVA_SUFFIX);
    }

    private File newJavaTmpFile(String pkg, File oldFile) throws IOException {
        String path = this.validateOutDir(pkg, oldFile, JAVA_TMP_SUFFIX);
        File outDir = new File(path == null ? "." : path);
        File tmpFile = File.createTempFile("sqlj", ".tmp", outDir);
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public ParseContext getInput() throws IOException {
        if (this.m_reader == null) {
            this.createInput();
        }
        return this;
    }

    public ClassResolver getClassResolver() {
        return m_resolver;
    }

    public Reader getReader() {
        return this.m_reader;
    }

    public CharStream getCharStream() {
        return this.m_charStream;
    }

    public ErrorLogger getErrorLogger() {
        return this.m_log;
    }

    private void createInput() throws IOException {
        try {
            FileInputStream is = new FileInputStream(this.m_infile);
            this.m_log = this.m_log.createChild(this.m_name);
            this.m_charStream = new UCode_CharStream((InputStream)is, this.m_encoding, (ErrorLog)this.m_log);
            this.m_reader = this.m_charStream.getReader();
        }
        catch (FileNotFoundException e) {
            this.m_log.addEntry(new JSError(TranslatorErrors.input_file_not_found(this.m_infile.getPath())));
            throw e;
        }
        catch (UnsupportedEncodingException ue) {
            this.m_log.addEntry(new JSError(TranslatorErrors.unsupported_file_encoding(this.m_encoding)));
            throw ue;
        }
    }

    void deleteInput() {
        this.m_charStream = null;
    }

    public String getName() {
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public void setPackageName(String pkg) {
        this.m_package = pkg;
    }

    public OutputContext getOutput() throws IOException {
        if (this.m_writer == null) {
            this.createOutput();
        }
        return this;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public File getInFile() {
        return this.m_infile;
    }

    public File getOutFile() {
        try {
            return this.newJavaFile(this.m_package, this.m_infile);
        }
        catch (IOException e) {
            LOCATION.traceThrowableT(500, "unexpected IOException - returned null", (Throwable)e);
            return null;
        }
    }

    public OutputStream createOutputStream(String filename) throws IOException {
        String dir = this.validateOutDir(this.m_package, this.m_infile, filename);
        File file = new File(dir, filename);
        if (Main.serFilesVector != null) {
            Main.serFilesVector.addElement(file);
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    private void createOutput() throws IOException {
        try {
            this.m_tmpfile = this.newJavaTmpFile(this.m_package, this.m_infile);
            this.m_writer = new SapOutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.m_tmpfile)), this.m_encoding);
        }
        catch (IOException e) {
            this.m_log.addEntry(new JSError(TranslatorErrors.cannot_create_output_file(this.m_tmpfile.getPath())));
            throw e;
        }
    }

    public void translationComplete(boolean success) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.close();
            if (this.m_type == 1) {
                File outfile = this.newJavaFile(this.m_package, this.m_infile);
                if (outfile.exists()) {
                    if (outfile.canWrite()) {
                        if (!outfile.delete()) {
                            this.m_log.addEntry(new JSError(TranslatorErrors.cannot_delete_file(outfile.getPath())));
                            success = false;
                        }
                    } else {
                        this.m_log.addEntry(new JSError(TranslatorErrors.output_file_in_use(outfile.getPath())));
                        success = false;
                    }
                }
                if (success) {
                    if (!this.m_tmpfile.renameTo(outfile)) {
                        this.m_log.addEntry(new JSError(TranslatorErrors.cannot_create_output_file(outfile.getPath())));
                    }
                } else {
                    this.m_tmpfile.delete();
                }
            } else {
                this.m_tmpfile.delete();
            }
            this.m_writer = null;
            this.m_tmpfile = null;
        }
        if (Main.immediateStream != null) {
            this.m_log.printLog(Main.immediateStream);
            Main.immediateStream.flush();
        }
    }

    private boolean createDir(String parent) {
        if (parent == null) {
            return true;
        }
        File outDir = new File(parent);
        if (outDir.isDirectory()) {
            return true;
        }
        return outDir.mkdirs();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

