/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.tools;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.CatalogReaderFactory;
import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.framework.TranslationException;
import com.sap.sql.sqlj.framework.ide.Options;
import com.sap.sql.sqlj.framework.ide.TranslationByteInput;
import com.sap.sql.sqlj.framework.ide.TranslationInput;
import com.sap.sql.sqlj.framework.ide.TranslationLog;
import com.sap.sql.sqlj.framework.ide.TranslationOutput;
import com.sap.sql.sqlj.framework.ide.TranslationUnit;
import com.sap.sql.sqlj.framework.ide.Translator;
import com.sap.sql.sqlj.mesg.TranslatorErrors;
import com.sap.sql.sqlj.translator.ClassResolverImpl;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;

public class TranslatorApi {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$tools$TranslatorApi == null ? (class$com$sap$sql$sqlj$tools$TranslatorApi = TranslatorApi.class$("com.sap.sql.sqlj.tools.TranslatorApi")) : class$com$sap$sql$sqlj$tools$TranslatorApi));
    private TranslationLog log;
    private Translator translator = null;
    private Options translatorOptions;
    private String classpath;
    private String sourcepath;
    private String force;
    private String outdir;
    static /* synthetic */ Class class$com$sap$sql$sqlj$tools$TranslatorApi;

    public TranslatorApi(CatalogReader aCatalogReader, TranslationLog aLog) {
        this.translatorOptions = new Options();
        this.translatorOptions.addCatalogReader(aCatalogReader, "");
        this.translatorOptions.setSapMode(true);
    }

    public TranslatorApi(String aCatalogReaderString, TranslationLog aLog) {
        this.log = aLog;
        String catalogReaderString = aCatalogReaderString;
        String catalogReaderPath = catalogReaderString.substring(9);
        try {
            this.translatorOptions = new Options();
            this.translatorOptions.setSapMode(true);
            CatalogReader reader = CatalogReaderFactory.createCatalogReader((String)("file://" + catalogReaderPath), (boolean)false);
            this.translatorOptions.addCatalogReader(reader, "");
        }
        catch (SQLException ex) {
            aLog.logError("Catalog reader cannot be initialized for \"" + aCatalogReaderString + "\": " + ex.getMessage(), 0, 0, 0, 0);
        }
    }

    public void setClasspath(String aClass) {
        this.classpath = aClass;
        this.translatorOptions.setClasspath(this.classpath);
    }

    public void setSourcepath(String aSource) {
        this.sourcepath = aSource;
        this.translatorOptions.setSource(this.sourcepath);
    }

    public void setForce(String aForce) {
        this.force = aForce;
        this.translatorOptions.setForce(this.force, null);
    }

    public void setOutputDirectory(String aDir) {
        this.outdir = aDir;
    }

    public void addUnit(File f) {
        this.addUnit(f.toString());
    }

    private void addUnit(TranslationUnit unit) {
        if (this.translator == null) {
            try {
                this.translator = new Translator(this.translatorOptions, null, this.log);
            }
            catch (TranslationException e) {
                this.log.logError(e.getMessage(), 0, 0, 0, 0);
            }
        }
        try {
            this.translator.addUnit(unit);
        }
        catch (TranslationException e) {
            this.log.logError(e.getMessage(), 1, 1, 1, 1);
        }
    }

    public void addUnit(String sqljFile) {
        this.addUnit(new TranslationOfflineUnit(sqljFile, this.log));
    }

    public void addAndTranslate(String sqljFile) {
        this.addUnit(sqljFile);
        this.translate();
    }

    public void addAndTranslate(InputStream stream, String fileName) {
        this.addUnit(stream, fileName);
        this.translate();
    }

    private void addUnit(InputStream stream, String fileName) {
        this.addUnit(new TranslationOfflineUnit(stream, fileName, this.log));
    }

    public void translate() {
        if (this.translator != null) {
            this.translator.translate();
            this.translator = null;
        } else {
            this.log.logWarning("no unit for translation", 0, 0, 0, 0);
        }
    }

    public void resetCatalogBuffer() {
        if (this.translator != null) {
            this.translator.resetCatalogReader();
        }
    }

    public void invalidateTable(String name) {
        if (this.translator != null) {
            this.translator.resetTableDescription(name);
        }
    }

    private static InputStream getInputStream(String aFileName, TranslationLog log) {
        File file = new File(aFileName);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            String msg = "FileNotFoundException on opening file " + aFileName + ": " + e.getMessage();
            LOCATION.traceThrowableT(500, msg, (Throwable)e);
            log.logError(msg, 0, 0, 0, 0);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TranslationOfflineUnit
    implements TranslationUnit {
        private TranslationLog translationLog;
        private TranslationOfflineInput translationInput;
        private TranslationOfflineOutput translationOutput;
        private String sqljFileName;
        private String javaFileName;
        private StringWriter outWriter;
        private String packageName = null;
        private boolean generateOutput;

        public TranslationOfflineUnit(String aFileName, TranslationLog log) {
            this(TranslatorApi.getInputStream(aFileName, log), aFileName, log);
            this.generateOutput = true;
        }

        public TranslationOfflineUnit(InputStream stream, String aFileName, TranslationLog log) {
            this.sqljFileName = aFileName;
            String filePre = this.sqljFileName.substring(0, aFileName.lastIndexOf(46));
            this.javaFileName = filePre + ".java";
            this.translationInput = new TranslationOfflineInput(stream, aFileName);
            this.translationOutput = new TranslationOfflineOutput();
            this.translationLog = new TranslationUnitLog(log);
            this.generateOutput = false;
        }

        public File getInFile() {
            return new File(this.translationInput.getPath());
        }

        public File getOutFile() {
            if (TranslatorApi.this.outdir == null) {
                return new File(this.javaFileName);
            }
            if (this.packageName == null) {
                return new File(TranslatorApi.this.outdir, new File(this.javaFileName).getName());
            }
            return new File(TranslatorApi.this.outdir + File.separator + this.packageName, new File(this.javaFileName).getName());
        }

        public TranslationInput getInput() throws IOException {
            return this.translationInput;
        }

        public TranslationOutput getOutput() throws IOException {
            return this.translationOutput;
        }

        public TranslationLog getErrorLog() {
            return this.translationLog;
        }

        public TranslationLog getOfflineErrorLog() {
            return this.translationLog;
        }

        public void setPackageName(String pkg) {
            if (pkg != null) {
                this.packageName = pkg.replace('.', File.separatorChar);
            }
        }

        private void writeOutput(String txt) throws IOException {
            File outFile = this.getOutFile();
            File parent = new File(outFile.getParent());
            parent.mkdirs();
            FileWriter fw = new FileWriter(outFile);
            fw.write(txt.toCharArray());
            fw.close();
        }

        public void translationComplete(boolean result) throws IOException {
            this.outWriter.close();
            if (this.generateOutput) {
                File oldFile = this.getOutFile();
                if (!result) {
                    if (oldFile.exists() && !oldFile.delete()) {
                        TranslatorApi.this.log.logError(TranslatorErrors.cannot_delete_file(oldFile.getPath()), 0, 0, 0, 0);
                    }
                } else {
                    String sourceText = this.outWriter.toString();
                    if (sourceText.length() > 0) {
                        if (oldFile.exists()) {
                            if (oldFile.delete()) {
                                this.writeOutput(sourceText);
                            } else {
                                TranslatorApi.this.log.logError(TranslatorErrors.cannot_delete_file(oldFile.getPath()), 0, 0, 0, 0);
                            }
                        } else {
                            this.writeOutput(sourceText);
                        }
                    }
                }
                this.outWriter = null;
            }
        }

        public ClassResolver getClassResolver() {
            return new ClassResolverImpl(null, null);
        }

        class TranslationUnitLog
        implements TranslationLog {
            TranslationLog parent;

            TranslationUnitLog(TranslationLog aLog) {
                this.parent = aLog;
            }

            public void logError(String message, int beginLine, int beginCol, int endLine, int endCol) {
                this.parent.logError("file " + TranslationOfflineUnit.this.sqljFileName + ": " + message, beginLine, beginCol, endLine, endCol);
            }

            public void logWarning(String message, int beginLine, int beginCol, int endLine, int endCol) {
                this.parent.logWarning("file " + TranslationOfflineUnit.this.sqljFileName + ": " + message, beginLine, beginCol, endLine, endCol);
            }

            public void logInfo(String message, int beginLine, int beginCol, int endLine, int endCol) {
                this.parent.logInfo("file " + TranslationOfflineUnit.this.sqljFileName + ": " + message, beginLine, beginCol, endLine, endCol);
            }
        }

        class TranslationOfflineOutput
        implements TranslationOutput {
            TranslationOfflineOutput() {
                TranslationOfflineUnit.this.outWriter = new StringWriter();
            }

            public Writer getWriter() {
                return TranslationOfflineUnit.this.outWriter;
            }

            public OutputStream createOutputStream(String filename) {
                throw new IllegalStateException("profiles not supported");
            }
        }

        class TranslationOfflineInput
        implements TranslationByteInput {
            private InputStream stream;
            private String fileName;

            TranslationOfflineInput(InputStream aStream, String aFileName) {
                this.stream = aStream;
                this.fileName = aFileName;
            }

            public InputStream getInputStream() {
                return this.stream;
            }

            public String getPath() {
                return this.fileName;
            }

            public String getName() {
                return TranslationOfflineUnit.this.sqljFileName;
            }

            public InputStream getInStream() {
                return this.getInputStream();
            }
        }
    }
}

