/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.syntax;

import com.sap.sql.sqlj.semantics.SQLTokenizer;
import com.sap.sql.sqlj.syntax.BindExpr;
import com.sap.sql.sqlj.syntax.Elem;
import com.sap.sql.sqlj.syntax.IntoBindExpr;
import com.sap.sql.sqlj.syntax.ReturnBindExpr;
import com.sap.sql.sqlj.syntax.Token;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.io.ErrorLogger;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SQLUnit {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$syntax$SQLUnit == null ? (class$com$sap$sql$sqlj$syntax$SQLUnit = SQLUnit.class$("com.sap.sql.sqlj.syntax.SQLUnit")) : class$com$sap$sql$sqlj$syntax$SQLUnit));
    private Parselet scope;
    private StringBuffer sqlStringBuffer = new StringBuffer();
    private StringBuffer javaCommentText = new StringBuffer();
    Vector bindList = new Vector();
    Vector markerList = null;
    int operType = 1023;
    private Serializable descriptor;
    private boolean isFetch;
    private boolean isSelect;
    private boolean hasDynamicParameters;
    boolean debug = false;
    static /* synthetic */ Class class$com$sap$sql$sqlj$syntax$SQLUnit;

    SQLUnit() {
        this.isFetch = false;
        this.isSelect = false;
        this.hasDynamicParameters = false;
    }

    SQLUnit(Token t) {
        this.isSelect = t.kind == 20;
        this.isFetch = t.kind == 21 || this.isSelect;
        this.addToken(t.specialToken);
    }

    void addToken(Token t) {
        if (t != null) {
            this.addToken(t.specialToken);
            if (this.sqlStringBuffer.length() > 0) {
                this.sqlStringBuffer.append(t.image);
                this.javaCommentText.append(t.image);
            } else if (t.kind != 8) {
                this.sqlStringBuffer.append(t.image);
                this.javaCommentText.append(t.image);
            }
        }
    }

    void addQuestionMark(Token t1) {
        if (t1 != null) {
            this.addToken(t1.specialToken);
        }
        this.sqlStringBuffer.append(" ? ");
        this.javaCommentText.append(":");
        this.markerList = null;
        this.hasDynamicParameters = true;
    }

    public void addSpace() {
        this.sqlStringBuffer.append(" ");
    }

    public void setSQL(String sql) {
        this.sqlStringBuffer = new StringBuffer(sql);
        this.markerList = null;
    }

    public String getSQL() {
        if (this.debug) {
            System.out.println("[" + this.sqlStringBuffer.toString() + "]");
            this.debug = false;
        }
        return this.sqlStringBuffer.toString();
    }

    void getTextTo(StringBuffer b) {
        b.append(this.javaCommentText.toString());
    }

    void addBindExpr(BindExpr expr) {
        this.bindList.addElement(expr);
        if (expr != null) {
            expr.getTextTo(this.javaCommentText);
            expr.setScope(this.scope);
        }
    }

    void addIntoBindExpr(Token t, IntoBindExpr e) {
        this.addToken(t.specialToken);
        this.addBindExpr(e);
        this.sqlStringBuffer.append(" ");
    }

    public void prependBindExpr(BindExpr expr) {
        this.insertBindExprAt(expr, 1);
    }

    public void insertBindExprAt(BindExpr e, int i) {
        this.bindList.insertElementAt(e, i - 1);
        if (e != null) {
            e.setScope(this.scope);
        }
    }

    public Enumeration getBindExprs() {
        return this.bindList.elements();
    }

    public IntoBindExpr getIntoBindExpr() {
        Enumeration e = this.getBindExprs();
        while (e.hasMoreElements()) {
            BindExpr be = (BindExpr)e.nextElement();
            if (!(be instanceof IntoBindExpr)) continue;
            return (IntoBindExpr)be;
        }
        return null;
    }

    public ReturnBindExpr getReturnBindExpr() {
        Enumeration e = this.getBindExprs();
        while (e.hasMoreElements()) {
            BindExpr be = (BindExpr)e.nextElement();
            if (!(be instanceof ReturnBindExpr)) continue;
            return (ReturnBindExpr)be;
        }
        return null;
    }

    public int getNumActualBindExprs() {
        int i = 0;
        Enumeration e = this.getBindExprs();
        while (e.hasMoreElements()) {
            if (((BindExpr)e.nextElement()).isVirtual()) continue;
            ++i;
        }
        return i;
    }

    public void setOperationType(int type) {
        this.operType = type;
    }

    public int getOperationType() {
        return this.operType;
    }

    public int getMarkerPosition(int n) {
        if (this.markerList == null) {
            this.markerList = new Vector();
            SQLTokenizer s = new SQLTokenizer(new ErrorLogger(), this.sqlStringBuffer.toString());
            while (s.hasMoreElements()) {
                antlr.Token t = (antlr.Token)s.nextElement();
                if (t.getType() != 127) continue;
                this.markerList.addElement(new Integer(t.getLine()));
            }
        }
        try {
            return (Integer)this.markerList.elementAt(n - 1);
        }
        catch (Exception e) {
            LOCATION.catching((Throwable)e);
            return -1;
        }
    }

    Enumeration getTokenList() {
        throw new RuntimeException();
    }

    void setScope(Parselet s) {
        this.scope = s;
        Enumeration enumeration = this.getBindExprs();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof Parselet) {
                Parselet p = (Parselet)obj;
                p.setScope(this.scope);
                continue;
            }
            if (obj instanceof Elem) {
                Elem e = (Elem)obj;
                e.setScope(this.scope);
                continue;
            }
            if (obj instanceof BindExpr) {
                BindExpr b = (BindExpr)obj;
                b.setScope(this.scope);
                continue;
            }
            if (!(obj instanceof SQLUnit)) continue;
            SQLUnit u = (SQLUnit)obj;
            u.setScope(this.scope);
        }
    }

    public void setDescriptor(Serializable d) {
        this.descriptor = d;
    }

    public Serializable getDescriptor() {
        return this.descriptor;
    }

    boolean isFetchStatement() {
        return this.isFetch;
    }

    boolean isSelectStatement() {
        return this.isSelect;
    }

    public boolean hasDynamivParameters() {
        return this.hasDynamicParameters;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

