/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.semantics;

import com.sap.sql.catalog.CatalogBufferManager;
import com.sap.sql.sqlj.codegen.ParseletFactory;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.ide.TranslationOptionsQuery;
import com.sap.sql.sqlj.framework.options.ConnectionFactory;
import com.sap.sql.sqlj.framework.options.HasOptions;
import com.sap.sql.sqlj.framework.options.InvalidOptionException;
import com.sap.sql.sqlj.framework.options.OptionGroup;
import com.sap.sql.sqlj.framework.options.OptionInfoArray;
import com.sap.sql.sqlj.framework.options.PropertyList;
import com.sap.sql.sqlj.framework.options.PropertyListImpl;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.mesg.SemanticOptions;
import com.sap.sql.sqlj.mesg.TranslatorErrors;
import com.sap.sql.sqlj.semantics.ConnectionManager;
import com.sap.sql.sqlj.semantics.ContextAnalysis;
import com.sap.sql.sqlj.semantics.CursorAnalysis;
import com.sap.sql.sqlj.semantics.ExecAnalysis;
import com.sap.sql.sqlj.semantics.SemanticAnalyzer;
import com.sap.sql.sqlj.syntax.ClassElem;
import com.sap.sql.sqlj.syntax.ContextElem;
import com.sap.sql.sqlj.syntax.CursorElem;
import com.sap.sql.sqlj.syntax.Elem;
import com.sap.sql.sqlj.syntax.ExecElem;
import com.sap.sql.sqlj.util.Disposable;
import com.sap.sql.sqlj.util.TranslationContext;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class SemanticAnalyzerFactory
implements HasOptions {
    private static final int invalid_mode = -999;
    private static Hashtable interestingOptions = null;
    private ConnectionFactory m_connFact = new ConnectionFactory();
    private TranslationOptionsQuery m_qp = null;
    private SemanticAnalyzerFactory m_myself = null;
    private Map m_presetCatalogReaders = null;
    private String[] checker_tags = new String[]{"warn", "online", "driver", "classpath", "sourcepath"};
    private boolean[] checker_taggability = new boolean[]{false, false, false, false, false};
    private String[] context_tags = new String[]{"user", "password", "catalogReader"};
    private boolean[] context_taggability = new boolean[]{true, true, true};
    protected Boolean TRUE = new Boolean(true);
    TranslationContext m_tc = null;
    ConnectionManager m_cm = null;
    ParseletFactory m_pf = null;
    private ErrorLog m_options_error_log;
    private boolean m_warn_done = false;
    private boolean m_verbose;
    private boolean m_nulls;
    private boolean m_precision;
    private boolean m_portable;
    private boolean m_strict;
    private OptionGroup m_og;
    private HasOptions m_checker_options;
    private HasOptions m_context_options;
    Hashtable m_all_options = new Hashtable();
    Hashtable m_all_infos = new Hashtable();
    Hashtable m_taggable_options = new Hashtable();

    public static void captureInterestingOptions() {
        interestingOptions = new Hashtable();
    }

    public static Hashtable getInterestingOptions() {
        Hashtable h = interestingOptions;
        interestingOptions = null;
        return h;
    }

    public SemanticAnalyzerFactory(TranslationContext tc, ParseletFactory pf, Map presetCatalogReaders) {
        this(pf, presetCatalogReaders);
        this.m_tc = tc;
        if (this.m_tc != null) {
            this.registerOptionsQuery(this.m_tc.getOptionsQuery());
        }
    }

    private SemanticAnalyzerFactory(ParseletFactory pf, Map presetCatalogReaders) {
        this.m_pf = pf;
        this.m_cm = new ConnectionManager(this, presetCatalogReaders);
        this.initializeOptions();
        this.m_myself = this;
        this.m_presetCatalogReaders = presetCatalogReaders;
    }

    public SemanticAnalyzer newSemanticAnalyzer(Elem decl) {
        throw new IllegalArgumentException("SemanticAnalyzerFactory.newSemanticAnalyzer(Elem) - illegal argument type");
    }

    public SemanticAnalyzer newSemanticAnalyzer(ClassElem decl) {
        throw new IllegalArgumentException("SemanticAnalyzerFactory.newSemanticAnalyzer(ClassElem) - illegal argument type");
    }

    public SemanticAnalyzer newSemanticAnalyzer(ExecElem elem) {
        return new ExecAnalysis(elem, this);
    }

    public SemanticAnalyzer newSemanticAnalyzer(CursorElem elem) {
        return new CursorAnalysis(elem, this);
    }

    public SemanticAnalyzer newSemanticAnalyzer(ContextElem elem) {
        return new ContextAnalysis(elem, this);
    }

    public void registerOptionsQuery(TranslationOptionsQuery qp) {
        this.m_cm.registerOptionsQuery(qp);
        this.m_qp = qp;
    }

    public String getOnline() {
        return this.getOption("online");
    }

    public boolean getVerbose() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_verbose;
    }

    public boolean getNulls() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_nulls;
    }

    public boolean getPrecision() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_precision;
    }

    public boolean getPortable() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_portable;
    }

    public boolean getStrict() {
        if (!this.m_warn_done) {
            this.processWarn();
        }
        return this.m_strict;
    }

    private void processWarn() {
        Enumeration e = this.enumerate(this.getOption("warn"));
        while (e.hasMoreElements()) {
            String flag = ((String)e.nextElement()).toLowerCase();
            if (flag.equals("none")) {
                this.m_verbose = false;
                this.m_nulls = false;
                this.m_precision = false;
                this.m_portable = false;
                this.m_strict = false;
                continue;
            }
            if (flag.equals("all")) {
                this.m_verbose = true;
                this.m_nulls = true;
                this.m_precision = true;
                this.m_portable = true;
                this.m_strict = true;
                continue;
            }
            if (flag.equals("verbose")) {
                this.m_verbose = true;
                continue;
            }
            if (flag.equals("noverbose")) {
                this.m_verbose = false;
                continue;
            }
            if (flag.equals("nulls")) {
                this.m_nulls = true;
                continue;
            }
            if (flag.equals("nonulls")) {
                this.m_nulls = false;
                continue;
            }
            if (flag.equals("precision")) {
                this.m_precision = true;
                continue;
            }
            if (flag.equals("noprecision")) {
                this.m_precision = false;
                continue;
            }
            if (flag.equals("portable")) {
                this.m_portable = true;
                continue;
            }
            if (flag.equals("noportable")) {
                this.m_portable = false;
                continue;
            }
            if (flag.equals("strict")) {
                this.m_strict = true;
                continue;
            }
            if (flag.equals("nostrict")) {
                this.m_strict = false;
                continue;
            }
            this.m_options_error_log.addEntry(new JSError(SemanticErrors.invalidWarnOption(flag)));
        }
        this.m_warn_done = true;
    }

    public int getDefaultFunctionMode() {
        return 1;
    }

    public int getDefaultProcedureMode() {
        return 1;
    }

    public int getDefaultBlockMode() {
        return 1;
    }

    public Enumeration getDrivers() {
        return this.enumerate(this.getOption("driver"));
    }

    public String getClasspath() {
        return this.getOption("classpath");
    }

    public String getSourcepath() {
        return this.getOption("sourcepath");
    }

    public String getUser() {
        return this.getUser(null);
    }

    public String getUser(String ctx) {
        return this.getOption(ctx, "user");
    }

    public String getPassword() {
        return this.getPassword(null);
    }

    public String getPassword(String ctx) {
        return this.getOption(ctx, "password");
    }

    public String getCatalogReader() {
        return this.getCatalogReader(null);
    }

    public String getCatalogReader(String ctx) {
        String catalogReader = this.getOption(ctx, "catalogReader");
        if (catalogReader != null && catalogReader.equals("")) {
            catalogReader = null;
        }
        return catalogReader;
    }

    private void initializeOptions() {
        String[][] info = new String[this.checker_tags.length + this.context_tags.length][];
        boolean[] taggability = new boolean[this.checker_tags.length + this.context_tags.length];
        int i = 0;
        while (i < this.checker_tags.length) {
            info[i] = SemanticOptions.getOptionInfo(this.checker_tags[i]);
            taggability[i] = this.checker_taggability[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.context_tags.length) {
            info[i2 + this.checker_tags.length] = SemanticOptions.getOptionInfo(this.context_tags[i2]);
            taggability[i2 + this.checker_tags.length] = this.context_taggability[i2];
            ++i2;
        }
        this.m_og = new OptionGroup();
        this.m_og.addElement(new TaggedOptions(info, taggability));
    }

    public void setOptions(PropertyList props, ErrorLog log) throws InvalidOptionException {
        this.m_options_error_log = log;
        this.m_og.setOptions(props, log);
        if (interestingOptions != null) {
            Enumeration e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("driver")) continue;
                interestingOptions.put(key, props.getProperty(key));
            }
        }
    }

    public String[][] getOptionInfo() {
        return this.m_og.getOptionInfo();
    }

    private String getOption(String context, String key) {
        String value;
        PropertyList prop;
        if (context == null) {
            context = "";
        }
        if ((prop = (PropertyList)this.m_all_options.get(key)) == null) {
            value = null;
        } else {
            value = prop.getProperty(context);
            if (value != null) {
                value = value.trim();
            }
        }
        return value;
    }

    private String getOption(String key) {
        return this.getOption(null, key);
    }

    private boolean getBooleanOption(String key) {
        String s = this.getOption(key);
        if (s == null) {
            s = "";
        }
        if ((s = s.toLowerCase().trim()).equals("1") || s.equals("y") || s.equals("yes") || s.equals("t") || s.equals("true") || s.equals("on") || s.equals("+")) {
            return true;
        }
        if (s.equals("0") || s.equals("n") || s.equals("no") || s.equals("f") || s.equals("false") || s.equals("off") || s.equals("-")) {
            return false;
        }
        this.m_options_error_log.addEntry(new JSError(SemanticErrors.illegalBooleanOptionEntry(key, s)));
        return false;
    }

    private Enumeration enumerate(String s) {
        return new StringTokenizer(s, " \t,");
    }

    public void resetTableDescription(String contextName, String tableName) {
        CatalogBufferManager.invalidateTable((String)contextName, null, (String)tableName);
    }

    public void resetCatalogReader(String contextName) {
        CatalogBufferManager.resetBuffer((String)contextName);
    }

    class Cleanup
    implements Disposable {
        Cleanup() {
        }

        public void dispose() {
            SemanticAnalyzerFactory.this.m_cm = new ConnectionManager(SemanticAnalyzerFactory.this.m_myself, SemanticAnalyzerFactory.this.m_presetCatalogReaders);
            SemanticAnalyzerFactory.this.m_cm.registerOptionsQuery(SemanticAnalyzerFactory.this.m_qp);
        }
    }

    class TaggedOptions
    implements HasOptions {
        public TaggedOptions(String[][] infoOpts, boolean[] taggable) {
            int i = 0;
            while (i < infoOpts.length) {
                PropertyListImpl pi = new PropertyListImpl();
                SemanticAnalyzerFactory.this.m_all_options.put(infoOpts[i][0], pi);
                SemanticAnalyzerFactory.this.m_all_infos.put(infoOpts[i][0], infoOpts[i]);
                if (taggable[i]) {
                    SemanticAnalyzerFactory.this.m_taggable_options.put(infoOpts[i][0], SemanticAnalyzerFactory.this.TRUE);
                }
                if (infoOpts[i][2] != null) {
                    pi.addProperty("", infoOpts[i][2], infoOpts[i][4]);
                }
                ++i;
            }
        }

        public void setOptions(PropertyList props, ErrorLog log) throws InvalidOptionException {
            int error_count = 0;
            Enumeration keys = props.propertyNames(false);
            while (keys.hasMoreElements()) {
                PropertyListImpl optProps;
                String option;
                String origOption = (String)keys.nextElement();
                String key = option = origOption.trim();
                String tag = null;
                int at_pos = key.indexOf("@");
                if (at_pos >= 0) {
                    key = option.substring(0, at_pos).trim();
                    tag = option.substring(at_pos + 1).trim();
                }
                if (tag == null) {
                    tag = "";
                }
                if ((optProps = (PropertyListImpl)SemanticAnalyzerFactory.this.m_all_options.get(key)) == null) continue;
                if (!tag.equals("") && SemanticAnalyzerFactory.this.m_taggable_options.get(key) == null) {
                    log.addEntry(new JSError(TranslatorErrors.option_not_taggable(key, tag)));
                    ++error_count;
                    continue;
                }
                if (error_count != 0) continue;
                String value = props.getProperty(origOption);
                String loc = props.getPropertyLocation(origOption);
                if (key.equals("user") && value != null) {
                    SemanticAnalyzerFactory.this.m_connFact.resetConnectData();
                    SemanticAnalyzerFactory.this.m_connFact.setUser(value);
                    optProps.addProperty(tag, SemanticAnalyzerFactory.this.m_connFact.getUser(), loc);
                    SemanticAnalyzerFactory.this.m_all_options.put(key, optProps);
                    String password = SemanticAnalyzerFactory.this.m_connFact.getPassword();
                    if (password == null) continue;
                    optProps = (PropertyListImpl)SemanticAnalyzerFactory.this.m_all_options.get("password");
                    optProps.addProperty(tag, password, loc);
                    SemanticAnalyzerFactory.this.m_all_options.put("password", optProps);
                    continue;
                }
                optProps.addProperty(tag, value, loc);
                SemanticAnalyzerFactory.this.m_all_options.put(key, optProps);
            }
            if (error_count > 0) {
                throw new InvalidOptionException("One or more errors orrured during option processing");
            }
        }

        public String[][] getOptionInfo() {
            Enumeration keys = SemanticAnalyzerFactory.this.m_all_options.keys();
            OptionInfoArray infoBuf = new OptionInfoArray();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                boolean described_default = false;
                PropertyList pl = (PropertyList)SemanticAnalyzerFactory.this.m_all_options.get(key);
                String[] descr = (String[])SemanticAnalyzerFactory.this.m_all_infos.get(key);
                String[] info = new String[]{descr[0], descr[1], descr[2], descr[3], descr[4]};
                if (!pl.propertyNames().hasMoreElements()) {
                    infoBuf.addInfo(info);
                } else if (pl.getProperty("") != null) {
                    info[2] = pl.getProperty("");
                    info[4] = pl.getPropertyLocation("");
                    infoBuf.addInfo(info);
                    described_default = true;
                }
                Enumeration tags = pl.propertyNames();
                while (tags.hasMoreElements()) {
                    String tag = (String)tags.nextElement();
                    if (!described_default) {
                        info[2] = pl.getProperty(tag);
                        info[4] = pl.getPropertyLocation("");
                        infoBuf.addInfo(info);
                        described_default = true;
                        continue;
                    }
                    if (tag.equals("")) continue;
                    String[] value_desc = new String[]{key + "@" + tag, null, pl.getProperty(tag), null, pl.getPropertyLocation(tag)};
                    infoBuf.addInfo(value_desc);
                }
            }
            return infoBuf.getInfo();
        }
    }
}

