/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.semantics;

import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.semantics.ClassAnalysis;
import com.sap.sql.sqlj.semantics.SemanticAnalyzer;
import com.sap.sql.sqlj.semantics.SemanticAnalyzerFactory;
import com.sap.sql.sqlj.syntax.ContextElem;
import com.sap.sql.sqlj.syntax.Elem;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.tc.logging.Location;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

class ContextAnalysis
extends ClassAnalysis
implements SemanticAnalyzer {
    private ContextElem context_elem;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$semantics$ContextAnalysis == null ? (class$com$sap$sql$sqlj$semantics$ContextAnalysis = ContextAnalysis.class$("com.sap.sql.sqlj.semantics.ContextAnalysis")) : class$com$sap$sql$sqlj$semantics$ContextAnalysis));
    static /* synthetic */ Class class$com$sap$sql$sqlj$semantics$ContextAnalysis;

    ContextAnalysis(Elem elem, SemanticAnalyzerFactory saf) {
        super(elem, saf);
        if (!(elem instanceof ContextElem)) {
            throw new IllegalArgumentException("ContextAnalysis(elem): not a ContextElem");
        }
        this.context_elem = (ContextElem)elem;
    }

    public boolean prepare() {
        super.prepare();
        this.checkInnerClass();
        this.checkWithClause();
        this.checkInterfaces();
        return !this.unpreparable;
    }

    private void checkInnerClass() {
        int modifiers;
        if (this.isInner() && !Modifier.isStatic(modifiers = this.context_elem.getModifiers())) {
            String outerName;
            Parselet outer = this.outer();
            ClassDescriptor type = (ClassDescriptor)outer.getDescriptor();
            try {
                outerName = type.getReflection().getName();
            }
            catch (ClassNotFoundException ex) {
                LOCATION.catching((Throwable)ex);
                outerName = "???";
            }
            this.logError(SemanticErrors.message("contextInnerClass", this.context_elem.getClassName(), outerName));
        }
    }

    private void checkWithClause() {
        Enumeration fields = this.context_elem.getWithKeywords();
        while (fields.hasMoreElements()) {
            String f_name = (String)fields.nextElement();
            if (f_name.equals("dataSource") || !this.saf.getPortable()) continue;
            this.logWarning(SemanticErrors.nonStandardContextAttribute(f_name));
        }
    }

    protected final void isValidInterface(BaseJSClass jsClass) {
        String anInterface = jsClass.getName();
        if (!anInterface.equals("sqlj.runtime.ForUpdate")) {
            this.logError(SemanticErrors.notConnectionContextInterface(anInterface));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

