/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.javac;

import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.javac.ExpressionNode;
import com.sap.sql.sqlj.javac.JavaParserImpl;
import com.sap.sql.sqlj.javac.Token;

public class TernaryOperatorNode
extends ExpressionNode {
    ExpressionNode operand1;
    String operatorText1;
    ExpressionNode operand2;
    String operatorText2;
    ExpressionNode operand3;

    TernaryOperatorNode(JavaParserImpl p, ExpressionNode e1, Token t1, ExpressionNode e2, Token t2, ExpressionNode e3) {
        super(p);
        this.operand1 = e1;
        this.operatorText1 = t1.getText();
        this.operand2 = e2;
        this.operatorText2 = t2.getText();
        this.operand3 = e3;
    }

    int getRow() {
        return this.operand1.getRow();
    }

    int getColumn() {
        return this.operand1.getColumn();
    }

    public final void getTextTo(StringBuffer b) {
        this.operand1.getTextTo(b);
        b.append(this.operatorText1);
        this.operand2.getTextTo(b);
        b.append(this.operatorText2);
        this.operand3.getTextTo(b);
    }

    void scopeChanged() {
        this.operand1.setScope(this.getScope());
        this.operand2.setScope(this.getScope());
        this.operand3.setScope(this.getScope());
    }

    JSClass getType() {
        if (this.operand1.isBooleanType()) {
            if (this.operand2.isNumericType() && this.operand3.isNumericType()) {
                return this.operand2.getType().promoteBinaryNumeric(this.operand3.getType());
            }
            if (this.operand2.isBooleanType() && this.operand3.isBooleanType()) {
                return JSClass.boolean_TYPE;
            }
            if (this.operand2.getType() != null && this.operand3.getType() != null) {
                if (this.operand2.getType().isAssignableFrom(this.operand3.getType())) {
                    return this.operand2.getType();
                }
                if (this.operand3.getType().isAssignableFrom(this.operand2.getType())) {
                    return this.operand3.getType();
                }
            }
            this.Error(23);
            return null;
        }
        this.Error(22);
        return null;
    }
}

