/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.javac;

import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.javac.ASTBlock;
import com.sap.sql.sqlj.javac.ExpressionNode;
import com.sap.sql.sqlj.javac.JavaParserImpl;
import com.sap.sql.sqlj.javac.JavaParserImplTreeConstants;
import com.sap.sql.sqlj.javac.Node;
import com.sap.sql.sqlj.javac.SymTabEntry;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.ClassNameResolver;
import com.sap.sql.sqlj.util.OutputContext;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.TypeDescriptor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SimpleNode
implements Node {
    private Node parent;
    private Node[] children;
    private int id;
    private static Node prunedNode = new SimpleNode(20);
    private String name = null;
    private int beginLine = -1;
    private int beginColumn = -1;
    protected Node enclosingClass = null;
    protected Node definingUnit = null;
    protected Hashtable symtab = null;
    private Node javaScope = null;
    private Parselet scope = null;
    protected TypeDescriptor desc = null;
    private Object info = null;
    static int totalCount = 0;
    int lastNodeCountTime = 0;

    SimpleNode() {
        this(-1);
    }

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(JavaParserImpl p, int i) {
        this(i);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (n instanceof ASTBlock && !n.hasSQL()) {
            n = prunedNode;
        }
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return this.id < 0 ? "<unknown>" : JavaParserImplTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            SimpleNode n = (SimpleNode)this.jjtGetChild(i);
            if (n != null) {
                n.dump(prefix + " ");
            }
            ++i;
        }
    }

    public void setName(String nam) {
        this.name = nam;
    }

    public int setName(String nam, ErrorLog elog) {
        this.setName(nam);
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void setBeginLine(int line) {
        this.beginLine = line;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setBeginColumn(int column) {
        this.beginColumn = column;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public Vector jjtGetChildren() {
        Vector<Node> v = new Vector<Node>();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            v.addElement(this.jjtGetChild(i));
            ++i;
        }
        return v;
    }

    public Node jjtGetLastChild() {
        if (this.jjtGetNumChildren() > 0) {
            return this.jjtGetChild(this.jjtGetNumChildren() - 1);
        }
        return null;
    }

    public void addSymTab(Node n) {
        if (n == null || n.getSymTab() == null) {
            return;
        }
        Enumeration e = n.getSymTab().elements();
        if (this.symtab == null) {
            this.symtab = new Hashtable();
        }
        while (e.hasMoreElements()) {
            SymTabEntry se = (SymTabEntry)e.nextElement();
            if (se.isType) {
                this.insertSymTab(se.typ.getName(), se);
                continue;
            }
            this.insertSymTab(se.var.getName(), se);
        }
    }

    public Hashtable getSymTab() {
        return this.symtab;
    }

    public void insertSymTab(String key, SymTabEntry s) {
        this.symtab.put(key, s);
    }

    public void insertSymTab(Node n, Node t, int m) {
        if (t.getName() != null) {
            if (this.symtab == null) {
                this.symtab = new Hashtable();
            }
            this.insertSymTab(n.getName(), new SymTabEntry(n, t, m));
        }
    }

    public void insertSymTab(Node n, Node t, int m, ExpressionNode init) {
        if (t.getName() != null) {
            if (this.symtab == null) {
                this.symtab = new Hashtable();
            }
            this.insertSymTab(n.getName(), new SymTabEntry(n, t, m, init));
        }
    }

    public void insertSymTab(Node t, int m) {
    }

    public Node findName(String name, int line, int column) {
        SymTabEntry se;
        if (this.symtab != null && (se = (SymTabEntry)this.symtab.get(name)) != null && !se.isType) {
            Node var = se.var;
            Node typ = se.typ;
            int mod = se.mod;
            if (this instanceof ASTBlock) {
                if (line > var.getBeginLine() || line == var.getBeginLine() && column > var.getBeginColumn()) {
                    return typ;
                }
            } else {
                return typ;
            }
        }
        return null;
    }

    public int getModifiers(String name, int line, int column) {
        Node n;
        SymTabEntry se;
        if (this.symtab != null && (se = (SymTabEntry)this.symtab.get(name)) != null && !se.isType) {
            if (this instanceof ASTBlock) {
                if (line > se.var.getBeginLine() || line == se.var.getBeginLine() && column > se.var.getBeginColumn()) {
                    return se.mod;
                }
            } else {
                return se.mod;
            }
        }
        return (n = (Node)this.getScope()) == null ? 0 : n.getModifiers(name, line, column);
    }

    public JSClass lookupVarDecl(String name, int line, int column) throws ClassNotFoundException {
        Node t = this.findName(name, line, column);
        if (t != null) {
            ClassDescriptor cd = (ClassDescriptor)t.getDescriptor();
            return cd == null ? null : cd.getReflection();
        }
        Node s = (Node)this.getScope();
        return s == null ? null : s.lookupVarDecl(name, line, column);
    }

    public SymTabEntry getSymTabEntry(String name, int line, int column) {
        SimpleNode s;
        SymTabEntry se;
        if (this.symtab != null && (se = (SymTabEntry)this.symtab.get(name)) != null && !se.isType) {
            if (this instanceof ASTBlock) {
                if (line > se.var.getBeginLine() || line == se.var.getBeginLine() && column > se.var.getBeginColumn()) {
                    return se;
                }
            } else {
                return se;
            }
        }
        return (s = (SimpleNode)this.getScope()) == null ? null : s.getSymTabEntry(name, line, column);
    }

    public void printSymTab() {
        Enumeration e = this.symtab.elements();
        while (e.hasMoreElements()) {
            SymTabEntry se = (SymTabEntry)e.nextElement();
            if (!se.isType) {
                System.out.println("Var name is: " + se.var.getName() + ".");
            }
            System.out.println("Type name is: " + se.typ.getName() + ".");
        }
    }

    public String getVarName() {
        return null;
    }

    public void setScope(Parselet scope) {
        if (this.scope != null) {
            throw new IllegalArgumentException("scope already set");
        }
        this.scope = scope;
    }

    public Parselet getScope() {
        return this.scope == null ? this.jjtGetParent() : this.scope;
    }

    public Node getJavaScope() {
        if (this.javaScope != null) {
            return this.javaScope;
        }
        Parselet jscope = this;
        if (this.getScope() == null) {
            throw new NullPointerException("Internal error -- null scope for node " + this.toString());
        }
        while (!((jscope = jscope.getScope()) instanceof Node)) {
        }
        this.javaScope = jscope;
        return this.javaScope;
    }

    public Parselet getEnclosingClass() {
        if (this.enclosingClass != null) {
            return this.enclosingClass;
        }
        this.enclosingClass = (Node)this.getJavaScope().getEnclosingClass();
        return this.enclosingClass;
    }

    public Parselet getDefiningUnit() {
        if (this.definingUnit != null) {
            return this.definingUnit;
        }
        this.definingUnit = (Node)this.getJavaScope().getDefiningUnit();
        return this.definingUnit;
    }

    public ClassNameResolver getClassResolver() {
        return this.getJavaScope().getClassResolver();
    }

    public TypeDescriptor getDescriptor() {
        if (this.desc != null) {
            return this.desc;
        }
        this.desc = new TypeDescriptor();
        return this.desc;
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public Object getInfo() {
        return this.info;
    }

    public boolean generate(OutputContext octx) throws IOException, ConfigurationException {
        return true;
    }

    protected void setDescriptor(TypeDescriptor tds) {
        this.desc = tds;
    }

    public boolean hasSQL() {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            if (this.jjtGetChild(i).hasSQL()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int numNodes() {
        return this.numNodes(++totalCount);
    }

    public int numNodes(int n) {
        int result;
        if (this.lastNodeCountTime == n) {
            result = 0;
        } else {
            this.lastNodeCountTime = n;
            result = 1;
            int i = 0;
            while (i < this.jjtGetNumChildren()) {
                result += this.jjtGetChild(i).numNodes(n);
                ++i;
            }
        }
        return result;
    }
}

