/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.javac;

import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.javac.ASTTypeDeclaration;
import com.sap.sql.sqlj.javac.Node;
import com.sap.sql.sqlj.javac.SimpleNode;
import com.sap.sql.sqlj.javac.UnitDescriptorImpl;
import com.sap.sql.sqlj.mesg.JavacErrors;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.ClassNameResolver;
import com.sap.sql.sqlj.util.OutputContext;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.TypeDescriptor;
import com.sap.sql.sqlj.util.UnitClassResolver;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class ASTCompilationUnit
extends SimpleNode {
    protected String packageName = null;
    protected String fileName = null;
    protected UnitClassResolver resolver = null;
    protected int num_of_errors = 0;
    protected String firstClassName = null;
    private Vector m_children = new Vector();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$javac$ASTCompilationUnit == null ? (class$com$sap$sql$sqlj$javac$ASTCompilationUnit = ASTCompilationUnit.class$("com.sap.sql.sqlj.javac.ASTCompilationUnit")) : class$com$sap$sql$sqlj$javac$ASTCompilationUnit));
    private TypeDescriptor desc = null;
    static /* synthetic */ Class class$com$sap$sql$sqlj$javac$ASTCompilationUnit;

    ASTCompilationUnit(int id) {
        super(id);
    }

    public void init(String fileName, ClassResolver r) {
        this.fileName = fileName;
        this.resolver = new UnitClassResolver(r);
    }

    public void setPackageName(String pName) {
        this.packageName = pName;
        if (this.packageName != null) {
            this.resolver.setPackageName(this.packageName);
        }
    }

    public Parselet getDefiningUnit() {
        return this;
    }

    public Parselet getEnclosingClass() {
        return null;
    }

    public void addClassDecl(Parselet decl) {
        if (decl.getScope() != null) {
            throw new IllegalArgumentException("class decl parselet already has scope");
        }
        decl.setScope(this);
        this.m_children.addElement(decl);
    }

    public Enumeration getClassDecls() {
        return this.m_children.elements();
    }

    public ClassNameResolver getClassResolver() {
        return this.resolver;
    }

    public TypeDescriptor getDescriptor() {
        if (this.desc == null) {
            this.desc = new UnitDescriptorImpl(this.packageName, this.firstClassName, this.fileName, this);
        }
        return this.desc;
    }

    public int parseComplete(String fileName, ErrorLog elog) {
        String firstClass = null;
        String firstPublicClass = null;
        int err_count = 0;
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            Node n1 = this.jjtGetChild(i);
            if (n1 instanceof ASTTypeDeclaration && n1.jjtGetNumChildren() > 0) {
                Node n2 = n1.jjtGetChild(0);
                try {
                    TypeDescriptor tds = n2.getDescriptor();
                    if (!(tds instanceof ClassDescriptor)) {
                        if (tds != null) {
                            ++err_count;
                            elog.addEntry(new JSError(JavacErrors.badlyPlacedSqlj()), n2.getBeginLine(), n2.getBeginColumn());
                        }
                    } else {
                        ClassDescriptor classDesc = (ClassDescriptor)tds;
                        BaseJSClass baseClass = classDesc.getBaseReflection();
                        n2.setName(baseClass.getName(), elog);
                        this.insertSymTab(n2, 0);
                        if (firstClass == null) {
                            firstClass = n2.getName();
                        }
                        if (Modifier.isPublic(baseClass.getModifiers())) {
                            firstPublicClass = n2.getName();
                        }
                    }
                }
                catch (ClassCircularityError cerr) {
                    LOCATION.catching((Throwable)cerr);
                    ++err_count;
                    elog.addEntry(new JSError(cerr.toString()), n2.getBeginLine(), n2.getBeginColumn());
                }
            }
            ++i;
        }
        this.firstClassName = firstPublicClass != null ? firstPublicClass : firstClass;
        String name = firstPublicClass;
        if (name != null) {
            int i2 = name.lastIndexOf(".");
            if (i2 != -1) {
                name = name.substring(i2 + 1);
            }
            if (!name.equals(fileName)) {
                ++err_count;
                elog.addEntry(new JSError(JavacErrors.badFileName(firstPublicClass, name)));
            }
        }
        return err_count;
    }

    public boolean generate(OutputContext ctx) throws IOException, ConfigurationException {
        Writer w = ctx.getWriter();
        w.write("/*@lineinfo:filename=" + this.fileName + "*/");
        boolean success = super.generate(ctx);
        int i = 0;
        while (i < this.m_children.size()) {
            Parselet p = (Parselet)this.m_children.elementAt(i);
            success = p.generate(ctx) && success;
            ++i;
        }
        w.flush();
        return success;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

