/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.framework.options;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.jdbc.ServiceConnection;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.sqlj.common.CatalogReaderManager;
import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.ide.TranslationOptionsQuery;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.mesg.SemanticOptions;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class ConnectionFactory {
    public static final String USER_OPTION = "user";
    public static final String DRIVER_OPTION = "driver";
    public static final String PASSWORD_OPTION = "password";
    public static final String CATALOG_READER_OPTION = "catalogReader";
    public static final String USER_DEFAULT = ConnectionFactory.getDefaultValue("user");
    public static final String CATALOG_READER_DEFAULT = ConnectionFactory.getDefaultValue("catalogReader");
    public static final String DRIVER_DEFAULT = ConnectionFactory.getDefaultValue("driver");
    public static final String PASSWORD_DEFAULT = ConnectionFactory.getDefaultValue("password");
    public static final String EMPTY_PASSWORD = "EMPTY.PASSWORD";
    public static final String QUERY_PASSWORD = "QUERY.PASSWORD";
    public static final String EMPTY_USER = "EMPTY.USER";
    public static final String QUERY_USER = "QUERY_USER";
    public static final String PASSWORD_SEPARATOR = "/";
    public static final String URL_SEPARATOR = "@";
    private static final TranslationOptionsQuery DEFAULT_OPTIONS_QUERY = new GetPassword();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$framework$options$ConnectionFactory == null ? (class$com$sap$sql$sqlj$framework$options$ConnectionFactory = ConnectionFactory.class$("com.sap.sql.sqlj.framework.options.ConnectionFactory")) : class$com$sap$sql$sqlj$framework$options$ConnectionFactory));
    private static final boolean beDebug = LOCATION.beDebug();
    private TranslationOptionsQuery m_queryPassword = DEFAULT_OPTIONS_QUERY;
    private String m_user = USER_DEFAULT;
    private String m_catalogReader = CATALOG_READER_DEFAULT;
    private String m_password = PASSWORD_DEFAULT;
    private Vector m_drivers = new Vector();
    private boolean m_driversRegistered = false;
    static /* synthetic */ Class class$com$sap$sql$sqlj$framework$options$ConnectionFactory;

    private static String getDefaultValue(String optionName) {
        return SemanticOptions.getOptionInfo(optionName)[2];
    }

    public void setOptionsQuery(TranslationOptionsQuery qp) {
        if (qp == null) {
            qp = DEFAULT_OPTIONS_QUERY;
        }
        this.m_queryPassword = qp;
    }

    public TranslationOptionsQuery getOptionsQuery() {
        return this.m_queryPassword;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getCatalogReader() {
        return this.m_catalogReader;
    }

    public void setCatalogReader(String name) {
        this.m_catalogReader = name;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setDrivers(Enumeration drivers) {
        this.m_driversRegistered = false;
        this.m_drivers.removeAllElements();
        if (drivers != null) {
            while (drivers.hasMoreElements()) {
                Object driver = drivers.nextElement();
                this.m_drivers.addElement(driver);
            }
        }
    }

    public Enumeration getDrivers() {
        return this.m_drivers.elements();
    }

    public void resetConnectData() {
        this.setUser(null);
        this.setPassword(null);
        this.setCatalogReader(null);
    }

    public String toString() {
        return "CatalogSource:" + this.getUser() + URL_SEPARATOR + this.getCatalogReader();
    }

    public CatalogReader getCatalogReader(ErrorLog log) throws SQLException, ConfigurationException {
        String catalogReaderName = this.getCatalogReader();
        CatalogReader reader = null;
        reader = this.getCatalogReader(catalogReaderName, log);
        if (beDebug) {
            LOCATION.debugT(SemanticErrors.connectingToDataSource(catalogReaderName));
        }
        if (reader == null) {
            throw new ConfigurationException("couldn't get catalog reader");
        }
        return reader;
    }

    public Connection getConnectionViaUrl(ErrorLog el, String url) throws SQLException {
        this.registerJDBCDrivers(el);
        String password = this.getPassword();
        String user = this.getUser();
        if (password.equals(EMPTY_PASSWORD)) {
            password = this.m_queryPassword.getPassword(user, url);
        }
        Connection conn = user == null || user.equals("") ? DriverManager.getConnection(url) : DriverManager.getConnection(url, user, password);
        if (beDebug) {
            LOCATION.debugT(SemanticErrors.connectingTo(user, url));
        }
        return conn;
    }

    private void registerJDBCDrivers(ErrorLog log) {
        if (this.m_driversRegistered) {
            return;
        }
        this.m_driversRegistered = true;
        Enumeration e = this.getDrivers();
        int count = 0;
        StringBuffer sb = new StringBuffer();
        while (e.hasMoreElements()) {
            String driver = (String)e.nextElement();
            try {
                Driver drv = (Driver)Class.forName(driver).newInstance();
                DriverManager.registerDriver(drv);
                if (beDebug) {
                    if (count > 0) {
                        sb.append(", ");
                    }
                    sb.append(driver);
                }
                ++count;
            }
            catch (SQLException exn) {
                this.handleException(exn, log, driver);
            }
            catch (ClassNotFoundException exn) {
                this.handleException(exn, log, driver);
            }
            catch (InstantiationException exn) {
                this.handleException(exn, log, driver);
            }
            catch (IllegalAccessException exn) {
                this.handleException(exn, log, driver);
            }
        }
        if (beDebug) {
            LOCATION.debugT(SemanticErrors.registeredJDBCDrivers(sb.toString()));
        }
    }

    private void handleException(Exception ex, ErrorLog log, String driver) {
        String msg = SemanticErrors.cannotLoadJDBCDriver(driver);
        LOCATION.traceThrowableT(500, msg, (Throwable)ex);
        log.addEntry(new JSError(msg));
    }

    private CatalogReader getCatalogReader(String uri, ErrorLog el) throws SQLException, ConfigurationException {
        if (uri.startsWith("xml/")) {
            CatalogReaderManager readerFactory = new CatalogReaderManager();
            return readerFactory.getCatalogReader(uri.substring(4));
        }
        if (uri.startsWith("url/")) {
            Connection conn = this.getConnectionViaUrl(el, uri.substring(4));
            if (conn instanceof ServiceConnection) {
                ServiceConnection sc = (ServiceConnection)conn;
                Object obj = sc.getServiceContext();
                if (obj instanceof CommonConnectionContext) {
                    CommonConnectionContext ctx = (CommonConnectionContext)obj;
                    return ctx.getCatalogReader();
                }
                throw new ConfigurationException("The URL \"" + uri + "\" does not specify an Open JDBC Connection");
            }
            throw new ConfigurationException("The URL \"" + uri + "\" does not specify an Open JDBC Connection");
        }
        throw new ConfigurationException("catalog reader string must start with \"xml/\" or \"url/\"");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class GetPassword
    implements TranslationOptionsQuery {
        public String getPassword(String user, String url) {
            String passwd = null;
            System.out.print(SemanticErrors.promptForPassword(user, url));
            System.out.flush();
            BufferedReader bin = new BufferedReader(new InputStreamReader(System.in));
            try {
                passwd = bin.readLine();
            }
            catch (IOException exn) {
                LOCATION.catching((Throwable)exn);
                return null;
            }
            return passwd;
        }

        public String getURL(String context) {
            return null;
        }
    }
}

