/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.framework;

import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.framework.JSClass;
import java.util.Hashtable;

public interface ClassResolver {
    public static final ClassResolver SYSTEM_CLASSES = new SystemClassResolver();

    public BaseJSClass getClass(String var1) throws ClassNotFoundException;

    public BaseJSClass getQualifiedClass(String var1);

    public void addClass(BaseJSClass var1);

    public boolean isLoadedClass(String var1);

    public static class SystemClassResolver
    implements ClassResolver {
        private Hashtable m_classes = new Hashtable();

        SystemClassResolver() {
        }

        public BaseJSClass getClass(String className) throws ClassNotFoundException {
            BaseJSClass cls = this.getQualifiedClass(className);
            if (cls == null) {
                throw new ClassNotFoundException(className);
            }
            return cls;
        }

        public BaseJSClass getQualifiedClass(String className) {
            JSClass.loadSystemClasses();
            return (BaseJSClass)this.m_classes.get(className);
        }

        public void addClass(BaseJSClass cls) {
            JSClass.loadSystemClasses();
            BaseJSClass old = this.m_classes.put(cls.getName(), cls);
            if (old != null && old != cls) {
                throw new ClassCircularityError("class already exists with name " + cls.getName());
            }
        }

        public boolean isLoadedClass(String qualifiedName) {
            return this.m_classes.containsKey(qualifiedName);
        }
    }
}

