/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen.engine;

import com.sap.sql.sqlj.codegen.engine.BodyDecl;
import com.sap.sql.sqlj.codegen.engine.CodegenException;
import com.sap.sql.sqlj.codegen.engine.DocComment;
import com.sap.sql.sqlj.codegen.engine.Modifiers;
import com.sap.sql.sqlj.codegen.engine.NamedType;
import com.sap.sql.sqlj.codegen.engine.Statement;
import com.sap.sql.sqlj.codegen.engine.StatementBlock;
import com.sap.sql.sqlj.codegen.engine.StreamableObject;
import com.sap.sql.sqlj.codegen.engine.StreamableVector;
import com.sap.sql.sqlj.codegen.engine.Type;
import com.sap.sql.sqlj.common.ConfigurationException;
import java.io.IOException;
import java.io.PrintWriter;

public class BaseMethodDecl
implements BodyDecl {
    private DocComment comment_;
    private Modifiers modifiers_;
    private Type type_;
    private String name_;
    private StreamableVector params_;
    private StreamableVector throwlist_;
    private StatementBlock statements_;
    private boolean isAbstract_;

    public BaseMethodDecl(boolean isAbstract) {
        this(isAbstract, new StreamableVector(2));
    }

    public BaseMethodDecl(boolean isAbstract, StreamableVector params) {
        this.isAbstract_ = isAbstract;
        this.comment_ = new DocComment();
        this.modifiers_ = new Modifiers();
        this.name_ = "";
        this.params_ = params;
        this.params_.delimiter(", ");
        this.throwlist_ = new StreamableVector(1, "  throws ", ", ", " ");
        this.type_ = Type.EMPTY;
        this.statements_ = new StatementBlock();
    }

    public void docComment(DocComment comment) {
        this.comment_ = comment;
    }

    public void modifiers(Modifiers modifiers) {
        this.modifiers_ = modifiers;
    }

    public void name(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public void addParameter(Type type, String name) {
        this.addParameter(new NamedType(type, name));
    }

    public void addParameter(NamedType param) {
        this.params_.addElement(param);
    }

    public void addException(String exception) {
        this.throwlist_.addElement(new StreamableObject(exception));
    }

    public void type(Type type) {
        this.type_ = type;
    }

    public void addStatement(Statement stmt) {
        this.statements_.addStatement(stmt);
    }

    public void stream(PrintWriter ps) throws IOException, CodegenException, ConfigurationException {
        this.comment_.stream(ps);
        this.modifiers_.stream(ps);
        this.type_.stream(ps);
        ps.print(this.name_ + "(");
        this.params_.stream(ps);
        ps.print(") ");
        if (this.throwlist_.size() > 0) {
            ps.println();
        }
        this.throwlist_.stream(ps);
        if (this.isAbstract_) {
            ps.println(";");
        } else {
            ps.println();
            this.statements_.stream(ps);
        }
    }
}

