/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.JSClassType;
import com.sap.sql.sqlj.codegen.TempDecl;
import com.sap.sql.sqlj.codegen.Util;
import com.sap.sql.sqlj.codegen.engine.CodegenException;
import com.sap.sql.sqlj.codegen.engine.Expression;
import com.sap.sql.sqlj.codegen.engine.FieldDecl;
import com.sap.sql.sqlj.codegen.engine.Initializer;
import com.sap.sql.sqlj.codegen.engine.ObjectExpression;
import com.sap.sql.sqlj.codegen.engine.StatementGroup;
import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.util.ArrayAccessDescriptor;
import com.sap.sql.sqlj.util.ExpressionDescriptor;
import com.sap.sql.sqlj.util.FieldAccessDescriptor;
import com.sap.sql.sqlj.util.OutputContext;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.TypeDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

class TypedExpression
implements Expression {
    private Expression m_expr;
    private JSClassType m_type;
    private JSClass m_class;
    private String m_name = null;
    private TempDeclFactory m_tempFactory;

    public TypedExpression(Parselet p, JSClassType.Factory typeFactory) throws ClassNotFoundException {
        this(TypedExpression.getType(p, typeFactory), new ParseletExpression(p), TypedExpression.getName(p));
        TypeDescriptor desc = p.getDescriptor();
        if (desc instanceof FieldAccessDescriptor) {
            this.m_tempFactory = new FieldTempDecl(this, (FieldAccessDescriptor)desc, typeFactory);
        } else if (desc instanceof ArrayAccessDescriptor) {
            this.m_tempFactory = new ArrayTempDecl(this, (ArrayAccessDescriptor)desc, typeFactory);
        }
    }

    private static JSClassType getType(Parselet p, JSClassType.Factory typeFactory) throws ClassNotFoundException {
        JSClass cls = ((ExpressionDescriptor)p.getDescriptor()).getReflection();
        return typeFactory.getType(cls);
    }

    private static String getName(Parselet p) throws ClassNotFoundException {
        return ((ExpressionDescriptor)p.getDescriptor()).getName();
    }

    public TypedExpression(JSClassType type, Expression expr, String name) {
        this.m_expr = expr;
        this.m_type = type;
        this.m_class = this.m_type.toClass();
        this.m_name = name;
        this.m_tempFactory = new BasicTempDecl(this);
    }

    public String getName() {
        return this.m_name;
    }

    public JSClassType getType() {
        return this.m_type;
    }

    public JSClass getJSClass() {
        return this.m_class;
    }

    public void stream(PrintWriter out) throws IOException, CodegenException, ConfigurationException {
        this.m_expr.stream(out);
    }

    public TempDecl declareTemps(String tempName, int mode) {
        return this.m_tempFactory.declareTemps(tempName, mode);
    }

    private static class ParseletExpression
    implements Expression {
        private Parselet m_parselet;

        ParseletExpression(Parselet p) {
            this.m_parselet = p;
        }

        public void stream(PrintWriter out) throws IOException, CodegenException, ConfigurationException {
            if (!this.m_parselet.generate(new OutputContextImpl(out))) {
                throw new CodegenException();
            }
        }

        private static class OutputContextImpl
        implements OutputContext {
            private Writer m_writer;

            OutputContextImpl(Writer w) {
                this.m_writer = w;
            }

            public Writer getWriter() {
                return this.m_writer;
            }

            public Writer createWriter(String filename) throws IOException {
                throw new IOException("Typed expression unable to create writer");
            }

            public OutputStream createOutputStream(String filename) throws IOException {
                throw new IOException("Typed expression unable to create output stream");
            }
        }
    }

    private class ArrayTempDecl
    implements TempDeclFactory {
        private TypedExpression m_arrExpr;
        private TypedExpression m_ndxExpr;
        private TypedExpression m_expr;

        public ArrayTempDecl(TypedExpression expr, ArrayAccessDescriptor desc, JSClassType.Factory typeFactory) throws ClassNotFoundException {
            this.m_arrExpr = new TypedExpression(desc.getBaseObject(), typeFactory);
            this.m_ndxExpr = new TypedExpression(desc.getArrayIndex(), typeFactory);
            this.m_expr = expr;
        }

        public TempDecl declareTemps(String tempName, int mode) {
            String varName = Util.newVarName(tempName);
            JSClassType tempType = this.m_expr.getType();
            String arrTempName = varName + "arr";
            String ndxTempName = varName + "ndx";
            TypedExpression lval = new TypedExpression(tempType, new ObjectExpression(arrTempName + "[" + ndxTempName + "]"), null);
            TypedExpression rval = new TypedExpression(tempType, new ObjectExpression(varName), varName);
            TempDeclImpl tempDecl = new TempDeclImpl(lval, rval);
            if (mode != 1) {
                JSClassType arrType = this.m_arrExpr.getType();
                FieldDecl arrTemp = new FieldDecl();
                arrTemp.name(arrTempName);
                arrTemp.type(arrType);
                arrTemp.initializer(new Initializer(this.m_arrExpr));
                tempDecl.addStatement(arrTemp);
                FieldDecl ndxTemp = new FieldDecl();
                ndxTemp.name(ndxTempName);
                ndxTemp.type(JSClassType.int_TYPE);
                ndxTemp.initializer(new Initializer(this.m_ndxExpr));
                tempDecl.addStatement(ndxTemp);
            }
            if (mode != 4) {
                FieldDecl temp = new FieldDecl();
                temp.name(varName);
                temp.type(tempType);
                TypedExpression init = mode == 1 ? this.m_expr : lval;
                temp.initializer(new Initializer(init));
                tempDecl.addStatement(temp);
            }
            return tempDecl;
        }
    }

    private class FieldTempDecl
    implements TempDeclFactory {
        private String m_fieldName;
        private TypedExpression m_objExpr;
        private TypedExpression m_expr;

        public FieldTempDecl(TypedExpression expr, FieldAccessDescriptor desc, JSClassType.Factory typeFactory) throws ClassNotFoundException {
            this.m_fieldName = desc.getFieldName();
            this.m_objExpr = new TypedExpression(desc.getBaseObject(), typeFactory);
            this.m_expr = expr;
        }

        public TempDecl declareTemps(String tempName, int mode) {
            String varName = Util.newVarName(tempName);
            JSClassType tempType = this.m_expr.getType();
            String objTempName = varName + "obj";
            TypedExpression lval = new TypedExpression(tempType, new ObjectExpression(objTempName + "." + this.m_fieldName), null);
            TypedExpression rval = new TypedExpression(tempType, new ObjectExpression(varName), varName);
            TempDeclImpl tempDecl = new TempDeclImpl(lval, rval);
            if (mode != 1) {
                JSClassType objType = this.m_objExpr.getType();
                FieldDecl objTemp = new FieldDecl();
                objTemp.name(objTempName);
                objTemp.type(objType);
                objTemp.initializer(new Initializer(this.m_objExpr));
                tempDecl.addStatement(objTemp);
            }
            if (mode != 4) {
                FieldDecl temp = new FieldDecl();
                temp.name(varName);
                temp.type(tempType);
                TypedExpression init = mode == 1 ? this.m_expr : lval;
                temp.initializer(new Initializer(init));
                tempDecl.addStatement(temp);
            }
            return tempDecl;
        }
    }

    private static class BasicTempDecl
    implements TempDeclFactory {
        private TypedExpression m_expr;

        BasicTempDecl(TypedExpression expr) {
            this.m_expr = expr;
        }

        public TempDecl declareTemps(String tempName, int mode) {
            String varName = Util.newVarName(tempName);
            JSClassType varType = this.m_expr.getType();
            TypedExpression rval = new TypedExpression(varType, new ObjectExpression(varName), varName);
            TempDeclImpl tempDecl = new TempDeclImpl(this.m_expr, rval);
            if (mode != 4) {
                FieldDecl temp = new FieldDecl();
                temp.name(varName);
                temp.type(varType);
                temp.initializer(new Initializer(this.m_expr));
                tempDecl.addStatement(temp);
            }
            return tempDecl;
        }
    }

    private static class TempDeclImpl
    extends StatementGroup
    implements TempDecl {
        private TypedExpression m_lval;
        private TypedExpression m_rval;

        public TempDeclImpl(TypedExpression lval, TypedExpression rval) {
            this.m_lval = lval;
            this.m_rval = rval;
        }

        public TypedExpression getRValExpr() {
            return this.m_rval;
        }

        public TypedExpression getLValExpr() {
            return this.m_lval;
        }
    }

    private static interface TempDeclFactory {
        public TempDecl declareTemps(String var1, int var2);
    }
}

