/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.framework.JSClass;
import java.util.Hashtable;

public class JavaToSQLMap {
    private static final Hashtable m_javaToSQLTable = JavaToSQLMap.newJavaToSQLTable();
    private MapClassResolver m_classResolver = new MapClassResolver();

    private static Hashtable newJavaToSQLTable() {
        Hashtable<JSClass, Integer> table = new Hashtable<JSClass, Integer>();
        table.put(JSClass.String_TYPE, new Integer(12));
        table.put(JSClass.BigDecimal_TYPE, new Integer(2));
        table.put(JSClass.boolean_TYPE, new Integer(-7));
        table.put(JSClass.byte_TYPE, new Integer(-6));
        table.put(JSClass.short_TYPE, new Integer(5));
        table.put(JSClass.int_TYPE, new Integer(4));
        table.put(JSClass.long_TYPE, new Integer(-5));
        table.put(JSClass.float_TYPE, new Integer(7));
        table.put(JSClass.double_TYPE, new Integer(8));
        table.put(JSClass.bytearray_TYPE, new Integer(-3));
        table.put(JSClass.Date_TYPE, new Integer(91));
        table.put(JSClass.Time_TYPE, new Integer(92));
        table.put(JSClass.Timestamp_TYPE, new Integer(93));
        table.put(JSClass.Boolean_TYPE, new Integer(-7));
        table.put(JSClass.Byte_TYPE, new Integer(-6));
        table.put(JSClass.Short_TYPE, new Integer(5));
        table.put(JSClass.Integer_TYPE, new Integer(4));
        table.put(JSClass.Long_TYPE, new Integer(-5));
        table.put(JSClass.Float_TYPE, new Integer(7));
        table.put(JSClass.Double_TYPE, new Integer(8));
        table.put(JSClass.Blob_TYPE, new Integer(2004));
        table.put(JSClass.Clob_TYPE, new Integer(2005));
        return table;
    }

    public int mapType(JSClass type) {
        Integer sqlObj = (Integer)m_javaToSQLTable.get(type);
        int sqlType = 1111;
        if (sqlObj != null) {
            sqlType = sqlObj;
        }
        return sqlType;
    }

    public int mapType(Class type) {
        return this.mapType(JSClass.reflect(type, this.m_classResolver));
    }

    public JSClass toJSClass(Class type) {
        return JSClass.reflect(type, this.m_classResolver);
    }

    private static class MapClassResolver
    implements ClassResolver {
        private Hashtable m_classes = new Hashtable();

        private MapClassResolver() {
        }

        public BaseJSClass getClass(String className) throws ClassNotFoundException {
            BaseJSClass cls = this.getQualifiedClass(className);
            if (cls == null) {
                throw new ClassNotFoundException(className);
            }
            return cls;
        }

        public BaseJSClass getQualifiedClass(String className) {
            BaseJSClass aClass = (BaseJSClass)this.m_classes.get(className);
            if (aClass == null) {
                aClass = ClassResolver.SYSTEM_CLASSES.getQualifiedClass(className);
            }
            return aClass;
        }

        public void addClass(BaseJSClass aClass) {
            if (this.isLoadedClass(aClass.getName())) {
                throw new ClassCircularityError(aClass.getName() + " has already been defined");
            }
            this.m_classes.put(aClass.getName(), aClass);
        }

        public boolean isLoadedClass(String qualifiedName) {
            return this.m_classes.containsKey(qualifiedName) || ClassResolver.SYSTEM_CLASSES.isLoadedClass(qualifiedName);
        }
    }
}

