/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.CursorJSClass;
import com.sap.sql.sqlj.codegen.IntoGroup;
import com.sap.sql.sqlj.codegen.TempDecl;
import com.sap.sql.sqlj.codegen.TypedExpression;
import com.sap.sql.sqlj.codegen.engine.AssignmentStatement;
import com.sap.sql.sqlj.codegen.engine.ChainedExpression;
import com.sap.sql.sqlj.codegen.engine.IfStatement;
import com.sap.sql.sqlj.codegen.engine.ObjectExpression;
import com.sap.sql.sqlj.codegen.engine.StatementBlock;
import com.sap.sql.sqlj.codegen.engine.StatementGroup;
import com.sap.sql.sqlj.framework.JSClass;

class FetchIntoStmt
extends StatementBlock {
    private FetchIntoGroup m_intoGroup;
    private StatementGroup m_temps = new StatementGroup();

    public static boolean isFetchExpression(TypedExpression expr) {
        JSClass cursorClass = expr.getJSClass();
        return JSClass.PositionedIterator_TYPE.isAssignableFrom(cursorClass);
    }

    public FetchIntoStmt(TypedExpression cursorExpr) {
        this.addStatement(this.m_temps);
        TempDecl cursorTemp = cursorExpr.declareTemps("iter", 1);
        this.addTempDecl(cursorTemp);
        cursorExpr = cursorTemp.getRValExpr();
        this.m_intoGroup = new FetchIntoGroup(cursorExpr, this);
        JSClass cursorClass = cursorExpr.getJSClass();
        if (!JSClass.PositionedIterator_TYPE.isAssignableFrom(cursorClass)) {
            throw new IllegalArgumentException("cursorExpr is not of expected type");
        }
        ChainedExpression ifCond = new ChainedExpression(cursorExpr);
        ifCond.addExpression(new ObjectExpression("next()"));
        StatementBlock ifBlock = new StatementBlock();
        ifBlock.addStatement(this.m_intoGroup);
        this.addStatement(new IfStatement(ifCond, ifBlock));
    }

    void addTempDecl(TempDecl temps) {
        this.m_temps.addStatement(temps);
    }

    public IntoGroup getIntoGroup() {
        return this.m_intoGroup;
    }

    private static class FetchIntoGroup
    extends StatementGroup
    implements IntoGroup {
        private TypedExpression m_iterator;
        private int m_count;
        private FetchIntoStmt m_tempLocation;

        public FetchIntoGroup(TypedExpression iterator, FetchIntoStmt tempLocation) {
            this.m_iterator = iterator;
            this.m_count = 1;
            this.m_tempLocation = tempLocation;
        }

        public void addIntoVar(TypedExpression expr) {
            TempDecl temps = expr.declareTemps(this.m_count + "", 4);
            this.m_tempLocation.addTempDecl(temps);
            expr = temps.getLValExpr();
            ChainedExpression getCall = new ChainedExpression(this.m_iterator);
            getCall.addExpression(new ObjectExpression(CursorJSClass.getColumnAccessName(this.m_count++) + "()"));
            this.addStatement(new AssignmentStatement(expr, getCall));
        }
    }
}

