/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.Util;
import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.framework.JSConstructor;
import com.sap.sql.sqlj.framework.JSField;
import com.sap.sql.sqlj.framework.JSMember;
import com.sap.sql.sqlj.framework.JSMethod;
import com.sap.sql.sqlj.syntax.ClassElem;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.ExpressionDescriptor;
import com.sap.sql.sqlj.util.Parselet;
import java.util.Enumeration;
import java.util.Vector;

abstract class ElemJSClass
extends JSClass {
    private JSClass[] m_interfaces = null;
    private JSClass m_declaringClass = null;
    private JSField[] m_fields;
    private static final int WITH_MODS = 25;
    static final ClassNotFoundException CYCLIC_FIELDS = new ClassNotFoundException("cyclic fields");

    public ElemJSClass(BaseJSClass base, ClassElem elem, JSClass[] baseInterfaces) throws ClassNotFoundException {
        super(base);
        this.m_declaringClass = this.findDeclaringClass(elem);
        this.m_interfaces = this.calcInterfaces(elem, baseInterfaces);
        this.m_fields = this.calcFields(elem);
    }

    public ElemJSClass(BaseJSClass base, JSClass[] baseInterfaces) {
        super(base);
        this.m_declaringClass = null;
        this.m_interfaces = baseInterfaces;
    }

    public JSClass getDeclaringClass() {
        return this.m_declaringClass;
    }

    private JSClass findDeclaringClass(ClassElem elem) throws ClassNotFoundException {
        Parselet declaringParselet = elem.getScope().getScope().getEnclosingClass();
        if (declaringParselet != null) {
            BaseJSClass cls = ((ClassDescriptor)declaringParselet.getDescriptor()).getBaseReflection();
            return this.resolveClass(cls);
        }
        return null;
    }

    public JSClass[] getDeclaredClasses() throws SecurityException {
        return new JSClass[0];
    }

    public JSField[] getDeclaredFields() throws SecurityException {
        return this.m_fields;
    }

    private JSField[] calcFields(ClassElem elem) {
        Vector<WithField> fields = new Vector<WithField>();
        Enumeration withFields = elem.getWithKeywords();
        while (withFields.hasMoreElements()) {
            String fieldName = (String)withFields.nextElement();
            Parselet fieldValue = elem.getWithValue(fieldName);
            fields.addElement(new WithField(fieldName, 25, fieldValue));
        }
        Object[] result = new JSField[fields.size()];
        fields.copyInto(result);
        return result;
    }

    public JSClass[] getInterfaces() {
        return this.m_interfaces;
    }

    private JSClass[] calcInterfaces(ClassElem elem, JSClass[] baseInterfaces) throws ClassNotFoundException {
        Vector<JSClass> interfaces = new Vector<JSClass>();
        int i = 0;
        while (i < baseInterfaces.length) {
            interfaces.addElement(baseInterfaces[i]);
            ++i;
        }
        Enumeration enumeration = elem.getInterfaces();
        while (enumeration.hasMoreElements()) {
            String interfaceName = (String)enumeration.nextElement();
            interfaces.addElement(this.resolveClass(interfaceName));
        }
        Object[] result = new JSClass[interfaces.size()];
        interfaces.copyInto(result);
        return result;
    }

    private class WithField
    extends JSMemberImpl
    implements JSField {
        private JSClass m_type = null;
        private Parselet m_value;
        private ClassNotFoundException m_typeError;

        public WithField(String name, int modifiers, Parselet value) {
            super(name, modifiers);
            this.m_value = value;
        }

        public JSClass getType() throws ClassNotFoundException {
            if (this.m_type == null) {
                if (this.m_typeError != null) {
                    this.m_typeError.fillInStackTrace();
                    throw this.m_typeError;
                }
                this.m_typeError = CYCLIC_FIELDS;
                try {
                    this.m_type = ((ExpressionDescriptor)this.m_value.getDescriptor()).getReflection();
                }
                catch (ClassNotFoundException e) {
                    this.m_typeError = e;
                    throw e;
                }
                this.m_typeError = null;
            }
            return this.m_type;
        }

        public Object get() throws IllegalAccessException {
            ExpressionDescriptor desc = (ExpressionDescriptor)this.m_value.getDescriptor();
            if (!desc.isConstant()) {
                throw new IllegalAccessException();
            }
            return desc.getValue();
        }
    }

    protected class JSMethodImpl
    extends JSMemberImpl
    implements JSMethod {
        private JSClass[] m_params;
        private JSClass m_type;

        public JSMethodImpl(String name, int modifiers, JSClass type, JSClass[] params) {
            super(name, modifiers);
            this.m_type = type;
            this.m_params = params;
        }

        public JSClass getReturnType() {
            return this.m_type;
        }

        public JSClass[] getParameterTypes() {
            return this.m_params;
        }
    }

    protected class JSConstructorImpl
    extends JSMemberImpl
    implements JSConstructor {
        private JSClass[] m_params;

        public JSConstructorImpl(int modifiers, JSClass[] params) {
            super(ElemJSClass.this.getName(), modifiers);
            this.m_params = params;
        }

        public JSClass[] getParameterTypes() {
            return this.m_params;
        }
    }

    protected class JSMemberImpl
    implements JSMember {
        private int m_mods;
        private String m_name;

        public JSMemberImpl(String name, int modifiers) {
            this.m_name = name;
            this.m_mods = modifiers;
        }

        public JSClass getDeclaringClass() {
            return ElemJSClass.this;
        }

        public String getName() {
            return this.m_name;
        }

        public int getModifiers() {
            return this.m_mods;
        }
    }

    public static class Base
    extends BaseJSClass {
        Base(ClassElem elem, String superName) {
            super(Base.getFullName(elem), elem.getModifiers(), elem.getScope().getClassResolver(), superName);
        }

        private static String getFullName(ClassElem elem) {
            StringBuffer classPrefix = Util.getClassPrefix(elem.getScope().getScope());
            return classPrefix.append(elem.getClassName()).toString();
        }

        protected JSClass createJSClass() throws ClassNotFoundException {
            throw new ClassNotFoundException(this.getName() + " - invalid call to create JSClass()");
        }
    }
}

