/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.ElemJSClass;
import com.sap.sql.sqlj.codegen.JSClassType;
import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.framework.JSConstructor;
import com.sap.sql.sqlj.framework.JSMethod;
import com.sap.sql.sqlj.syntax.CursorElem;
import com.sap.sql.sqlj.syntax.IntoBindExpr;
import com.sap.sql.sqlj.syntax.Type;
import com.sap.sql.sqlj.util.ExpressionDescriptor;
import com.sap.sql.sqlj.util.Parselet;
import java.util.Enumeration;
import java.util.Vector;

class CursorJSClass
extends ElemJSClass {
    private static final JSClass[] EMPTY_ARGS = new JSClass[0];
    private static final JSClass SUPERCLASS = JSClassType.ResultSetIterImpl_TYPE.toClass();
    private JSMethod[] m_methods = null;
    private JSConstructor[] m_constructors = null;

    public CursorJSClass(BaseJSClass base, CursorElem elem) throws ClassNotFoundException {
        super(base, elem, new JSClass[]{elem.isByName() ? JSClass.NamedIterator_TYPE : JSClass.PositionedIterator_TYPE});
        this.createConstructors();
        this.setMethods(this.createMethods(elem));
    }

    public CursorJSClass(IntoBindExpr intoList) throws ClassNotFoundException {
        super(new DummyBaseClass(), new JSClass[]{JSClass.PositionedIterator_TYPE});
        this.createConstructors();
        this.setMethods(this.createMethods(intoList));
    }

    public void createConstructors() {
        this.m_constructors = new JSConstructor[]{new ElemJSClass.JSConstructorImpl((ElemJSClass)this, 1, new JSClass[]{JSClassType.RTResultSet_TYPE.toClass()})};
    }

    private void setMethods(Vector methods) {
        this.m_methods = new JSMethod[methods.size()];
        methods.copyInto(this.m_methods);
    }

    private Vector createMethods(CursorElem elem) throws ClassNotFoundException {
        Vector<JSMethod> methods = new Vector<JSMethod>();
        if (elem.isByName()) {
            Enumeration names = elem.getColumnNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String t = elem.getColumnType(name).getName();
                methods.addElement(this.newColumnAccessMethod(this.resolveClass(t), name));
            }
        } else {
            Enumeration types = elem.getColumnTypes();
            int i = 1;
            while (types.hasMoreElements()) {
                String t = ((Type)types.nextElement()).getName();
                methods.addElement(this.newColumnAccessMethod(this.resolveClass(t), i));
                ++i;
            }
        }
        return methods;
    }

    private Vector createMethods(IntoBindExpr intoList) throws ClassNotFoundException {
        Vector<JSMethod> methods = new Vector<JSMethod>();
        Enumeration parselets = intoList.getParselets();
        int i = 1;
        while (parselets.hasMoreElements()) {
            Parselet p = (Parselet)parselets.nextElement();
            BaseJSClass baseCls = ((ExpressionDescriptor)p.getDescriptor()).getBaseReflection();
            JSClass cls = this.resolveClass(baseCls);
            methods.addElement(this.newColumnAccessMethod(cls, i));
            ++i;
        }
        return methods;
    }

    private JSMethod newColumnAccessMethod(JSClass returnType, int colNum) {
        return this.newColumnAccessMethod(returnType, CursorJSClass.getColumnAccessName(colNum));
    }

    public static String getColumnAccessName(int colNum) {
        return "getCol" + colNum;
    }

    private JSMethod newColumnAccessMethod(JSClass returnType, String name) {
        return new ElemJSClass.JSMethodImpl(this, name, 1, returnType, EMPTY_ARGS);
    }

    public JSClass getSuperclass() {
        return SUPERCLASS;
    }

    public JSMethod[] getDeclaredMethods() throws SecurityException {
        return this.m_methods;
    }

    public JSConstructor[] getDeclaredConstructors() throws SecurityException {
        return this.m_constructors;
    }

    public JSMethod getDeclaredMethodsNoArgumentMethod(String methodName) throws SecurityException {
        int i = 0;
        while (i < this.m_methods.length) {
            if (this.m_methods[i].getName().equals(methodName) && this.m_methods[i].getParameterTypes().length == 0) {
                return this.m_methods[i];
            }
            ++i;
        }
        return null;
    }

    private static class DummyBaseClass
    extends BaseJSClass {
        private static final ClassResolver m_dummyResolver = new ClassResolver(){

            public BaseJSClass getClass(String name) throws ClassNotFoundException {
                throw new ClassNotFoundException(name);
            }

            public BaseJSClass getQualifiedClass(String name) {
                return null;
            }

            public boolean isLoadedClass(String className) {
                return false;
            }

            public void addClass(BaseJSClass cls) {
            }
        };

        public DummyBaseClass() {
            super("dummy*Iterator", 0, m_dummyResolver, SUPERCLASS.getName());
        }

        protected JSClass createJSClass() throws ClassNotFoundException {
            throw new ClassNotFoundException("this should never be called");
        }
    }

    public static class Base
    extends ElemJSClass.Base {
        private CursorElem m_elem;

        Base(CursorElem elem) {
            super(elem, SUPERCLASS.getName());
            this.m_elem = elem;
        }

        protected JSClass createJSClass() throws ClassNotFoundException {
            return new CursorJSClass((BaseJSClass)this, this.m_elem);
        }
    }
}

