/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart.pp;

import com.sap.tools.webdynpro.smart.pp.IPublicPartXML;
import com.sap.tools.webdynpro.smart.pp.PublicPart;
import com.tssap.util.xml.DOMAccess;
import com.tssap.util.xml.DOMParserI;
import com.tssap.util.xml.NodeAccess;
import com.tssap.util.xml.NodeReadAccessStaticI;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PublicParts
implements IPublicPartXML {
    private static final NodeReadAccessStaticI mReadAccess = NodeAccess.getNodeReadAccessStatic();
    private String mFilePath = "";
    private PublicPart[] mPublicParts = new PublicPart[0];

    public PublicParts(String filePath) {
        this.setFilePath(filePath);
    }

    private final Document parseConfigurationFile(String filePath) throws Exception {
        try {
            DOMParserI lParser = DOMAccess.getDOMParser((int)2);
            return lParser.parse(filePath, false);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception(t.getMessage());
        }
    }

    public final PublicPart[] parsePublicParts() throws Exception {
        Document lDocument = this.parseConfigurationFile(this.getFilePath());
        if (lDocument == null) {
            throw new Exception("File " + this.getFilePath() + " not found or xml not valid");
        }
        Element lRootElement = lDocument.getDocumentElement();
        if (lRootElement == null || !lRootElement.getTagName().equals("public-parts")) {
            throw new Exception("Root tag " + lRootElement.getTagName() + " unknown");
        }
        NodeList lPublicPartNodeList = PublicParts.getReadAccess().getNodesFromPath((Node)lRootElement, new String[]{"public-part"});
        Node lPublicPartNode = null;
        PublicPart lPublicPart = null;
        ArrayList<PublicPart> lPublicPartList = new ArrayList<PublicPart>();
        int i = 0;
        while (i < lPublicPartNodeList.getLength()) {
            lPublicPartNode = lPublicPartNodeList.item(i);
            if (lPublicPartNode.getNodeType() == 1) {
                lPublicPart = new PublicPart(lPublicPartNode);
                lPublicPart.parsePublicPart();
                lPublicPartList.add(lPublicPart);
            }
            ++i;
        }
        PublicPart[] lPublicParts = new PublicPart[lPublicPartList.size()];
        this.setPublicParts(lPublicPartList.toArray(lPublicParts));
        return this.getPublicParts();
    }

    private static NodeReadAccessStaticI getReadAccess() {
        return mReadAccess;
    }

    public final String getFilePath() {
        return this.mFilePath;
    }

    private void setFilePath(String string) {
        this.mFilePath = string;
    }

    public final PublicPart[] getPublicParts() {
        return this.mPublicParts;
    }

    private void setPublicParts(PublicPart[] parts) {
        this.mPublicParts = parts;
    }
}

