/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart.pp;

import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.filters.ClassFileFilter;
import com.sap.tools.webdynpro.bytecode.filters.Filter;
import com.sap.tools.webdynpro.bytecode.util.StringUtil;
import com.sap.tools.webdynpro.smart.Logging;
import com.sap.tools.webdynpro.smart.pp.Entity;
import com.sap.tools.webdynpro.smart.pp.File;
import com.sap.tools.webdynpro.smart.pp.PublicPart;
import com.sap.tools.webdynpro.smart.pp.PublicParts;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PublicPartAnalyzer {
    private final Logging log;
    private Set ppFilePatterns = new HashSet();

    public static Filter analyzePublicPartFileList(Logging log, String fileName) {
        return new PublicPartAnalyzer(log).analyze(fileName);
    }

    private PublicPartAnalyzer(Logging log) {
        this.log = log;
    }

    private void addFilter(ClassFileFilter filter) {
        this.log.trace("add '" + filter + "'");
        this.ppFilePatterns.add(filter);
    }

    private Filter analyze(String file) {
        if (file == null) {
            this.log.error("no PublicPartFileList.xml specified");
            return null;
        }
        try {
            this.log.trace("");
            this.log.trace("**** evaluating public part file list " + file);
            this.log.trace("");
            this.ppFilePatterns.clear();
            PublicParts ppp = new PublicParts(file);
            PublicPart[] lPublicPartArray = ppp.parsePublicParts();
            int i = 0;
            while (i < lPublicPartArray.length) {
                this.checkPublicPart(lPublicPartArray[i]);
                ++i;
            }
            Filter result = Filter.or((Collection)this.ppFilePatterns);
            this.log.trace("");
            this.log.trace("resulting filter: '" + result + "'");
            this.log.trace("");
            return result;
        }
        catch (ParseException e) {
            this.log.error("failed to parse public part file list: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error("failed to parse public part file list", e);
        }
        return null;
    }

    private void checkPublicPart(PublicPart pp) {
        this.log.trace("public part '" + pp.getName() + "'");
        this.log.indent();
        try {
            if (pp.getPurpose().equals("assembly")) {
                this.log.trace("ignore public part with purpose '" + pp.getPurpose() + "'");
                Object var5_2 = null;
                this.log.unindent();
                return;
            }
            if (!pp.getPurpose().equals("compilation")) {
                throw new ParseException("public part with unknown purpose '" + pp.getPurpose() + "'");
            }
            Entity[] lEntityArray = pp.getEntities();
            int i = 0;
            while (i < lEntityArray.length) {
                this.checkEntity(pp, lEntityArray[i]);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.log.unindent();
            throw throwable;
        }
        Object var5_3 = null;
        this.log.unindent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkEntity(PublicPart pp, Entity entity) {
        block27: {
            block29: {
                block28: {
                    this.log.trace("entity '" + entity.getName() + "' (" + entity.getEntityType() + ")");
                    this.log.indent();
                    try {
                        if (entity.getEntityType().equals("Java Class")) {
                            if (entity.getEntitySubType().equals("Source")) {
                                this.log.trace("ignored due to sub type '" + entity.getEntitySubType() + "'");
                                Object var4_3 = null;
                                this.log.unindent();
                                return;
                            }
                            if (!entity.getEntitySubType().equals("Class")) {
                                throw new ParseException("unknown sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.addFilter(new JavaClassPattern(entity.getPackage(), entity.getName()));
                            break block27;
                        }
                        if (entity.getEntityType().equals("Java Package")) {
                            if (entity.getEntitySubType().equals("Source")) {
                                this.log.trace("ignored due to sub type '" + entity.getEntitySubType() + "'");
                                break block28;
                            }
                            if (!entity.getEntitySubType().equals("Class")) {
                                throw new ParseException("unknown sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.addFilter(new JavaPackagePattern(entity.getPackage()));
                            break block27;
                        }
                        if (entity.getEntityType().equals("Java Package Tree")) {
                            if (entity.getEntitySubType().equals("Source")) {
                                this.log.trace("ignored due to sub type '" + entity.getEntitySubType() + "'");
                                break block29;
                            }
                            if (!entity.getEntitySubType().equals("Class")) {
                                throw new ParseException("unknown sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.addFilter(new JavaPackageTreePattern(entity.getPackage()));
                            break block27;
                        }
                        if (entity.getEntityType().equals("Common Model")) {
                            if (!entity.getEntitySubType().equals("Source")) {
                                throw new ParseException("unexpected sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.checkFileEntries(pp, entity);
                            break block27;
                        }
                        if (entity.getEntityType().equals("Dictionary Database Table")) {
                            if (!entity.getEntitySubType().equals("Source")) {
                                throw new ParseException("unexpected sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.checkFileEntries(pp, entity);
                            break block27;
                        }
                        if (entity.getEntityType().equals("Dictionary Database View")) {
                            if (!entity.getEntitySubType().equals("Source")) {
                                throw new ParseException("unexpected sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.checkFileEntries(pp, entity);
                            break block27;
                        }
                        if (entity.getEntityType().equals("Dictionary Simple Type")) {
                            if (!entity.getEntitySubType().equals("Source")) {
                                throw new ParseException("unexpected sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.checkFileEntries(pp, entity);
                            this.addFilter(new JavaClassPattern(entity.getPackage(), entity.getName()));
                            break block27;
                        }
                        if (entity.getEntityType().equals("Dictionary Structure")) {
                            if (!entity.getEntitySubType().equals("Source")) {
                                throw new ParseException("unexpected sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.checkFileEntries(pp, entity);
                            break block27;
                        }
                        if (entity.getEntityType().equals("Web Dynpro Component")) {
                            if (!entity.getEntitySubType().equals("Source")) {
                                throw new ParseException("unexpected sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.checkFileEntries(pp, entity);
                            break block27;
                        }
                        if (entity.getEntityType().equals("Web Dynpro Component Configuration")) {
                            this.checkFileEntries(pp, entity);
                            break block27;
                        }
                        if (entity.getEntityType().equals("Web Dynpro Component Interface Definition")) {
                            if (!entity.getEntitySubType().equals("Source")) {
                                throw new ParseException("unexpected sub type '" + entity.getEntitySubType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            }
                            this.checkFileEntries(pp, entity);
                            break block27;
                        } else {
                            if (!entity.getEntityType().equals("Web Dynpro Configuration Object")) throw new ParseException("unhandled type '" + entity.getEntityType() + "' in entity '" + entity.getName() + "' of public part '" + pp.getName() + "'");
                            this.checkFileEntries(pp, entity);
                        }
                        break block27;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        this.log.unindent();
                        throw throwable;
                    }
                }
                Object var4_4 = null;
                this.log.unindent();
                return;
            }
            Object var4_5 = null;
            this.log.unindent();
            return;
        }
        Object var4_6 = null;
        this.log.unindent();
    }

    private void checkFileEntries(PublicPart pp, Entity entity) {
        File[] files = entity.getFiles();
        if (files != null) {
            int k = 0;
            while (k < files.length) {
                Object var10_9;
                String filePattern = files[k].getName();
                this.log.trace("file '" + filePattern + "'");
                this.log.indent();
                try {
                    if (filePattern.endsWith(".class")) {
                        if ((filePattern = filePattern.substring(0, filePattern.length() - ".class".length())).endsWith("$*")) {
                            filePattern = filePattern.substring(0, filePattern.length() - "$*".length());
                        }
                        String pkgName = "";
                        String className = filePattern;
                        int p = filePattern.lastIndexOf(47);
                        if (p >= 0) {
                            pkgName = filePattern.substring(0, p);
                            className = filePattern.substring(p + 1);
                        }
                        this.addFilter(new JavaClassPattern(pkgName, className));
                    }
                    var10_9 = null;
                    this.log.unindent();
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    this.log.unindent();
                    throw throwable;
                }
                ++k;
            }
        }
    }

    public static class ParseException
    extends RuntimeException {
        ParseException(String msg) {
            super(msg);
        }
    }

    private class JavaClassPattern
    extends JavaPackagePattern {
        private final String className;
        protected final int cnLength;

        JavaClassPattern(String pkgName, String className) {
            super(pkgName);
            this.className = className;
            this.cnLength = className.length();
        }

        protected boolean matches(String qualifiedClassName) {
            return super.matches(qualifiedClassName) && qualifiedClassName.regionMatches(this.pLength, this.className, 0, this.cnLength) && (qualifiedClassName.length() == this.pLength + this.cnLength || qualifiedClassName.regionMatches(this.pLength + this.cnLength, "$", 0, 1));
        }

        public String toString() {
            return this.pkgName + this.className + "[$*].class";
        }
    }

    private class JavaPackagePattern
    extends JavaPackageTreePattern {
        protected final int pLength;

        JavaPackagePattern(String pkgName) {
            super(pkgName);
            this.pLength = this.pkgName.length();
        }

        protected boolean matches(String className) {
            return super.matches(className) && className.indexOf(47, this.pLength) < 0;
        }

        public String toString() {
            return this.pkgName + "*.class";
        }
    }

    private class JavaPackageTreePattern
    extends ClassFileFilter {
        protected final String pkgName;

        JavaPackageTreePattern(String pkgName) {
            this.pkgName = StringUtil.isEmpty((String)pkgName) ? "" : pkgName + "/";
        }

        protected boolean matches(String className) {
            return className.startsWith(this.pkgName);
        }

        public final boolean accepts(ClassFile cf) {
            return this.matches(cf.getName().replace('.', '/'));
        }

        public String toString() {
            return this.pkgName + "**/*.class";
        }

        public boolean equals(Object o) {
            if (!(o instanceof JavaPackageTreePattern)) {
                return false;
            }
            return this.toString().equals(o.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

