/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart.pp;

import com.sap.tools.webdynpro.smart.pp.File;
import com.sap.tools.webdynpro.smart.pp.IPublicPartXML;
import com.tssap.util.xml.NodeAccess;
import com.tssap.util.xml.NodeReadAccessStaticI;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Entity
implements IPublicPartXML {
    private static final NodeReadAccessStaticI mReadAccess = NodeAccess.getNodeReadAccessStatic();
    private String mName = "";
    private String mPackage = "";
    private String mEntityType = "";
    private String mEntitySubType = "";
    private File[] mFiles = new File[0];
    private Node mNode = null;

    public Entity(Node node) {
        this.setNode(node);
    }

    final void parseEntity() {
        Node lEntityNode = this.getNode();
        Node lNameNode = Entity.getReadAccess().getChildNode(lEntityNode, "name");
        this.setName(Entity.getReadAccess().getValue(lNameNode));
        Node lPackageNode = Entity.getReadAccess().getChildNode(lEntityNode, "package");
        this.setPackage(Entity.getReadAccess().getValue(lPackageNode));
        Node lEntityTypeNode = Entity.getReadAccess().getChildNode(lEntityNode, "entity-type");
        this.setEntityType(Entity.getReadAccess().getValue(lEntityTypeNode));
        Node lEntitySubTypeNode = Entity.getReadAccess().getChildNode(lEntityNode, "entity-sub-type");
        this.setEntitySubType(Entity.getReadAccess().getValue(lEntitySubTypeNode));
        NodeList lFileNodeList = Entity.getReadAccess().getNodesFromPath(lEntityNode, new String[]{"files", "file"});
        if (lFileNodeList != null) {
            Node lFileNode = null;
            File lFile = null;
            ArrayList<File> lFileList = new ArrayList<File>();
            int i = 0;
            while (i < lFileNodeList.getLength()) {
                lFileNode = lFileNodeList.item(i);
                if (lFileNode.getNodeType() == 1) {
                    lFile = new File(lFileNode);
                    lFile.parseFile();
                    lFileList.add(lFile);
                }
                ++i;
            }
            File[] lFiles = new File[lFileList.size()];
            this.setFiles(lFileList.toArray(lFiles));
        }
    }

    private static NodeReadAccessStaticI getReadAccess() {
        return mReadAccess;
    }

    public final String getEntitySubType() {
        return this.mEntitySubType;
    }

    public final String getEntityType() {
        return this.mEntityType;
    }

    public final File[] getFiles() {
        return this.mFiles;
    }

    public final String getName() {
        return this.mName;
    }

    public final String getPackage() {
        return this.mPackage;
    }

    private void setEntitySubType(String entitySubType) {
        this.mEntitySubType = entitySubType;
    }

    private void setEntityType(String entityType) {
        this.mEntityType = entityType;
    }

    public final void setFiles(File[] files) {
        this.mFiles = files;
    }

    private void setName(String name) {
        this.mName = name;
    }

    private void setPackage(String packageName) {
        this.mPackage = packageName;
    }

    private Node getNode() {
        return this.mNode;
    }

    private void setNode(Node node) {
        this.mNode = node;
    }
}

