/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart;

import com.sap.tools.webdynpro.smart.Logging;

public class WDHelper {
    public static final int CLASS_LAYOUT_STANDARD = 0;
    public static final int CLASS_LAYOUT_GENERIC_PROXY = 1;
    public static final int CLASS_LAYOUT_NO_INTERFACE = 2;
    public static final int TYPE_CATEGORY_UNKNOWN = -1;
    public static final int TYPE_CATEGORY_GENERATED_CONTEXT_NODE_IMPL = 1;
    public static final int TYPE_CATEGORY_GENERATED_CONTEXT_NODE_INTF = 2;
    public static final int TYPE_CATEGORY_GENERATED_CONTEXT_ELEMENT_IMPL = 4;
    public static final int TYPE_CATEGORY_GENERATED_CONTEXT_ELEMENT_INTF = 8;
    public static final int TYPE_CATEGORY_GENERATED_EVENTHANDLER_ENUM = 16;
    public static final int TYPE_CATEGORY_GENERATED_CONTROLLER_IMPL = 32;
    public static final int TYPE_CATEGORY_GENERATED_CONTROLLER_INTF = 64;
    public static final int TYPE_CATEGORY_GENERATED_MESSAGES = 128;
    public static final int TYPE_CATEGORY_GENERATED_CONTROLLER_EXT_PROX = 256;
    public static final int TYPE_CATEGORY_GENERATED_OTHER = 512;
    public static final int TYPE_CATEGORY_OTHER = 0;
    public static final int TYPE_CATEGORY_GENERATED_CONTROLLER_EXTERNAL_INTF = 1024;
    private final int clVariant;
    private final Logging log;

    public WDHelper(int clVariant, Logging log) {
        this.clVariant = clVariant;
        this.log = log;
    }

    public int getTypeCategory(String qualifiedClassName) {
        String className = qualifiedClassName;
        String pkgName = "";
        int p = className.lastIndexOf(46);
        if (p >= 0) {
            pkgName = className.substring(0, p);
            className = className.substring(p + 1);
        }
        String shortName = null;
        if (className.indexOf(36) >= 0) {
            shortName = className.substring(className.lastIndexOf(36) + 1);
        }
        if (pkgName.endsWith(".wdp")) {
            if (className.startsWith("IPrivate") || className.startsWith("IPublic")) {
                if (shortName != null && shortName.startsWith("I") && shortName.endsWith("Node")) {
                    return this.clVariant == 2 ? 1 : 2;
                }
                if (shortName != null && shortName.startsWith("I") && shortName.endsWith("Element")) {
                    return this.clVariant == 2 ? 4 : 8;
                }
                if (shortName != null && shortName.equals("WDActionEventHandler")) {
                    return 16;
                }
                if (shortName == null) {
                    return 64;
                }
                return 512;
            }
            if (className.startsWith("Internal")) {
                if (shortName != null && shortName.endsWith("Node") && this.clVariant != 2) {
                    return 1;
                }
                if (shortName != null && shortName.endsWith("Element") && this.clVariant != 2) {
                    return 4;
                }
                if (shortName != null && shortName.equals("External")) {
                    return 256;
                }
                if (shortName == null) {
                    return 32;
                }
                return 512;
            }
            if (className.startsWith("IExternal")) {
                if (shortName == null) {
                    return 1024;
                }
                this.log.trace("type category unknown for " + qualifiedClassName);
                return 512;
            }
            if (className.startsWith("IMessage")) {
                if (shortName == null) {
                    return 128;
                }
                this.log.trace("type category unknown for " + qualifiedClassName);
                return 512;
            }
            return 512;
        }
        return 0;
    }

    public static String getInternalName(String implName) {
        String className = implName;
        String pkgName = "";
        int p = className.lastIndexOf(46);
        if (p >= 0) {
            pkgName = className.substring(0, p);
            className = className.substring(p + 1);
        }
        String shortName = null;
        String outerName = className;
        if (className.indexOf(36) >= 0) {
            outerName = className.substring(0, className.lastIndexOf(36));
            shortName = className.substring(className.lastIndexOf(36) + 1);
            if (shortName.startsWith("I")) {
                shortName = shortName.substring("I".length());
            }
            if (outerName.startsWith("IPublic")) {
                outerName = "Internal" + outerName.substring("IPublic".length());
            } else if (outerName.startsWith("IPrivate")) {
                outerName = "Internal" + outerName.substring("IPrivate".length());
            }
            return pkgName + "." + outerName + "$" + shortName;
        }
        return null;
    }
}

