/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart;

import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.ClassFileElementFactory;
import com.sap.tools.webdynpro.bytecode.ClassFileLoader;
import com.sap.tools.webdynpro.bytecode.FieldInfo;
import com.sap.tools.webdynpro.bytecode.filters.Filter;
import com.sap.tools.webdynpro.smart.ClassFileMinimizer;
import com.sap.tools.webdynpro.smart.Logging;
import com.sap.tools.webdynpro.smart.NonFatalException;
import com.sap.tools.webdynpro.smart.WDHelper;
import com.sap.tools.webdynpro.smart.pp.PublicPartAnalyzer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WDClassFileMinimizer
extends ClassFileMinimizer {
    private final WDHelper wdHelper;
    private final String ppfilelist;
    private Filter ppFilter = null;

    public WDClassFileMinimizer(Logging.ExternalLog log, boolean preview, Map parameters) {
        super(log, preview, parameters);
        int cgVariant = parameters.get("classLayout") == null ? 2 : (Integer)parameters.get("classLayout");
        this.wdHelper = new WDHelper(cgVariant, this.log);
        this.ppfilelist = (String)parameters.get("ppfilelist");
    }

    protected ClassFileElementFactory createFactory(boolean isForProjectClasses) {
        return new WDFactory(isForProjectClasses);
    }

    protected Set determineEntryPointFields(ClassFile clazz) {
        HashSet<FieldInfo> result = new HashSet<FieldInfo>(super.determineEntryPointFields(clazz));
        if (this.isPartOfPP(clazz)) {
            this.log.trace("class " + clazz.getName() + " is part of pp");
            result.addAll(Arrays.asList(clazz.getFields()));
        }
        return result;
    }

    public void initialize() throws NonFatalException {
        this.ppFilter = PublicPartAnalyzer.analyzePublicPartFileList(this.log, this.ppfilelist);
        if (this.ppFilter == null) {
            throw new NonFatalException("failed to analyze public part definitions, minimizer skipped");
        }
    }

    protected void markAll(Collection methods) {
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            ClassFileMinimizer.MyMethodInfo method = (ClassFileMinimizer.MyMethodInfo)((Object)it.next());
            method.setReachable();
        }
    }

    protected void markEntryPointMethods(ClassFile clazz) {
        super.markEntryPointMethods(clazz);
        if (this.isPartOfPP(clazz)) {
            this.log.trace("class " + clazz.getName() + " is part of pp");
            this.markAll(Arrays.asList(clazz.getMethods()));
        } else {
            int tc = ((WDClassInfo)clazz).getWDType();
            switch (tc) {
                case 32: {
                    this.markAll(clazz.findMethods("<init>"));
                    break;
                }
                case 0: {
                    this.markAll(clazz.findMethods("<init>"));
                    break;
                }
            }
        }
    }

    private boolean isPartOfPP(ClassFile cf) {
        return this.ppFilter.accepts((Object)cf);
    }

    class WDFactory
    extends ClassFileMinimizer.MyFactory {
        WDFactory(boolean isForProjectClasses) {
            super(isForProjectClasses);
        }

        public ClassFile createClassFile(ClassFileLoader loader) {
            return new WDClassInfo(loader, this.isProjectClassLoader);
        }
    }

    class WDClassInfo
    extends ClassFileMinimizer.MyClassFile {
        private int wdType = -1;

        WDClassInfo(ClassFileLoader loader, boolean isProjectClass) {
            super(loader, isProjectClass);
        }

        int getWDType() {
            if (this.wdType == -1) {
                this.wdType = WDClassFileMinimizer.this.wdHelper.getTypeCategory(this.getName());
            }
            return this.wdType;
        }
    }
}

