/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart;

import com.sap.tools.webdynpro.bytecode.AttributeInfo;
import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.attributes.CodeAttribute;
import com.sap.tools.webdynpro.bytecode.visitors.DefaultVisitor;

public class RemoveDebugInfoVisitor
extends DefaultVisitor {
    private final boolean removeLineNumberTable;
    private final boolean removeLocalVariableTable;
    private final boolean removeSourceFileTable;

    public RemoveDebugInfoVisitor(int debugInfosToKeep) {
        this.removeLineNumberTable = (debugInfosToKeep & 2) == 0;
        this.removeLocalVariableTable = (debugInfosToKeep & 4) == 0;
        this.removeSourceFileTable = (debugInfosToKeep & 1) == 0;
    }

    public Object visit(CodeAttribute code, Object data) {
        int i = 0;
        while (i < code.getAttributesCount()) {
            AttributeInfo attr = code.getAttribute(i);
            if (this.removeLineNumberTable && "LineNumberTable".equals(attr.getName()) || this.removeLocalVariableTable && "LocalVariableTable".equals(attr.getName())) {
                code.removeAttribute(attr);
                continue;
            }
            ++i;
        }
        return super.visit(code, data);
    }

    public Object visit(ClassFile cf, Object data) {
        int i = 0;
        while (i < cf.getAttributesCount()) {
            AttributeInfo attr = cf.getAttribute(i);
            if (this.removeSourceFileTable && "SourceFile".equals(attr.getName())) {
                cf.removeAttribute(attr);
                continue;
            }
            ++i;
        }
        return super.visit(cf, data);
    }
}

