/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart;

import java.io.PrintStream;

public class Logging {
    private final ExternalLog externalLog;
    private PrintStream out;
    private int indent = 0;

    protected Logging(ExternalLog log) {
        this.externalLog = log;
    }

    void setReportStream(PrintStream out) {
        this.out = out;
    }

    public void indent() {
        ++this.indent;
    }

    public void unindent() {
        --this.indent;
    }

    private String indent(String message) {
        if (this.indent == 0) {
            return message;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.indent) {
            buf.append("  ");
            ++i;
        }
        buf.append(message);
        return buf.toString();
    }

    public void trace(String message) {
        message = this.indent(message);
        if (this.out != null) {
            this.out.println(message);
        }
    }

    public void info(String message) {
        message = this.indent(message);
        if (this.out != null) {
            this.out.println(message);
        }
        this.externalLog.info(message);
    }

    public void warning(String message) {
        message = this.indent(message);
        if (this.out != null) {
            this.out.println(message);
        }
        this.externalLog.warning(message);
    }

    public void error(String message) {
        message = this.indent(message);
        if (this.out != null) {
            this.out.println(message);
        }
        this.externalLog.error(message);
    }

    public void error(String message, Throwable t) {
        message = this.indent(message);
        if (this.out != null) {
            this.out.println(message);
            t.printStackTrace(this.out);
        }
        this.externalLog.error(message, t);
    }

    public static interface ExternalLog {
        public void trace(String var1);

        public void info(String var1);

        public void warning(String var1);

        public void error(String var1);

        public void error(String var1, Throwable var2);
    }
}

