/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart;

import com.sap.tools.webdynpro.bytecode.util.StringUtil;
import com.sap.tools.webdynpro.smart.ClassFileMinimizer;
import com.sap.tools.webdynpro.smart.Logging;
import com.sap.tools.webdynpro.smart.NonFatalException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ClassFileMinimizerTask
extends Task {
    private Path projectCP;
    private Path frameworkCP;
    private int layout = 2;
    private boolean preview = false;
    private boolean skipOnNonFatalError = true;
    private File logFile = null;
    private File destDir = new File(".");
    private String ppfilelist = null;
    private int debugInfos = 3;
    private String mode = "auto";
    private String minimizerClassName = null;

    static int parseDebugInfos(String debugInfos) {
        if ("none".equalsIgnoreCase(debugInfos)) {
            return 0;
        }
        if ("all".equalsIgnoreCase(debugInfos)) {
            return 65535;
        }
        int result = 0;
        String[] tokens = StringUtil.divide((String)debugInfos, (String)",");
        int i = 0;
        while (i < tokens.length) {
            if ("line".equalsIgnoreCase(tokens[i])) {
                result |= 2;
            } else if ("source".equalsIgnoreCase(tokens[i])) {
                result |= 1;
            } else if ("vars".equalsIgnoreCase(tokens[i])) {
                result |= 4;
            }
            ++i;
        }
        return result;
    }

    public Path createClasspath() {
        if (this.projectCP == null) {
            this.projectCP = new Path(((ProjectComponent)this).project);
        }
        return this.projectCP;
    }

    public Path createFwkClasspath() {
        if (this.frameworkCP == null) {
            this.frameworkCP = new Path(((ProjectComponent)this).project);
        }
        return this.frameworkCP;
    }

    public void setClasslayout(String layout) {
        if ("standard".equals(layout)) {
            this.layout = 0;
        } else if ("genproxy".equals(layout)) {
            this.layout = 1;
        } else if ("nointf".equals(layout)) {
            this.layout = 2;
        }
    }

    public void setMinimizerClass(String minimizer) {
        this.minimizerClassName = minimizer;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setLog(File logFile) {
        this.logFile = logFile;
    }

    public void setDir(File destDir) {
        this.destDir = destDir;
    }

    public void setPpfilelist(String ppfilelist) {
        this.ppfilelist = ppfilelist;
    }

    public void setDebug(String debugInfos) {
        this.debugInfos = ClassFileMinimizerTask.parseDebugInfos(debugInfos);
    }

    public void setSkipOnNoFatalError(boolean skip) {
        this.skipOnNonFatalError = skip;
    }

    public void execute() throws BuildException {
        if (this.projectCP == null) {
            throw new BuildException("no classpath specified");
        }
        if (this.destDir == null || !this.destDir.isDirectory()) {
            throw new BuildException("dest must specify an existing directory");
        }
        if (this.minimizerClassName == null) {
            if (this.mode.equalsIgnoreCase("auto")) {
                this.minimizerClassName = "com.sap.tools.webdynpro.smart.WDClassFileMinimizer";
            } else {
                throw new BuildException("either an implementation or a known mode must be specified");
            }
        }
        PrintStream out = null;
        if (this.logFile != null) {
            try {
                out = new PrintStream(new FileOutputStream(this.logFile));
            }
            catch (FileNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
        }
        long t0 = System.currentTimeMillis();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("classLayout", new Integer(this.layout));
        if (this.ppfilelist != null) {
            parameters.put("ppfilelist", this.ppfilelist);
        }
        parameters.put("keepDebugInfos", new Integer(this.debugInfos));
        try {
            ClassFileMinimizer rh = ClassFileMinimizer.getInstance(this.minimizerClassName, new LogAdapter(), this.preview, parameters);
            rh.setReportStream(out);
            rh.setClassPaths(this.projectCP.toString(), this.frameworkCP == null ? null : this.frameworkCP.toString());
            rh.initialize();
            rh.analyze();
            rh.stripAll(this.destDir);
            long t2 = System.currentTimeMillis();
            this.log("Reduced total class file size by " + rh.getReduction() + " (" + (t2 - t0) + " ms)");
        }
        catch (NonFatalException e) {
            this.log("Non Fatal Error: " + e.getMessage(), 0);
            if (e.getCause() != null) {
                e.printStackTrace();
            }
            if (this.skipOnNonFatalError) {
                this.log("Warning: Minimization skipped due to non fatal errors (see above). Classes have not been touched.", 1);
            }
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private class LogAdapter
    implements Logging.ExternalLog {
        private LogAdapter() {
        }

        public void trace(String message) {
            ClassFileMinimizerTask.this.log(message, 3);
        }

        public void info(String message) {
            ClassFileMinimizerTask.this.log(message, 2);
        }

        public void warning(String message) {
            ClassFileMinimizerTask.this.log(message, 1);
        }

        public void error(String message) {
            ClassFileMinimizerTask.this.log(message, 0);
        }

        public void error(String message, Throwable e) {
            ClassFileMinimizerTask.this.log(message, 0);
        }
    }
}

