/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart;

import com.sap.tools.webdynpro.smart.ClassFileMinimizer;
import com.sap.tools.webdynpro.smart.ClassFileMinimizerTask;
import com.sap.tools.webdynpro.smart.Logging;
import com.sap.tools.webdynpro.smart.NonFatalException;
import com.sap.tools.webdynpro.smart.util.CmdLineHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;

public class ClassFileMinimizerConsole {
    private static String minimizerClassName = "com.sap.tools.webdynpro.smart.WDClassFileMinimizer";
    private static String projectClassPath = "";
    private static String frameworkClassPath = null;
    private static int classLayoutVariant = 0;
    private static File dest = new File(".");
    private static boolean preview = false;
    private static String ppfilelist = null;
    private static int debugInfos = 3;
    private static PrintStream reportStream = null;

    public static void usage(String errorMsg) {
        if (errorMsg != null) {
            System.err.println();
            System.err.println("**** error " + errorMsg);
            System.err.println();
        }
        System.err.println("Usage: ClassFileMinimizerConsole <options> <classes>...");
        System.err.println();
        System.err.println("where options include:");
        System.err.println("   -fwkclasspath <pathlist>  Specify where to find framework class files");
        System.err.println("   -classpath <pathlist>     Specify where to find user class files");
        System.err.println("   -classlayout <layout>     selects the naming scheme as used by the code generator.");
        System.err.println("                             Possible values are:");
        System.err.println("                               standard");
        System.err.println("                               genproxy");
        System.err.println("                               nointf");
        System.err.println("   -minimizer <class>        subclass of Reachability to use (defaults to WDClassFileMinimizer)");
        System.err.println("   -d <dir>                  directory to write stripped classes to");
        System.err.println("   -debug (all|none|...)     keep the specified debug infos (defaults to source,line)");
        System.err.println("   -preview                  show which methods could be removed, but don't remove them");
        System.err.println("   -log <file>               redirect log to specified file");
        System.err.println("   -help                     Print this usage message");
        System.err.println();
        System.exit(errorMsg != null ? -1 : 0);
    }

    public static void main(String[] args) throws IOException {
        block30: {
            long t0 = System.currentTimeMillis();
            args = CmdLineHelper.expandedArgs(args);
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-classpath")) {
                    projectClassPath = args[++i];
                } else if (args[i].equals("-fwkclasspath")) {
                    frameworkClassPath = args[++i];
                } else if (args[i].equals("-classlayout")) {
                    String layout;
                    if (i + 1 >= args.length) {
                        ClassFileMinimizerConsole.usage("missing 'layout' argument for option -classlayout");
                    }
                    if ("standard".equals(layout = args[++i])) {
                        classLayoutVariant = 0;
                    } else if ("genproxy".equals(layout)) {
                        classLayoutVariant = 1;
                    } else if ("nointf".equals(layout)) {
                        classLayoutVariant = 2;
                    } else {
                        ClassFileMinimizerConsole.usage("unknown class layout '" + layout + "'");
                    }
                } else if (args[i].equals("-minimizer")) {
                    minimizerClassName = args[++i];
                } else if (args[i].equals("-preview")) {
                    preview = true;
                } else if (args[i].equals("-ppfilelist")) {
                    ppfilelist = args[++i];
                } else if (args[i].equals("-log")) {
                    reportStream = new PrintStream(new FileOutputStream(args[++i]));
                } else if (args[i].equals("-d")) {
                    dest = new File(args[++i]);
                } else if (args[i].equals("-debug")) {
                    debugInfos = ClassFileMinimizerTask.parseDebugInfos(args[++i]);
                } else {
                    if (args[i].startsWith("-")) {
                        throw new RuntimeException("unsupported option " + args[i]);
                    }
                    throw new RuntimeException("illegal argument " + args[i]);
                }
                ++i;
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("classLayout", new Integer(classLayoutVariant));
            if (ppfilelist != null) {
                parameters.put("ppfilelist", ppfilelist);
            }
            parameters.put("keepDebugInfos", new Integer(debugInfos));
            try {
                ClassFileMinimizer rh = ClassFileMinimizer.getInstance(minimizerClassName, new PrintStreamLog(System.out), preview, parameters);
                rh.setReportStream(reportStream);
                rh.setClassPaths(projectClassPath, frameworkClassPath);
                rh.initialize();
                rh.analyze();
                rh.stripAll(dest);
                long t2 = System.currentTimeMillis();
                System.out.println("Reduced total class file size by " + rh.getReduction() + " (" + (t2 - t0) + " ms)");
            }
            catch (NonFatalException e) {
                System.err.println("Minimizer failed, classes have not been modified: " + e.getMessage());
                if (e.getCause() == null) break block30;
                e.printStackTrace();
            }
        }
    }

    private static class PrintStreamLog
    implements Logging.ExternalLog {
        private final PrintStream out;

        PrintStreamLog(PrintStream out) {
            this.out = out;
        }

        private void println(String category, String message) {
            this.out.print(category);
            this.out.println(message);
        }

        public void trace(String message) {
            this.println("  [Trace]", message);
        }

        public void info(String message) {
            this.println("   [Info]", message);
        }

        public void warning(String message) {
            this.println("[Warning]", message);
        }

        public void error(String message) {
            this.println("  [Error]", message);
        }

        public void error(String message, Throwable e) {
            this.println("  [Error]", message);
        }
    }
}

