/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tools.webdynpro.smart;

import com.sap.tools.webdynpro.bytecode.CPItem;
import com.sap.tools.webdynpro.bytecode.ClassFile;
import com.sap.tools.webdynpro.bytecode.ClassFileElementFactory;
import com.sap.tools.webdynpro.bytecode.ClassFileLoader;
import com.sap.tools.webdynpro.bytecode.ClassFileVisitor;
import com.sap.tools.webdynpro.bytecode.FieldInfo;
import com.sap.tools.webdynpro.bytecode.Instruction;
import com.sap.tools.webdynpro.bytecode.MemberInfo;
import com.sap.tools.webdynpro.bytecode.MethodInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_Class_Info;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_FieldRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_InterfaceMethodRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_MemberRefInfo;
import com.sap.tools.webdynpro.bytecode.cpitems.CONST_MethodRefInfo;
import com.sap.tools.webdynpro.bytecode.util.URLClassFileLoader;
import com.sap.tools.webdynpro.bytecode.visitors.DefaultVisitor;
import com.sap.tools.webdynpro.smart.Logging;
import com.sap.tools.webdynpro.smart.NonFatalException;
import com.sap.tools.webdynpro.smart.RemoveDebugInfoVisitor;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ClassFileMinimizer {
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_SOURCE = 1;
    public static final int DEBUG_LINE = 2;
    public static final int DEBUG_VARS = 4;
    public static final int DEBUG_DEFAULT = 3;
    public static final int DEBUG_ALL = 65535;
    private static final boolean T = true;
    protected V instructionVisitor = new V();
    private ClassFileLoader cfLoader;
    private Collection projectClassNames;
    private int modifiedClasses = 0;
    private int activeFields = 0;
    private int removedFields = 0;
    private int zombieFields = 0;
    private int activeMethods = 0;
    private int removedMethods = 0;
    private int zombieMethods = 0;
    protected boolean preview;
    protected int debugInfosToKeep = 3;
    protected RemoveDebugInfoVisitor rdiVisitor;
    protected final Logging log;
    private MyClassFile[] projectClasses;
    private static Set primitives = new HashSet();
    private ClassFile lastVisitedClass = null;
    MemberInfo.Signature sig_serialVersionUID = new MemberInfo.Signature("serialVersionUID", "J");
    MemberInfo.Signature sig_serialPersistentFields = new MemberInfo.Signature("serialPersistentFields", "[Ljava/io/ObjectStreamField;");
    MemberInfo.Signature sig_main = new MemberInfo.Signature("main", "([Ljava/lang/String;)V");
    private int oldClassFileSize;
    private int newClassFileSize;
    static /* synthetic */ Class class$com$sap$tools$webdynpro$smart$Logging$ExternalLog;
    static /* synthetic */ Class class$java$util$Map;

    public ClassFileMinimizer(Logging.ExternalLog log, boolean preview, Map parameters) {
        this.cfLoader = ClassFileLoader.getSystemClassFileLoader();
        this.log = new Logging(log);
        this.preview = preview;
        if (parameters.containsKey("keepDebugInfos")) {
            this.debugInfosToKeep = (Integer)parameters.get("keepDebugInfos");
        }
        if (this.debugInfosToKeep != 65535) {
            this.rdiVisitor = new RemoveDebugInfoVisitor(this.debugInfosToKeep);
        }
    }

    protected ClassFileElementFactory createFactory(boolean isForProjectClasses) {
        return new MyFactory(isForProjectClasses);
    }

    public void setClassPaths(String projectClassPath, String frameworkClassPath) {
        URLClassFileLoader frameworkLoader = frameworkClassPath == null ? ClassFileLoader.createSystemClassFileLoader((ClassFileElementFactory)this.createFactory(false)) : new URLClassFileLoader(frameworkClassPath, null, this.createFactory(false));
        URLClassFileLoader projectLoader = new URLClassFileLoader(projectClassPath, (ClassFileLoader)frameworkLoader, this.createFactory(true));
        this.cfLoader = projectLoader;
    }

    public final void setReportStream(PrintStream reportStream) {
        this.log.setReportStream(reportStream);
    }

    protected Collection getProjectClassNames() {
        if (this.projectClassNames == null) {
            this.projectClassNames = this.cfLoader instanceof URLClassFileLoader ? new TreeSet(((URLClassFileLoader)this.cfLoader).getClassNames()) : Collections.EMPTY_SET;
        }
        return this.projectClassNames;
    }

    protected MyClassFile[] getProjectClasses() throws NonFatalException {
        if (this.projectClasses == null) {
            ArrayList<MyClassFile> projectClassesList = new ArrayList<MyClassFile>();
            Iterator it = this.getProjectClassNames().iterator();
            while (it.hasNext()) {
                MyClassFile cf = this.findClassInfo((String)it.next());
                if (cf.getMajorVersion() > 48) {
                    throw new NonFatalException("Unsupported class file version " + cf.getMajorVersion() + "." + cf.getMinorVersion() + " (major.minor) in class " + cf.getName() + "; max. supported version is 48.x.");
                }
                projectClassesList.add(cf);
            }
            this.projectClasses = projectClassesList.toArray(new MyClassFile[projectClassesList.size()]);
        }
        return this.projectClasses;
    }

    private boolean mustImplBeVisited(CONST_Class_Info clazz) {
        String className = clazz.getClassName();
        return this.getProjectClassNames().contains(className);
    }

    private MyClassFile findClassInfo(String className) {
        return (MyClassFile)this.cfLoader.loadClassFile(className);
    }

    private boolean isPrimitive(String className) {
        return primitives.contains(className);
    }

    private void reached(String className) {
        if (className != null) {
            int l = className.length();
            String s = className.substring(0, l);
            while (s.endsWith("[]")) {
                s = className.substring(0, l -= 2);
            }
            if (!this.getProjectClassNames().contains(s)) {
                return;
            }
            this.reached(this.findClassInfo(s));
        }
    }

    public void reached(MyClassFile cf) {
        MyClassFile ci = cf;
        if (!ci.isVisited()) {
            ci.setVisited();
            if (ci.getSuperClass() != null) {
                this.reached(ci.getSuperClass());
            }
            int i = 0;
            while (i < ci.getInterfacesCount()) {
                this.reached(ci.getInterface(i));
                ++i;
            }
            Collection clinits = ci.findMethods("<clinit>");
            Iterator it = clinits.iterator();
            while (it.hasNext()) {
                MyMethodInfo method = (MyMethodInfo)((Object)it.next());
                this.reached(method);
            }
        }
    }

    private void reached(MyFieldInfo field) {
        this.log.indent();
        try {
            this.log.trace("reached " + (Object)((Object)field) + " (#" + System.identityHashCode((Object)field) + ")");
            if (!field.isVisited()) {
                field.setVisited();
                this.reached((MyClassFile)field.getDeclaringClass());
                this.reached(field.getType().replace('/', '.'));
            } else {
                this.log.trace(" already visited, skipped");
            }
            Object var3_2 = null;
            this.log.unindent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.log.unindent();
            throw throwable;
        }
    }

    public void reached(MyMethodInfo method) {
        this.log.indent();
        try {
            this.log.trace("reached " + (Object)((Object)method) + " (#" + System.identityHashCode((Object)method) + ")");
            if (!method.visited) {
                method.setVisited();
                this.log.trace(" visiting");
                this.reached((MyClassFile)method.getDeclaringClass());
                int i = 0;
                while (i < method.getExceptionsCount()) {
                    this.reached(method.getException(i));
                    ++i;
                }
                if (method.getReturnType() != null) {
                    this.reached(method.getReturnType().replace('/', '.'));
                }
                int i2 = 0;
                while (i2 < method.getArgumentCount()) {
                    this.reached(method.getArgumentType(i2).replace('/', '.'));
                    ++i2;
                }
                Set refs = (Set)method.letChildrenAccept((ClassFileVisitor)this.instructionVisitor, new HashSet());
                Iterator it = refs.iterator();
                while (it.hasNext()) {
                    CPItem cpitem = (CPItem)it.next();
                    if (cpitem instanceof CONST_FieldRefInfo) {
                        this.reached((CONST_FieldRefInfo)cpitem);
                        continue;
                    }
                    if (cpitem instanceof CONST_InterfaceMethodRefInfo) {
                        this.reached((CONST_InterfaceMethodRefInfo)cpitem);
                        continue;
                    }
                    if (cpitem instanceof CONST_MethodRefInfo) {
                        this.reached((CONST_MethodRefInfo)cpitem);
                        continue;
                    }
                    if (!(cpitem instanceof CONST_Class_Info)) continue;
                    this.reached((CONST_Class_Info)cpitem);
                }
            } else {
                this.log.trace(" already visited, skipped");
            }
            Object var8_7 = null;
            this.log.unindent();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.log.unindent();
            throw throwable;
        }
    }

    private void reached(CONST_Class_Info clazz) {
        this.log.indent();
        try {
            if (!this.mustImplBeVisited(clazz)) {
                Object var4_2 = null;
                this.log.unindent();
                return;
            }
            MyClassFile cf = this.resolveClass(clazz);
            this.reached(cf);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.log.unindent();
            throw throwable;
        }
        Object var4_3 = null;
        this.log.unindent();
    }

    private void reached(CONST_FieldRefInfo fieldRef) {
        this.log.indent();
        try {
            if (!this.mustImplBeVisited(fieldRef.getClassCPItem())) {
                Object var5_2 = null;
                this.log.unindent();
                return;
            }
            MyClassFile cf = this.resolveClass(fieldRef.getClassCPItem());
            MyFieldInfo field = this.resolveField(cf, fieldRef.getSignature());
            this.reached(field);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.log.unindent();
            throw throwable;
        }
        Object var5_3 = null;
        this.log.unindent();
    }

    private void reached(CONST_MethodRefInfo methodRef) {
        this.log.indent();
        try {
            this.log.trace("instruction references " + methodRef);
            if (!this.mustImplBeVisited(methodRef.getClassCPItem())) {
                this.log.trace(" out of scope, ignored");
                Object var5_2 = null;
                this.log.unindent();
                return;
            }
            MyClassFile cf = this.resolveClass(methodRef.getClassCPItem());
            MyMethodInfo method = this.resolveMethod(cf, methodRef.getSignature());
            this.reached(method);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.log.unindent();
            throw throwable;
        }
        Object var5_3 = null;
        this.log.unindent();
    }

    private void reached(CONST_InterfaceMethodRefInfo methodRef) {
        this.log.indent();
        try {
            this.log.trace("instruction references " + methodRef);
            if (!this.mustImplBeVisited(methodRef.getClassCPItem())) {
                this.log.trace(" out of scope, ignored");
                Object var5_2 = null;
                this.log.unindent();
                return;
            }
            MyClassFile cf = this.resolveClass(methodRef.getClassCPItem());
            MyMethodInfo method = this.resolveMethod(cf, methodRef.getSignature());
            this.reached(method);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.log.unindent();
            throw throwable;
        }
        Object var5_3 = null;
        this.log.unindent();
    }

    private MyClassFile resolveClass(CONST_Class_Info classRef) {
        return (MyClassFile)this.cfLoader.loadClassFile(classRef.getClassName());
    }

    private MyFieldInfo resolveField(MyClassFile cf, MemberInfo.Signature signature) {
        this.log.trace("looking for " + signature + " in " + cf.getName());
        MyFieldInfo field = cf.lookupField(signature);
        if (field == null) {
            throw new NoSuchFieldError(cf.getName() + " " + signature.toString());
        }
        return field;
    }

    private MyMethodInfo resolveMethod(MyClassFile cf, MemberInfo.Signature signature) {
        this.log.trace("looking for " + signature + " in " + cf.getName());
        MyMethodInfo method = cf.lookupMethod(signature);
        if (method == null) {
            throw new NoSuchMethodError(signature.toString());
        }
        return method;
    }

    private void propagateReachabilityFromSuperTypes(ClassFile observed, boolean includeFramework) {
        this.propagateReachabilityFromSuperTypes(observed, observed.getName(), new HashSet(), 0, includeFramework);
    }

    private void propagateReachabilityFromSuperTypes(ClassFile observed, String className, Set visitedClasses, int depth, boolean includeFramework) {
        if (visitedClasses.contains(className)) {
            return;
        }
        visitedClasses.add(className);
        MyClassFile ci = this.findClassInfo(className);
        if (!includeFramework && !ci.isProjectClass) {
            return;
        }
        if (depth > 0) {
            MethodInfo[] methods = ci.getMethods();
            int i = 0;
            while (i < methods.length) {
                MyMethodInfo observedMethod;
                MyMethodInfo method = (MyMethodInfo)methods[i];
                if ((method.getAccessFlags() & 8) == 0 && method.reachable && (observedMethod = (MyMethodInfo)observed.findMethod(method.getSignature())) != null) {
                    observedMethod.setReachable();
                }
                ++i;
            }
        }
        if (ci.getSuperClass() != null) {
            this.propagateReachabilityFromSuperTypes(observed, ci.getSuperClass().getClassName(), visitedClasses, depth + 1, includeFramework);
        }
        int i = 0;
        while (i < ci.getInterfacesCount()) {
            this.propagateReachabilityFromSuperTypes(observed, ci.getInterface(i).getClassName(), visitedClasses, depth + 1, includeFramework);
            ++i;
        }
    }

    private Boolean findOverriddenVisitedMethod(String className, MemberInfo.Signature signature) {
        return this.findOverriddenVisitedMethod(new HashSet(), 0, className, signature);
    }

    private Boolean findOverriddenVisitedMethod(Set visited, int depth, String className, MemberInfo.Signature signature) {
        if (visited.contains(className)) {
            return null;
        }
        visited.add(className);
        MyClassFile ci = this.findClassInfo(className);
        MethodInfo method = ci.findMethod(signature);
        if (method != null) {
            if (method instanceof MyMethodInfo && ((MyMethodInfo)method).isVisited()) {
                this.log.trace("    already reached in " + className);
                return Boolean.TRUE;
            }
            if (depth > 0) {
                this.log.trace("    found an unreached version in " + className);
                return Boolean.FALSE;
            }
        }
        Boolean result = null;
        if (ci.getSuperClass() != null) {
            Boolean tmp = this.findOverriddenVisitedMethod(visited, depth + 1, ci.getSuperClassName(), signature);
            if (tmp != null && tmp.booleanValue()) {
                return Boolean.TRUE;
            }
            if (tmp != null) {
                result = Boolean.FALSE;
            }
        }
        int i = 0;
        while (i < ci.getInterfacesCount()) {
            Boolean tmp = this.findOverriddenVisitedMethod(visited, depth + 1, ci.getInterface(i).getClassName(), signature);
            if (tmp != null && tmp.booleanValue()) {
                return Boolean.TRUE;
            }
            if (tmp != null) {
                result = Boolean.FALSE;
            }
            ++i;
        }
        this.log.trace("    found no reached version in " + className);
        return result;
    }

    private void traceClass(ClassFile cf) {
        if (this.lastVisitedClass != cf) {
            this.lastVisitedClass = cf;
            this.log.trace(cf.getName() + " (" + System.identityHashCode(cf) + ")");
        }
    }

    public void initialize() throws NonFatalException {
    }

    public void analyze() throws NonFatalException {
        boolean found;
        MyMethodInfo method;
        int j;
        int pass = 0;
        this.log.info("Analyzing " + this.getProjectClassNames().size() + " classes from " + this.cfLoader);
        long t0 = System.currentTimeMillis();
        MyClassFile[] projectClasses = this.getProjectClasses();
        long t1 = System.currentTimeMillis();
        this.log.info("  Classes loaded in " + (t1 - t0) + " ms.");
        this.log.trace("");
        this.log.trace("**** pass " + pass + " ****");
        this.log.trace("");
        int i = 0;
        while (i < projectClasses.length) {
            MyClassFile ci = projectClasses[i];
            this.markEntryPointMethods(ci);
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.log.info("  Completed pass 0 in " + (t2 - t1) + " ms (using a priori knowledge).");
        t1 = t2;
        this.log.trace("");
        this.log.trace("**** pass " + ++pass + " ****");
        this.log.trace("");
        int i2 = 0;
        while (i2 < projectClasses.length) {
            MyClassFile ci = projectClasses[i2];
            this.log.trace("visiting class " + ci.getName());
            Set fields = this.determineEntryPointFields(ci);
            Iterator it2 = fields.iterator();
            while (it2.hasNext()) {
                MyFieldInfo field = (MyFieldInfo)((Object)it2.next());
                this.reached(field);
            }
            this.propagateReachabilityFromSuperTypes(ci, true);
            j = 0;
            while (j < ci.getMethodsCount()) {
                method = (MyMethodInfo)ci.getMethod(j);
                if (method.reachable && !method.visited) {
                    this.reached(method);
                }
                ++j;
            }
            ++i2;
        }
        t2 = System.currentTimeMillis();
        this.log.info("  Completed pass 1 in " + (t2 - t1) + " ms (using a priori knowledge).");
        t1 = t2;
        do {
            this.log.trace("");
            this.log.trace("**** pass " + ++pass + " ****");
            this.log.trace("");
            found = false;
            this.lastVisitedClass = null;
            int i3 = 0;
            while (i3 < projectClasses.length) {
                MyClassFile ci = projectClasses[i3];
                this.propagateReachabilityFromSuperTypes(ci, false);
                this.traceClass(ci);
                this.log.trace(" open methods should be " + ci.unvisitedReachableMethods);
                j = 0;
                while (j < ci.getMethodsCount()) {
                    method = (MyMethodInfo)ci.getMethod(j);
                    if (!method.isVisited() && method.reachable) {
                        this.reached(method);
                        found = true;
                    }
                    ++j;
                }
                ++i3;
            }
            t2 = System.currentTimeMillis();
            this.log.info("  Completed pass " + pass + " in " + (t2 - t1) + " ms (propagating to specialized classes).");
            t1 = t2;
        } while (found);
        this.log.info("Finished Analysis (" + (t1 - t0) + " ms)");
    }

    protected Set determineEntryPointFields(ClassFile ci) {
        HashSet<FieldInfo> result = new HashSet<FieldInfo>();
        FieldInfo f = ci.findField(this.sig_serialVersionUID);
        if (f != null) {
            result.add(f);
        }
        if ((f = ci.findField(this.sig_serialPersistentFields)) != null) {
            result.add(f);
        }
        return result;
    }

    protected void markEntryPointMethods(ClassFile ci) {
        MyMethodInfo m = (MyMethodInfo)ci.findMethod(this.sig_main);
        if (m != null) {
            m.setReachable();
        }
    }

    protected boolean canBeStripped(ClassFile ci, FieldInfo method) {
        return true;
    }

    protected boolean canBeStripped(ClassFile ci, MethodInfo method) {
        return true;
    }

    private void strip(MyClassFile clazz, File dest) throws IOException {
        this.traceClass(clazz);
        int oldSize = clazz.size();
        this.oldClassFileSize += oldSize;
        int i = 0;
        while (i < clazz.getFieldsCount()) {
            MyFieldInfo field = (MyFieldInfo)clazz.getField(i);
            if (!field.isVisited()) {
                if (this.canBeStripped((ClassFile)clazz, field)) {
                    this.log.trace("  [removed]: " + field.getSignature());
                    if (!this.preview) {
                        clazz.removeField(field);
                    }
                    ++this.removedFields;
                    continue;
                }
                this.log.trace("   [zombie]: " + field.getSignature());
                ++this.zombieFields;
                ++i;
                continue;
            }
            this.log.trace("   [active]: " + field.getSignature());
            ++this.activeFields;
            ++i;
        }
        int i2 = 0;
        while (i2 < clazz.getMethodsCount()) {
            MyMethodInfo method = (MyMethodInfo)clazz.getMethod(i2);
            if (!method.isVisited()) {
                if (this.canBeStripped((ClassFile)clazz, method)) {
                    this.log.trace("  [removed]: " + method.getSignature());
                    if (!this.preview) {
                        clazz.removeMethod(method);
                    }
                    ++this.removedMethods;
                    continue;
                }
                this.log.trace("   [zombie]: " + method.getSignature());
                ++this.zombieMethods;
                ++i2;
                continue;
            }
            this.log.trace("   [active]: " + method.getSignature());
            ++this.activeMethods;
            ++i2;
        }
        if (this.rdiVisitor != null) {
            clazz.accept((ClassFileVisitor)this.rdiVisitor, null);
            this.log.trace("  [removed]: debug infos " + this.debugInfosToKeep);
        }
        if (clazz.isDirty()) {
            clazz.condenseConstantPool();
        }
        int newSize = clazz.size();
        this.newClassFileSize += newSize;
        if (clazz.isDirty()) {
            if (!this.preview) {
                File outF = new File(dest, clazz.getName().replace('.', '/') + ".class");
                FilterOutputStream out = null;
                try {
                    outF.getParentFile().mkdirs();
                    out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outF)));
                    clazz.write((DataOutput)((Object)out));
                    out.close();
                    out = null;
                    ++this.modifiedClasses;
                }
                catch (IOException e) {
                    if (out != null) {
                        out.close();
                    }
                    this.log.error("failed to update " + clazz.getName() + " (" + outF + ")", e);
                    e.printStackTrace();
                    throw e;
                }
            }
            this.log.trace("  class file updated (" + (newSize - oldSize) + " bytes, " + 100 * (newSize - oldSize) / oldSize + "%)");
        }
    }

    public void stripAll(File dest) throws IOException {
        this.oldClassFileSize = 0;
        this.newClassFileSize = 0;
        this.activeFields = 0;
        this.removedFields = 0;
        this.zombieFields = 0;
        this.activeMethods = 0;
        this.removedMethods = 0;
        this.zombieMethods = 0;
        this.log.info("");
        this.log.info("Shrinking class files");
        long t0 = System.currentTimeMillis();
        this.lastVisitedClass = null;
        Iterator it = this.projectClassNames.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            MyClassFile ci = this.findClassInfo(className);
            this.strip(ci, dest);
        }
        long t1 = System.currentTimeMillis();
        this.log.info("  checked " + (this.activeFields + this.removedFields + this.zombieFields) + " Fields, ");
        this.log.info("    active:  " + this.activeFields);
        this.log.info("    removed: " + this.removedFields);
        this.log.info("    zombie:  " + this.zombieFields);
        this.log.info("  checked " + (this.activeMethods + this.removedMethods + this.zombieMethods) + " Methods, ");
        this.log.info("    active:  " + this.activeMethods);
        this.log.info("    removed: " + this.removedMethods);
        this.log.info("    zombie:  " + this.zombieMethods);
        this.log.info("Modified " + this.modifiedClasses + " classes (" + (t1 - t0) + " ms)");
        this.log.info("");
    }

    public int getActiveMethods() {
        return this.activeMethods;
    }

    public int getModifiedClasses() {
        return this.modifiedClasses;
    }

    public int getRemovedMethods() {
        return this.removedMethods;
    }

    public int getZombieMethods() {
        return this.zombieMethods;
    }

    public String getReduction() {
        String sizeinfo = null;
        if (this.oldClassFileSize > 0) {
            sizeinfo = 100 * (this.oldClassFileSize - this.newClassFileSize) / this.oldClassFileSize + "%";
        }
        return sizeinfo;
    }

    public static ClassFileMinimizer getInstance(String className, Logging.ExternalLog log, boolean preview, Map parameters) throws NonFatalException {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getConstructor(class$com$sap$tools$webdynpro$smart$Logging$ExternalLog == null ? (class$com$sap$tools$webdynpro$smart$Logging$ExternalLog = ClassFileMinimizer.class$("com.sap.tools.webdynpro.smart.Logging$ExternalLog")) : class$com$sap$tools$webdynpro$smart$Logging$ExternalLog, Boolean.TYPE, class$java$util$Map == null ? (class$java$util$Map = ClassFileMinimizer.class$("java.util.Map")) : class$java$util$Map);
            return (ClassFileMinimizer)ctor.newInstance(log, new Boolean(preview), parameters);
        }
        catch (Exception e) {
            throw new NonFatalException("failed to create instance of minimizer", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitives.add("boolean");
        primitives.add("byte");
        primitives.add("short");
        primitives.add("int");
        primitives.add("long");
        primitives.add("char");
        primitives.add("float");
        primitives.add("double");
    }

    public static class MyFactory
    extends ClassFileLoader.DefaultFactory {
        boolean isProjectClassLoader;

        public MyFactory(boolean isProjectClassLaoder) {
            this.isProjectClassLoader = isProjectClassLaoder;
        }

        public ClassFile createClassFile(ClassFileLoader loader) {
            return new MyClassFile(loader, this.isProjectClassLoader);
        }

        public FieldInfo createField(ClassFile parent) {
            return new MyFieldInfo(parent);
        }

        public MethodInfo createMethod(ClassFile parent) {
            return new MyMethodInfo(parent);
        }
    }

    protected static class MyMethodInfo
    extends MethodInfo {
        private boolean visited = false;
        boolean reachable = false;
        boolean notOverridden = false;

        public MyMethodInfo(ClassFile classFile) {
            super(classFile);
            if (!((MyClassFile)classFile).isProjectClass) {
                this.visited = true;
                this.reachable = true;
            }
        }

        public boolean isNotOverridden() {
            return this.notOverridden;
        }

        public boolean isVisited() {
            return this.visited;
        }

        public void setNotOverridden() {
            this.notOverridden = true;
        }

        public void setVisited() {
            if (!this.visited) {
                this.visited = true;
                if (this.reachable) {
                    ((MyClassFile)this.getParent()).notifyReachableMethodVisited();
                }
                this.reachable = true;
            }
        }

        public void setReachable() {
            if (!this.reachable) {
                this.reachable = true;
                if (!this.visited) {
                    ((MyClassFile)this.getParent()).notifyUnvisitedMethodReachable();
                }
            }
        }
    }

    protected static class MyFieldInfo
    extends FieldInfo {
        boolean visited = false;

        public MyFieldInfo(ClassFile classFile) {
            super(classFile);
            if (!((MyClassFile)classFile).isProjectClass) {
                this.visited = true;
            }
        }

        public boolean isVisited() {
            return this.visited;
        }

        public void setVisited() {
            this.visited = true;
        }
    }

    protected static class MyClassFile
    extends ClassFile {
        private final boolean isProjectClass;
        boolean visited;
        int unvisitedReachableMethods = 0;
        private Map cachedSupertypeMethods;

        MyClassFile(ClassFileLoader parent, boolean isProjectClass) {
            super(parent);
            this.isProjectClass = isProjectClass;
        }

        public boolean isVisited() {
            if (this.isProjectClass) {
                return this.visited;
            }
            return true;
        }

        public void setVisited() {
            if (this.isProjectClass) {
                this.visited = true;
            }
        }

        public void removeMethod(MethodInfo method) {
            if (this.isProjectClass) {
                int index = this.indexOf(method);
                if (index >= 0) {
                    this.removeMethod(index);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private MyFieldInfo lookupField(String className, MemberInfo.Signature signature) {
            MyClassFile ci = (MyClassFile)this.getClassFileLoader().loadClassFile(className);
            return ci.lookupField(signature);
        }

        public MyFieldInfo lookupField(MemberInfo.Signature signature) {
            MyFieldInfo field = (MyFieldInfo)this.findField(signature);
            if (field != null) {
                return field;
            }
            if (this.getSuperClass() != null && (field = this.lookupField(this.getSuperClassName(), signature)) != null) {
                return field;
            }
            if (this.isInterface()) {
                int i = 0;
                while (i < this.getInterfacesCount()) {
                    field = this.lookupField(this.getInterface(i).getClassName(), signature);
                    if (field != null) {
                        return field;
                    }
                    ++i;
                }
            }
            return null;
        }

        public void removeField(FieldInfo field) {
            if (this.isProjectClass) {
                int index = this.indexOf(field);
                if (index >= 0) {
                    this.removeField(index);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        void notifyUnvisitedMethodReachable() {
            ++this.unvisitedReachableMethods;
        }

        void notifyReachableMethodVisited() {
            --this.unvisitedReachableMethods;
        }

        public MyMethodInfo lookupMethod(MemberInfo.Signature signature) {
            MyMethodInfo method = (MyMethodInfo)this.findMethod(signature);
            if (method != null) {
                return method;
            }
            if (this.cachedSupertypeMethods != null && this.cachedSupertypeMethods.containsKey(signature)) {
                return (MyMethodInfo)((Object)this.cachedSupertypeMethods.get(signature));
            }
            if (this.getSuperClass() != null && (method = this.lookupMethod(this.getSuperClassName(), signature)) != null) {
                if (this.cachedSupertypeMethods == null) {
                    this.cachedSupertypeMethods = new HashMap();
                }
                this.cachedSupertypeMethods.put(signature, method);
                return method;
            }
            if (this.isInterface()) {
                int i = 0;
                while (i < this.getInterfacesCount()) {
                    method = this.lookupMethod(this.getInterface(i).getClassName(), signature);
                    if (method != null) {
                        if (this.cachedSupertypeMethods == null) {
                            this.cachedSupertypeMethods = new HashMap();
                        }
                        this.cachedSupertypeMethods.put(signature, method);
                        return method;
                    }
                    ++i;
                }
            }
            return null;
        }

        private MyMethodInfo lookupMethod(String className, MemberInfo.Signature signature) {
            MyClassFile ci = (MyClassFile)this.getClassFileLoader().loadClassFile(className);
            return ci.lookupMethod(signature);
        }
    }

    protected class V
    extends DefaultVisitor {
        protected V() {
        }

        public Object visit(Instruction instr, Object data) {
            CONST_MemberRefInfo ref;
            Set refs = (Set)data;
            CPItem cpitem = instr.getOperand1AsConstant();
            if (cpitem instanceof CONST_Class_Info) {
                CONST_Class_Info classRef = (CONST_Class_Info)cpitem;
                if (ClassFileMinimizer.this.mustImplBeVisited(classRef)) {
                    refs.add(classRef);
                }
            } else if (cpitem instanceof CONST_MemberRefInfo && ClassFileMinimizer.this.mustImplBeVisited((ref = (CONST_MemberRefInfo)cpitem).getClassCPItem())) {
                refs.add(ref);
            }
            return data;
        }
    }
}

