/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.util;

import com.togethersoft.togetherxj.gsd.util.CUDeltaHandler$CUMap;
import com.togethersoft.togetherxj.gsd.util.IWatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;

public class CUDeltaHandler
implements IElementChangedListener {
    private CUDeltaHandler$CUMap myCUMap = new CUDeltaHandler$CUMap(null);

    public CUDeltaHandler() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.shutdownWatchers();
        this.myCUMap.removeAll();
    }

    public void addWatcher(ICompilationUnit iCompilationUnit, IWatcher iWatcher) {
        if (iCompilationUnit != null) {
            this.addWatcher(iCompilationUnit.getHandleIdentifier(), iWatcher);
        }
    }

    public void removeWatcher(ICompilationUnit iCompilationUnit, IWatcher iWatcher) {
        if (iCompilationUnit != null) {
            this.removeWatcher(iCompilationUnit.getHandleIdentifier(), iWatcher);
        }
    }

    public void addWatcher(String string, IWatcher iWatcher) {
        if (string != null && iWatcher != null) {
            this.myCUMap.putWatcher(string, iWatcher);
        }
    }

    public void removeWatcher(String string, IWatcher iWatcher) {
        if (string != null && iWatcher != null) {
            this.myCUMap.removeWatcher(string, iWatcher);
        }
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        List list;
        IJavaElement iJavaElement = elementChangedEvent.getDelta().getElement();
        if (iJavaElement instanceof IJavaModel && !this.myCUMap.isEmpty() && (list = this.allAffectedCUDeltas(elementChangedEvent.getDelta(), new ArrayList())).size() > 0) {
            this.notifyWatchers(list);
        }
    }

    private List allAffectedCUDeltas(IJavaElementDelta iJavaElementDelta, List list) {
        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
        int n2 = 0;
        while (n2 < iJavaElementDeltaArray.length) {
            IJavaElement iJavaElement = iJavaElementDeltaArray[n2].getElement();
            if (iJavaElement instanceof ICompilationUnit) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement;
                if (!iCompilationUnit.isWorkingCopy()) {
                    list.add(iJavaElementDeltaArray[n2]);
                }
            } else {
                this.allAffectedCUDeltas(iJavaElementDeltaArray[n2], list);
            }
            ++n2;
        }
        return list;
    }

    private void notifyWatchers(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IJavaElementDelta iJavaElementDelta = (IJavaElementDelta)iterator.next();
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElementDelta.getElement();
            String string = iCompilationUnit.getHandleIdentifier();
            if (!this.myCUMap.contains(string)) continue;
            if (iJavaElementDelta.getKind() == 2) {
                this.notifyEliminated(string, iCompilationUnit);
                this.myCUMap.remove(string);
                continue;
            }
            this.notifyChanged(string, iCompilationUnit);
        }
    }

    private void notifyEliminated(String string, ICompilationUnit iCompilationUnit) {
        Iterator iterator = this.myCUMap.getWatchersList(string).iterator();
        while (iterator.hasNext()) {
            IWatcher iWatcher = (IWatcher)iterator.next();
            iWatcher.eliminated(iCompilationUnit);
        }
    }

    private void notifyChanged(String string, ICompilationUnit iCompilationUnit) {
        Iterator iterator = this.myCUMap.getWatchersList(string).iterator();
        while (iterator.hasNext()) {
            IWatcher iWatcher = (IWatcher)iterator.next();
            iWatcher.changed(iCompilationUnit);
        }
    }

    private void shutdownWatchers() {
    }
}

