/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.monitor;

import com.togethersoft.togetherxj.gsd.a.a.d;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmElement;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmMessage;
import com.togethersoft.togetherxj.gsd.monitor.IMonitorRecord;
import com.togethersoft.togetherxj.gsd.monitor.JsmElementRecord$CUWatcher;
import com.togethersoft.togetherxj.gsd.monitor.JsmElementRecord$TextLocation;
import com.togethersoft.togetherxj.gsd.util.CUCache;
import com.togethersoft.togetherxj.gsd.util.SourceRange;
import com.togethersoft.togetherxj.uml.cdl.location.ITextLocation;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public abstract class JsmElementRecord
implements IMonitorRecord {
    private JsmElement myElement;
    private ITextLocation myTextLocation;
    private boolean mySourceEliminated;
    private JsmElementRecord$CUWatcher myWatcher = new JsmElementRecord$CUWatcher(this, null);
    static Class class$org$eclipse$core$resources$IFile;
    static Class class$org$eclipse$core$resources$IResource;
    static Class class$org$eclipse$jdt$core$ISourceRange;
    static Class class$org$eclipse$jdt$core$dom$MethodDeclaration;

    public JsmElementRecord(JsmElement jsmElement) {
        this.myElement = jsmElement;
    }

    public void dispose() {
        this.detachCUWatcher();
    }

    protected JsmElement getElement() {
        return this.myElement;
    }

    protected ASTNode getASTNode() {
        if (this.myElement != null) {
            return this.myElement.getAstNode();
        }
        return null;
    }

    protected IMethod getSourceMethod() {
        if (this.myElement != null) {
            return this.getSourceMethod(this.myElement.getParent());
        }
        return null;
    }

    public abstract boolean isERROR();

    public abstract boolean isWARNING();

    public abstract boolean isINFO();

    public abstract String getMessage();

    public Object getAdapter(Class clazz) {
        if (clazz == (class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = JsmElementRecord.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile) || clazz == (class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = JsmElementRecord.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) {
            return this.getTextLocation().getFile();
        }
        if (clazz == (class$org$eclipse$jdt$core$ISourceRange == null ? (class$org$eclipse$jdt$core$ISourceRange = JsmElementRecord.class$("org.eclipse.jdt.core.ISourceRange")) : class$org$eclipse$jdt$core$ISourceRange)) {
            ITextLocation iTextLocation = this.getTextLocation();
            if (iTextLocation.getStart() == -1) {
                return null;
            }
            return new SourceRange(iTextLocation.getStart(), iTextLocation.getLength());
        }
        return null;
    }

    public ITextLocation getTextLocation() {
        if (this.myTextLocation == null) {
            this.myTextLocation = this.mySourceEliminated ? new JsmElementRecord$TextLocation(null) : this.createTextLocation();
        }
        return this.myTextLocation;
    }

    protected final ITextLocation createTextLocation() {
        int n2;
        IMethod iMethod = this.getSourceMethod();
        if (iMethod == null || !iMethod.exists()) {
            this.detachCUWatcher();
            this.mySourceEliminated = true;
            return new JsmElementRecord$TextLocation(null);
        }
        IFile iFile = JavaElementUtil.getSourceFile((IJavaElement)iMethod);
        if (iFile == null) {
            this.detachCUWatcher();
            this.mySourceEliminated = true;
            return new JsmElementRecord$TextLocation(null);
        }
        this.attachCUWatcher(iMethod);
        JsmElementRecord$TextLocation jsmElementRecord$TextLocation = new JsmElementRecord$TextLocation(null);
        jsmElementRecord$TextLocation.file = iFile;
        jsmElementRecord$TextLocation.length = this.getASTNode().getLength();
        int n3 = this.getDeclarationOffset(iMethod);
        if (n3 > -1 && (n2 = this.getRelativeOffset(this.getASTNode())) > -1) {
            jsmElementRecord$TextLocation.start = n3 + n2;
        }
        return jsmElementRecord$TextLocation;
    }

    protected IMethod getSourceMethod(JsmElement jsmElement) {
        if (jsmElement == null) {
            return null;
        }
        JsmMessage jsmMessage = null;
        jsmMessage = jsmElement instanceof JsmMessage ? (JsmMessage)jsmElement : jsmElement.getParentMessage();
        if (jsmMessage != null) {
            IMethod iMethod = jsmMessage.getMethod();
            return iMethod;
        }
        return null;
    }

    protected int getDeclarationOffset(IMethod iMethod) {
        CompilationUnit compilationUnit = this.getCompilationUnit(iMethod);
        MethodDeclaration methodDeclaration = null;
        try {
            methodDeclaration = (MethodDeclaration)d.a((IMember)iMethod, class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = JsmElementRecord.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, compilationUnit);
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        if (methodDeclaration != null) {
            return this.getBodyStart(methodDeclaration);
        }
        return -1;
    }

    protected int getBodyStart(MethodDeclaration methodDeclaration) {
        int n2 = methodDeclaration.getStartPosition();
        Block block = methodDeclaration.getBody();
        if (block != null) {
            return block.getStartPosition();
        }
        return methodDeclaration.getStartPosition() + methodDeclaration.getLength();
    }

    protected CompilationUnit getCompilationUnit(IMethod iMethod) {
        ICompilationUnit iCompilationUnit = iMethod.getCompilationUnit();
        return CUCache.instance().get(iCompilationUnit);
    }

    protected int getRelativeOffset(ASTNode aSTNode) {
        if (aSTNode != null) {
            int n2 = aSTNode.getStartPosition();
            while (aSTNode != null) {
                if (aSTNode instanceof MethodDeclaration) {
                    return n2 - this.getBodyStart((MethodDeclaration)aSTNode);
                }
                aSTNode = aSTNode.getParent();
            }
        }
        return -1;
    }

    private void attachCUWatcher(IMethod iMethod) {
        ICompilationUnit iCompilationUnit = iMethod.getCompilationUnit();
        this.myWatcher.attach(iCompilationUnit.getHandleIdentifier());
    }

    private void detachCUWatcher() {
        this.myWatcher.detach();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ITextLocation access$202(JsmElementRecord jsmElementRecord, ITextLocation iTextLocation) {
        jsmElementRecord.myTextLocation = iTextLocation;
        return jsmElementRecord.myTextLocation;
    }

    static boolean access$302(JsmElementRecord jsmElementRecord, boolean bl) {
        jsmElementRecord.mySourceEliminated = bl;
        return jsmElementRecord.mySourceEliminated;
    }
}

