/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.matcher;

import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import com.togethersoft.togetherxj.gsd.matcher.LocationData;
import com.togethersoft.togetherxj.gsd.matcher.Match;
import java.util.ArrayList;
import java.util.List;

public class MatcherResult {
    private List mySdaElementList;
    private List myLocationDataList;
    private Match[] myMatches;

    public MatcherResult() {
        this.mySdaElementList = new ArrayList();
        this.myLocationDataList = new ArrayList();
    }

    public MatcherResult(List list, List list2) {
        this.mySdaElementList = list;
        this.myLocationDataList = list2;
    }

    public void add(SdaElement sdaElement, LocationData locationData) {
        if (sdaElement == null || locationData == null) {
            throw new IllegalArgumentException("MatcherResult.add element:" + sdaElement + " location:" + locationData);
        }
        this.mySdaElementList.add(sdaElement);
        this.myLocationDataList.add(locationData);
    }

    public Match[] getMatches() {
        if (this.myMatches == null) {
            this.myMatches = new Match[this.mySdaElementList.size()];
            int n2 = 0;
            while (n2 < this.myMatches.length) {
                Match match = new Match();
                match.element = (SdaElement)this.mySdaElementList.get(n2);
                match.location = (LocationData)this.myLocationDataList.get(n2);
                this.myMatches[n2] = match;
                ++n2;
            }
        }
        return this.myMatches;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.mySdaElementList.size()) {
            SdaElement sdaElement = (SdaElement)this.mySdaElementList.get(n2);
            LocationData locationData = (LocationData)this.myLocationDataList.get(n2);
            stringBuffer.append('[').append(n2).append("] element:");
            stringBuffer.append(String.valueOf(sdaElement));
            stringBuffer.append(" loc:").append(String.valueOf(locationData));
            if (n2 < this.mySdaElementList.size() - 1) {
                stringBuffer.append("\n");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

