/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.matcher;

import com.togethersoft.togetherxj.gsd.core.jsm.JsmBuilder;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmElement;
import com.togethersoft.togetherxj.gsd.core.jsm.JsmMessage;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import com.togethersoft.togetherxj.gsd.core.sda.SdaMessage;
import com.togethersoft.togetherxj.gsd.matcher.Jsm2ChildrenList;
import com.togethersoft.togetherxj.gsd.matcher.JsmQualifiedMatchKey;
import com.togethersoft.togetherxj.gsd.matcher.LocationData;
import com.togethersoft.togetherxj.gsd.matcher.MatchKey;
import com.togethersoft.togetherxj.gsd.matcher.MatcherResult;
import com.togethersoft.togetherxj.gsd.matcher.MatcherSource;
import com.togethersoft.togetherxj.gsd.matcher.QualifiedKeysList;
import com.togethersoft.togetherxj.gsd.matcher.QualifiedMatchKey;
import com.togethersoft.togetherxj.gsd.matcher.Sda2ChildrenList;
import com.togethersoft.togetherxj.gsd.matcher.SdaQualifiedMatchKey;
import com.togethersoft.togetherxj.gsd.util.SourceRange;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;

public class Matcher {
    public MatcherSource createMatcherSource(IMethod iMethod) {
        JsmBuilder jsmBuilder = JsmBuilder.newBuilder(iMethod.getJavaProject());
        jsmBuilder.setCallNestingDepth(1);
        jsmBuilder.setExcludeSelfMessages(false);
        JsmMessage jsmMessage = jsmBuilder.buildInitialMessage(iMethod, true);
        return this.createMatcherSource(jsmMessage);
    }

    private MatcherSource createMatcherSource(JsmMessage jsmMessage) {
        ICompilationUnit iCompilationUnit = JavaElementUtil.getOriginalCompilationUnit((IJavaElement)jsmMessage.getMethod());
        String string = iCompilationUnit.getHandleIdentifier();
        SourceRange sourceRange = null;
        if (jsmMessage.getMethodDeclarationNode() != null) {
            int n2 = jsmMessage.getMethodDeclarationNode().getStartPosition();
            int n3 = jsmMessage.getMethodDeclarationNode().getLength();
            if (n2 > -1 && n3 > 0) {
                sourceRange = new SourceRange(n2, n3);
            }
        }
        MatcherSource matcherSource = new MatcherSource(string, sourceRange);
        Jsm2ChildrenList jsm2ChildrenList = new Jsm2ChildrenList(jsmMessage);
        List list = jsm2ChildrenList.getList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JsmElement jsmElement = (JsmElement)iterator.next();
            String string2 = MatchKey.createMatchKey(jsmElement);
            matcherSource.put(string2, jsmElement);
        }
        return matcherSource;
    }

    public MatcherResult createEmptyMatches(SdaMessage sdaMessage) {
        Sda2ChildrenList sda2ChildrenList = new Sda2ChildrenList(sdaMessage);
        List list = sda2ChildrenList.getList();
        ArrayList<LocationData> arrayList = new ArrayList<LocationData>(list.size());
        int n2 = 0;
        while (n2 < list.size()) {
            arrayList.add(LocationData.EMPTY);
            ++n2;
        }
        return new MatcherResult(list, arrayList);
    }

    public MatcherResult match(SdaMessage sdaMessage, MatcherSource matcherSource) {
        Sda2ChildrenList sda2ChildrenList = new Sda2ChildrenList(sdaMessage);
        List list = sda2ChildrenList.getList();
        MatcherResult matcherResult = new MatcherResult();
        QualifiedKeysList qualifiedKeysList = this.createQualifiedKeysList(list, matcherSource, matcherResult);
        QualifiedKeysList qualifiedKeysList2 = matcherSource.getQualifiedKeysList();
        this.matchList(qualifiedKeysList, qualifiedKeysList2, matcherResult);
        Iterator iterator = qualifiedKeysList.iterator();
        while (iterator.hasNext()) {
            SdaQualifiedMatchKey sdaQualifiedMatchKey = (SdaQualifiedMatchKey)iterator.next();
            if (sdaQualifiedMatchKey.getSourceRange() != null) {
                ISourceRange iSourceRange = sdaQualifiedMatchKey.getSourceRange();
                LocationData locationData = new LocationData(matcherSource.getCuID(), iSourceRange);
                matcherResult.add(sdaQualifiedMatchKey.getElement(), locationData);
                continue;
            }
            matcherResult.add(sdaQualifiedMatchKey.getElement(), LocationData.EMPTY);
        }
        return matcherResult;
    }

    private void matchList(QualifiedKeysList qualifiedKeysList, QualifiedKeysList qualifiedKeysList2, MatcherResult matcherResult) {
        Object object;
        if (qualifiedKeysList.size() == 0) {
            return;
        }
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < qualifiedKeysList.size()) {
            int n6;
            object = qualifiedKeysList.get(n5);
            if (((QualifiedMatchKey)object).length() > n2 && (n6 = qualifiedKeysList2.indexOf((QualifiedMatchKey)object)) > -1) {
                n2 = ((QualifiedMatchKey)object).length();
                n3 = n5;
                n4 = n6;
            }
            ++n5;
        }
        if (n2 > 0) {
            object = (SdaQualifiedMatchKey)qualifiedKeysList.get(n3);
            JsmQualifiedMatchKey jsmQualifiedMatchKey = (JsmQualifiedMatchKey)qualifiedKeysList2.get(n4);
            ((SdaQualifiedMatchKey)object).setSourceRange(jsmQualifiedMatchKey.getSourceRange());
            this.matchListUp(qualifiedKeysList, n3, qualifiedKeysList2, n4, matcherResult);
            this.matchListDown(qualifiedKeysList, n3, qualifiedKeysList2, n4, matcherResult);
        } else if (qualifiedKeysList2.maxKeyLength() > qualifiedKeysList.maxKeyLength()) {
            String string;
            object = qualifiedKeysList.getCommonQualifier();
            if (object != null && ((String)object).equals(string = qualifiedKeysList2.getCommonQualifier())) {
                qualifiedKeysList = qualifiedKeysList.getReduced();
            }
            qualifiedKeysList2 = qualifiedKeysList2.getReduced();
            this.matchList(qualifiedKeysList, qualifiedKeysList2, matcherResult);
        }
    }

    private void matchListUp(QualifiedKeysList qualifiedKeysList, int n2, QualifiedKeysList qualifiedKeysList2, int n3, MatcherResult matcherResult) {
        int n4 = qualifiedKeysList.indexOfParent(n2);
        int n5 = qualifiedKeysList2.indexOfParent(n3);
        if (n4 > -1 && n5 > -1) {
            SdaQualifiedMatchKey sdaQualifiedMatchKey = (SdaQualifiedMatchKey)qualifiedKeysList.get(n4);
            JsmQualifiedMatchKey jsmQualifiedMatchKey = (JsmQualifiedMatchKey)qualifiedKeysList2.get(n5);
            sdaQualifiedMatchKey.setSourceRange(jsmQualifiedMatchKey.getSourceRange());
            this.matchListUp(qualifiedKeysList, n4, qualifiedKeysList2, n5, matcherResult);
        }
        int n6 = n4 + 1;
        int n7 = n5 + 1;
        QualifiedKeysList qualifiedKeysList3 = qualifiedKeysList.subList(n6, n2);
        QualifiedKeysList qualifiedKeysList4 = qualifiedKeysList2.subList(n7, n3);
        this.matchList(qualifiedKeysList3, qualifiedKeysList4, matcherResult);
    }

    private void matchListDown(QualifiedKeysList qualifiedKeysList, int n2, QualifiedKeysList qualifiedKeysList2, int n3, MatcherResult matcherResult) {
        QualifiedKeysList qualifiedKeysList3 = qualifiedKeysList.subList(n2 + 1);
        QualifiedKeysList qualifiedKeysList4 = qualifiedKeysList2.subList(n3 + 1);
        this.matchList(qualifiedKeysList3, qualifiedKeysList4, matcherResult);
    }

    private QualifiedKeysList createQualifiedKeysList(List list, MatcherSource matcherSource, MatcherResult matcherResult) {
        QualifiedKeysList qualifiedKeysList = new QualifiedKeysList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            SdaElement sdaElement = (SdaElement)iterator.next();
            String string = MatchKey.createMatchKey(sdaElement);
            if (sdaElement instanceof SdaMessage) {
                object = (SdaMessage)sdaElement;
                if (((SdaMessage)object).getMethod() == null && !((SdaMessage)object).isCreation()) {
                    matcherResult.add(sdaElement, LocationData.EMPTY);
                    continue;
                }
                if (!matcherSource.contains(string)) {
                    matcherResult.add(sdaElement, LocationData.EMPTY);
                    continue;
                }
            }
            object = new SdaQualifiedMatchKey(sdaElement, string);
            qualifiedKeysList.addQualifiedKey((QualifiedMatchKey)object);
        }
        return qualifiedKeysList;
    }
}

