/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.matcher;

import com.togethersoft.togetherxj.gsd.core.jsm.JsmElement;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import com.togethersoft.togetherxj.gsd.matcher.MatchKey$JSM_MATCH_KEY;
import com.togethersoft.togetherxj.gsd.matcher.MatchKey$SDA_MATCH_KEY;
import com.togethersoft.togetherxj.gsd.util.KindOfReference;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperation;
import com.togethersoft.togetherxj.uml.cdl.core.MessageOperationHelper;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;

public class MatchKey {
    public static String createMatchKey(Reference reference) {
        if (ElementUtil.isConventionalMessage((PropertyMap)reference)) {
            MessageOperation messageOperation = MessageOperationHelper.getMessageOperation((Entity)reference.getEntity());
            IMethod iMethod = messageOperation.getMethod();
            String string = MatchKey.createMethodKey(iMethod, reference.getEntity().hasProperty("creation"));
            return reference.getUniqueName().toString() + string;
        }
        if (ElementUtil.isStatementBlock((PropertyMap)reference)) {
            return MatchKey.createStatementBlockReferenceKey(reference);
        }
        return null;
    }

    private static String createStatementBlockReferenceKey(Reference reference) {
        String string = reference.getPropertyValue("$metaclass");
        String string2 = KindOfReference.get(reference);
        String string3 = null;
        if (string2 == "IF" || string2 == "ELSEIF") {
            string3 = reference.getEntity().getPropertyValue("condition");
        } else if (string.equals("Iteration Block")) {
            string3 = reference.getEntity().getPropertyValue("iteration");
        } else if (string.equals("Switch Block")) {
            string3 = reference.getEntity().getPropertyValue("expression");
        } else if (string.equals("Catch Block")) {
            string3 = reference.getEntity().getPropertyValue("parameter");
        }
        return reference.getUniqueName().toString() + MatchKey.createStatementKey(string2, string3);
    }

    private static String createMethodKey(IMethod iMethod, boolean bl) {
        if (iMethod != null) {
            String string = "(?)";
            try {
                string = iMethod.getSignature();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return "<<<" + iMethod.getElementName() + string;
        }
        if (bl) {
            return "<<<default constructor>>>";
        }
        return "<<<no method>>>";
    }

    private static String createStatementKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("<<<");
        stringBuffer.append(string);
        if (string2 != null) {
            string2 = MatchKey.getPure(string2);
            stringBuffer.append("(").append(string2).append(")");
        }
        return stringBuffer.toString();
    }

    private static String getPure(String string) {
        StringTokenizer stringTokenizer;
        if ((string = string.trim()).length() > 1 && (stringTokenizer = new StringTokenizer(string)).countTokens() > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String createMatchKey(JsmElement jsmElement) {
        return MatchKey$JSM_MATCH_KEY.get(jsmElement);
    }

    public static String createMatchKey(SdaElement sdaElement) {
        return MatchKey$SDA_MATCH_KEY.get(sdaElement);
    }

    static String access$000(IMethod iMethod, boolean bl) {
        return MatchKey.createMethodKey(iMethod, bl);
    }

    static String access$100(String string, String string2) {
        return MatchKey.createStatementKey(string, string2);
    }
}

