/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.matcher;

import com.togethersoft.togetherxj.uml.cdl.location.ITextLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class LocationData
implements ITextLocation {
    public static final LocationData EMPTY = new LocationData(null, 0, 0);
    private String myCuId;
    private int myStart;
    private int myLength;
    private IFile myFile;

    public LocationData(String string, ISourceRange iSourceRange) {
        this(string, iSourceRange.getOffset(), iSourceRange.getLength());
    }

    public LocationData(String string, int n2, int n3) {
        this.myCuId = string;
        this.myStart = n2;
        this.myLength = n3;
    }

    public boolean isEmpty() {
        return this.myCuId == null;
    }

    public IFile getFile() {
        if (this.myFile == null && this.myCuId != null) {
            this.myFile = this.findFile();
            if (this.myFile == null) {
                this.myCuId = null;
            }
        }
        return this.myFile;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getLength() {
        return this.myLength;
    }

    private IFile findFile() {
        ICompilationUnit iCompilationUnit;
        if (this.myCuId != null && (iCompilationUnit = (ICompilationUnit)JavaCore.create((String)this.myCuId)) != null) {
            try {
                IResource iResource = iCompilationUnit.getUnderlyingResource();
                if (iResource instanceof IFile) {
                    return (IFile)iResource;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "EMPTY LOCATION DATA";
        }
        return "start:" + this.myStart + " length:" + this.myLength + " CU:" + this.myCuId + " file:" + (this.getFile() == null ? "NIL" : this.getFile().getFullPath().toString());
    }
}

