/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.location;

import com.togethersoft.togetherxj.gsd.GsdCorePlugin;
import com.togethersoft.togetherxj.gsd.location.LocationDataCache;
import com.togethersoft.togetherxj.gsd.matcher.Match;
import com.togethersoft.togetherxj.gsd.matcher.MatcherResult;
import com.togethersoft.togetherxj.gsd.matcher.MatcherSource;
import com.togethersoft.togetherxj.gsd.util.IWatcher;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import com.tssap.selena.model.elements.Reference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;

class MatcherSourceCache
implements IWatcher {
    private static MatcherSourceCache instance;
    private HashMap myMethod2MatcherSourceMap = new HashMap();
    private HashMap myCU2ReferenceUINsMap = new HashMap();
    private HashMap myCU2MethodIDsMap = new HashMap();

    MatcherSourceCache() {
    }

    public static MatcherSourceCache instance() {
        if (instance == null) {
            instance = new MatcherSourceCache();
        }
        return instance;
    }

    public MatcherSource getMatcherSource(IMethod iMethod) {
        String string = iMethod.getHandleIdentifier();
        return (MatcherSource)this.myMethod2MatcherSourceMap.get(string);
    }

    public void putMatcherSource(IMethod iMethod, MatcherSource matcherSource) {
        this.hookMethod(iMethod);
        String string = iMethod.getHandleIdentifier();
        this.myMethod2MatcherSourceMap.put(string, matcherSource);
    }

    private void hookMethod(IMethod iMethod) {
        ICompilationUnit iCompilationUnit = JavaElementUtil.getOriginalCompilationUnit((IJavaElement)iMethod);
        String string = iCompilationUnit.getHandleIdentifier();
        if (!this.myCU2MethodIDsMap.containsKey(string)) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(iMethod.getHandleIdentifier());
            HashSet hashSet2 = new HashSet();
            this.myCU2MethodIDsMap.put(string, hashSet);
            this.myCU2ReferenceUINsMap.put(string, hashSet2);
            GsdCorePlugin.getDefault().getCUDeltaHandler().addWatcher(string, (IWatcher)this);
        } else {
            Set set = (Set)this.myCU2MethodIDsMap.get(string);
            String string2 = iMethod.getHandleIdentifier();
            set.add(string2);
        }
    }

    public void hookReferences(IMethod iMethod, MatcherResult matcherResult) {
        ICompilationUnit iCompilationUnit = JavaElementUtil.getOriginalCompilationUnit((IJavaElement)iMethod);
        String string = iCompilationUnit.getHandleIdentifier();
        Set set = (Set)this.myCU2ReferenceUINsMap.get(string);
        Match[] matchArray = matcherResult.getMatches();
        int n2 = 0;
        while (n2 < matchArray.length) {
            Match match = matchArray[n2];
            Reference reference = match.element.getReference();
            if (reference != null) {
                String string2 = reference.getUniqueName().toString();
                set.add(string2);
            }
            ++n2;
        }
    }

    private void invalidateCompilationUnit(ICompilationUnit iCompilationUnit) {
        Object object;
        String string = iCompilationUnit.getHandleIdentifier();
        GsdCorePlugin.getDefault().getCUDeltaHandler().removeWatcher(string, (IWatcher)this);
        Set set = (Set)this.myCU2MethodIDsMap.remove(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.myMethod2MatcherSourceMap.remove(object);
        }
        object = (Set)this.myCU2ReferenceUINsMap.remove(string);
        iterator = object.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            LocationDataCache.instance().invalidateReference(string2);
        }
    }

    public void changed(Object object) {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)object;
        this.invalidateCompilationUnit(iCompilationUnit);
    }

    public void eliminated(Object object) {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)object;
        this.invalidateCompilationUnit(iCompilationUnit);
    }

    public void shutdown() {
    }
}

