/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.location;

import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import com.togethersoft.togetherxj.gsd.matcher.LocationData;
import com.togethersoft.togetherxj.gsd.matcher.Match;
import com.togethersoft.togetherxj.gsd.matcher.MatchKey;
import com.tssap.selena.model.elements.Reference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LocationDataCache {
    private static LocationDataCache instance;
    private HashMap myLocationsMap = new HashMap();
    private HashMap myUIN2LocationDataMap = new HashMap();
    private HashMap myUIN2DependencySetMap = new HashMap();

    public static LocationDataCache instance() {
        if (instance == null) {
            instance = new LocationDataCache();
        }
        return instance;
    }

    private LocationDataCache() {
    }

    public LocationData getLocationData(Reference reference) {
        String string = MatchKey.createMatchKey(reference);
        return (LocationData)this.myLocationsMap.get(string);
    }

    public void putLocationData(Match[] matchArray) {
        ArrayList arrayList = new ArrayList(matchArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>(matchArray.length);
        ArrayList arrayList3 = new ArrayList(matchArray.length);
        int n2 = 0;
        while (n2 < matchArray.length) {
            SdaElement sdaElement = matchArray[n2].element;
            LocationData locationData = matchArray[n2].location;
            if (sdaElement.getReference() != null) {
                Reference reference = sdaElement.getReference();
                String string = reference.getUniqueName().toString();
                arrayList2.add(string);
                String string2 = MatchKey.createMatchKey(reference);
                this.myUIN2LocationDataMap.put(string, string2);
                this.myLocationsMap.put(string2, locationData);
            }
            ++n2;
        }
        this.updateDependencySet(arrayList2);
    }

    private void updateDependencySet(List list) {
        String string;
        Object object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            string = (String)this.myUIN2DependencySetMap.get(object);
            if (string == null) continue;
            this.myUIN2DependencySetMap.remove(string);
            this.myUIN2DependencySetMap.remove(object);
        }
        object = new HashSet();
        ((AbstractCollection)object).addAll(list);
        string = "dependency set#" + System.currentTimeMillis();
        while (this.myUIN2DependencySetMap.containsKey(string)) {
            string = string + ".";
        }
        this.myUIN2DependencySetMap.put(string, object);
        iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.myUIN2DependencySetMap.put(string2, string);
        }
    }

    public void invalidate(Reference reference) {
        this.invalidateReference(reference.getUniqueName().toString());
    }

    protected void invalidateReference(String string) {
        String string2 = (String)this.myUIN2LocationDataMap.get(string);
        if (string2 != null) {
            this.myUIN2LocationDataMap.remove(string);
            this.myLocationsMap.remove(string2);
        }
        String string3 = (String)this.myUIN2DependencySetMap.get(string);
        Set set = null;
        if (string3 != null) {
            set = (Set)this.myUIN2DependencySetMap.remove(string3);
        }
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                this.invalidateReference(string4);
            }
        }
    }
}

