/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.location;

import com.togethersoft.togetherxj.gsd.core.sda.SdaDiagram;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import com.togethersoft.togetherxj.gsd.core.sda.SdaMessage;
import com.togethersoft.togetherxj.gsd.location.LocationDataCache;
import com.togethersoft.togetherxj.gsd.location.MatcherSourceCache;
import com.togethersoft.togetherxj.gsd.matcher.LocationData;
import com.togethersoft.togetherxj.gsd.matcher.Match;
import com.togethersoft.togetherxj.gsd.matcher.Matcher;
import com.togethersoft.togetherxj.gsd.matcher.MatcherResult;
import com.togethersoft.togetherxj.gsd.matcher.MatcherSource;
import com.togethersoft.togetherxj.uml.cdl.location.IImplementationLocator;
import com.togethersoft.togetherxj.uml.cdl.location.ITextLocation;
import com.togethersoft.togetherxj.uml.cdl.util.JavaElementUtil;
import com.togethersoft.togetherxj.uml.interaction.util.ElementUtil;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.Reference;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;

public class ImplementationLocator
implements IImplementationLocator {
    private LocationDataCache myLocationDataCache = LocationDataCache.instance();
    private MatcherSourceCache myMatcherSourceCache = MatcherSourceCache.instance();

    public ITextLocation getLocation(Reference reference) {
        if (!ElementUtil.isConventionalMessage((PropertyMap)reference) && !ElementUtil.isStatementBlock((PropertyMap)reference)) {
            return null;
        }
        LocationData locationData = this.myLocationDataCache.getLocationData(reference);
        if (locationData == null) {
            this.invalidateLocation(reference);
            this.performMatching(reference);
            locationData = this.myLocationDataCache.getLocationData(reference);
        }
        if (locationData == null || locationData.isEmpty()) {
            return null;
        }
        return locationData;
    }

    public void invalidateLocation(Reference reference) {
        this.myLocationDataCache.invalidate(reference);
    }

    private void performMatching(Reference reference) {
        SdaDiagram sdaDiagram = new SdaDiagram(ElementUtil.getParentCollection((Reference)reference));
        SdaElement sdaElement = sdaDiagram.findElement(reference);
        if (sdaElement == null) {
            return;
        }
        SdaMessage sdaMessage = sdaElement.getParentMessage();
        Match[] matchArray = null;
        if (sdaMessage == null) {
            matchArray = new Match[]{new Match()};
            matchArray[0].element = sdaElement;
            matchArray[0].location = LocationData.EMPTY;
        } else {
            MatcherResult matcherResult = null;
            IMethod iMethod = sdaMessage.getMethod();
            if (iMethod != null && this.isSourceMethod(iMethod)) {
                Matcher matcher = new Matcher();
                try {
                    MatcherSource matcherSource = this.myMatcherSourceCache.getMatcherSource(iMethod);
                    if (matcherSource == null) {
                        matcherSource = matcher.createMatcherSource(iMethod);
                        this.myMatcherSourceCache.putMatcherSource(iMethod, matcherSource);
                    }
                    matcherResult = matcher.match(sdaMessage, matcherSource);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    matcherResult = matcher.createEmptyMatches(sdaMessage);
                }
                this.myMatcherSourceCache.hookReferences(iMethod, matcherResult);
            } else {
                Matcher matcher = new Matcher();
                matcherResult = matcher.createEmptyMatches(sdaMessage);
            }
            matchArray = matcherResult.getMatches();
        }
        this.myLocationDataCache.putLocationData(matchArray);
    }

    private boolean isSourceMethod(IMethod iMethod) {
        try {
            if (iMethod.exists() && !iMethod.isBinary() && iMethod.isStructureKnown() && JavaElementUtil.getSourceFile((IJavaElement)iMethod) != null) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }
}

