/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.core.sda;

import com.togethersoft.togetherxj.gsd.core.sda.SdaDiagram;
import com.togethersoft.togetherxj.gsd.core.sda.SdaMessage;
import com.togethersoft.togetherxj.gsd.core.sda.SdaVisitor;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement;
import com.tssap.selena.model.elements.Reference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SdaElement {
    private SdaDiagram myDiagram;
    private SdaElement myParent;
    private SequenceElement myElement;
    private List myChildren;
    private Reference myReference;

    protected SdaElement(SdaDiagram sdaDiagram, SequenceElement sequenceElement) {
        this.myDiagram = sdaDiagram;
        this.myElement = sequenceElement;
        if (sequenceElement != null) {
            this.myReference = sequenceElement.getReference();
        }
    }

    SequenceElement getSequenceElement() {
        return this.myElement;
    }

    void addChild(SdaElement sdaElement) {
        this.getChildrenList().add(sdaElement);
    }

    protected int getChildCount() {
        if (this.myChildren == null) {
            return 0;
        }
        return this.myChildren.size();
    }

    protected List getChildrenList() {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList();
        }
        return this.myChildren;
    }

    void setParent(SdaElement sdaElement) {
        this.myParent = sdaElement;
    }

    protected void visitChildren(SdaVisitor sdaVisitor) {
        if (this.getChildCount() > 0) {
            Iterator iterator = this.getChildrenList().iterator();
            while (iterator.hasNext()) {
                SdaElement sdaElement = (SdaElement)iterator.next();
                sdaElement.accept(sdaVisitor);
            }
        }
    }

    protected void visitChild(SdaElement sdaElement, SdaVisitor sdaVisitor) {
        if (sdaElement != null) {
            sdaElement.accept(sdaVisitor);
        }
    }

    public boolean parentOf(SdaElement sdaElement) {
        SdaElement sdaElement2 = sdaElement.getParent();
        while (sdaElement2 != null) {
            if (sdaElement2 == this) {
                return true;
            }
            sdaElement2 = sdaElement2.getParent();
        }
        return false;
    }

    public abstract void accept(SdaVisitor var1);

    public Reference getReference() {
        return this.myReference;
    }

    public String getProperty(String string) {
        if (this.myElement != null) {
            return this.myElement.getProperty(string);
        }
        return null;
    }

    public void setProperty(String string, String string2) {
        if (this.myElement != null) {
            this.myElement.setProperty(string, string2);
        }
    }

    public SdaElement getParent() {
        return this.myParent;
    }

    public SdaMessage getParentMessage() {
        SdaElement sdaElement = this.getParent();
        while (sdaElement != null && !(sdaElement instanceof SdaMessage)) {
            sdaElement = sdaElement.getParent();
        }
        return (SdaMessage)sdaElement;
    }

    public SdaDiagram getDiagram() {
        return this.myDiagram;
    }
}

