/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.togetherxj.gsd.core.sda;

import com.togethersoft.togetherxj.gsd.core.sda.FakeIfBlock;
import com.togethersoft.togetherxj.gsd.core.sda.FakeTryBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaCatchBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaConditionalBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaDiagram;
import com.togethersoft.togetherxj.gsd.core.sda.SdaDoBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElement;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElseBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaElseIfBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaFinallyBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaForBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaIfBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaMessage;
import com.togethersoft.togetherxj.gsd.core.sda.SdaSwitchBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaTryBlock;
import com.togethersoft.togetherxj.gsd.core.sda.SdaWhileBlock;
import com.togethersoft.togetherxj.uml.interaction.model.ConventionalMessage;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceElement;
import com.togethersoft.togetherxj.uml.interaction.model.SequenceMessage;
import com.togethersoft.togetherxj.uml.interaction.model.StatementBlock;
import java.util.Iterator;

class ElementBuilder {
    ElementBuilder() {
    }

    public SdaElement buildElement(SdaDiagram sdaDiagram, SdaElement sdaElement, SequenceElement sequenceElement) {
        if (sequenceElement instanceof ConventionalMessage) {
            return this.buildMessage(sdaDiagram, sdaElement, (ConventionalMessage)sequenceElement);
        }
        if (sequenceElement instanceof StatementBlock) {
            String string = sequenceElement.getMetaclass();
            if ("Conditional Block".equals(string)) {
                SdaElement sdaElement2;
                String string2 = sequenceElement.getProperty("blockType");
                if ("if".equals(string2)) {
                    return this.buildIfBlock(sdaDiagram, sdaElement, (StatementBlock)sequenceElement);
                }
                SdaConditionalBlock sdaConditionalBlock = null;
                SequenceElement sequenceElement2 = (SequenceElement)sequenceElement.getPreviousSibling();
                if (sequenceElement2 != null && (sdaElement2 = sdaDiagram.findElement(sequenceElement2.getReference())) instanceof SdaConditionalBlock) {
                    sdaConditionalBlock = (SdaConditionalBlock)sdaElement2;
                }
                if (sdaConditionalBlock == null) {
                    sdaConditionalBlock = this.buildFakeIfBlock(sdaDiagram, sdaElement);
                }
                if ("else-if".equals(string2)) {
                    return this.buildElseIfBlock(sdaDiagram, sdaConditionalBlock, (StatementBlock)sequenceElement);
                }
                if ("else".equals(string2)) {
                    return this.buildElseBlock(sdaDiagram, sdaConditionalBlock, (StatementBlock)sequenceElement);
                }
            } else if ("Iteration Block".equals(string)) {
                String string3 = sequenceElement.getProperty("blockType");
                if ("for".equals(string3)) {
                    return this.buildForBlock(sdaDiagram, sdaElement, (StatementBlock)sequenceElement);
                }
                if ("while".equals(string3)) {
                    return this.buildWhileBlock(sdaDiagram, sdaElement, (StatementBlock)sequenceElement);
                }
                if ("do-while".equals(string3)) {
                    return this.buildDoBlock(sdaDiagram, sdaElement, (StatementBlock)sequenceElement);
                }
            } else {
                if ("Try Block".equals(string)) {
                    return this.buildTryBlock(sdaDiagram, sdaElement, (StatementBlock)sequenceElement);
                }
                if ("Catch Block".equals(string) || "Finally Block".equals(string)) {
                    SdaTryBlock sdaTryBlock = null;
                    SequenceElement sequenceElement3 = (SequenceElement)sequenceElement.getPreviousSibling();
                    if (sequenceElement3 != null) {
                        SdaElement sdaElement3 = sdaDiagram.findElement(sequenceElement3.getReference());
                        if (sdaElement3 instanceof SdaTryBlock) {
                            sdaTryBlock = (SdaTryBlock)sdaElement3;
                        } else if (sdaElement3 instanceof SdaCatchBlock) {
                            sdaTryBlock = (SdaTryBlock)((SdaCatchBlock)sdaElement3).getParent();
                        }
                    }
                    if (sdaTryBlock == null) {
                        sdaTryBlock = this.buildFakeTryBlock(sdaDiagram, sdaElement);
                    }
                    if ("Catch Block".equals(string)) {
                        return this.buildCatchBlock(sdaDiagram, sdaTryBlock, (StatementBlock)sequenceElement);
                    }
                    return this.buildFinallyBlock(sdaDiagram, sdaTryBlock, (StatementBlock)sequenceElement);
                }
                if ("Switch Block".equals(string)) {
                    return this.buildSwitchBlock(sdaDiagram, sdaElement, (StatementBlock)sequenceElement);
                }
            }
        }
        return null;
    }

    public SdaMessage buildMessage(SdaDiagram sdaDiagram, SdaElement sdaElement, ConventionalMessage conventionalMessage) {
        SdaMessage sdaMessage = new SdaMessage(sdaDiagram, (SequenceMessage)conventionalMessage);
        sdaDiagram.registerElement(sdaMessage);
        if (sdaElement != null) {
            sdaElement.addChild(sdaMessage);
            sdaMessage.setParent(sdaElement);
        }
        Iterator iterator = conventionalMessage.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            this.buildElement(sdaDiagram, sdaMessage, sequenceElement);
        }
        return sdaMessage;
    }

    public SdaIfBlock buildFakeIfBlock(SdaDiagram sdaDiagram, SdaElement sdaElement) {
        FakeIfBlock fakeIfBlock = new FakeIfBlock(sdaDiagram);
        sdaElement.addChild(fakeIfBlock);
        fakeIfBlock.setParent(sdaElement);
        return fakeIfBlock;
    }

    public SdaIfBlock buildIfBlock(SdaDiagram sdaDiagram, SdaElement sdaElement, StatementBlock statementBlock) {
        SdaIfBlock sdaIfBlock = new SdaIfBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaIfBlock);
        sdaElement.addChild(sdaIfBlock);
        sdaIfBlock.setParent(sdaElement);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            String string = sequenceElement.getProperty("blockPartId");
            if ("ExpressionPart".equals(string)) {
                this.buildElement(sdaDiagram, sdaIfBlock.getExpressionPart(), sequenceElement);
                continue;
            }
            this.buildElement(sdaDiagram, sdaIfBlock, sequenceElement);
        }
        return sdaIfBlock;
    }

    public SdaElseIfBlock buildElseIfBlock(SdaDiagram sdaDiagram, SdaConditionalBlock sdaConditionalBlock, StatementBlock statementBlock) {
        SdaElseIfBlock sdaElseIfBlock = new SdaElseIfBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaElseIfBlock);
        sdaElseIfBlock.setParent(sdaConditionalBlock);
        sdaConditionalBlock.setElseElement(sdaElseIfBlock);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            String string = sequenceElement.getProperty("blockPartId");
            if ("ExpressionPart".equals(string)) {
                this.buildElement(sdaDiagram, sdaElseIfBlock.getExpressionPart(), sequenceElement);
                continue;
            }
            this.buildElement(sdaDiagram, sdaElseIfBlock, sequenceElement);
        }
        return sdaElseIfBlock;
    }

    public SdaElseBlock buildElseBlock(SdaDiagram sdaDiagram, SdaConditionalBlock sdaConditionalBlock, StatementBlock statementBlock) {
        SdaElseBlock sdaElseBlock = new SdaElseBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaElseBlock);
        sdaElseBlock.setParent(sdaConditionalBlock);
        sdaConditionalBlock.setElseElement(sdaElseBlock);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            this.buildElement(sdaDiagram, sdaElseBlock, sequenceElement);
        }
        return sdaElseBlock;
    }

    public SdaForBlock buildForBlock(SdaDiagram sdaDiagram, SdaElement sdaElement, StatementBlock statementBlock) {
        SdaForBlock sdaForBlock = new SdaForBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaForBlock);
        sdaElement.addChild(sdaForBlock);
        sdaForBlock.setParent(sdaElement);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            String string = sequenceElement.getProperty("blockPartId");
            if ("ExpressionPart".equals(string)) {
                this.buildElement(sdaDiagram, sdaForBlock.getExpressionPart(), sequenceElement);
                continue;
            }
            if ("ForUpdatePart".equals(string)) {
                this.buildElement(sdaDiagram, sdaForBlock.getUpdatePart(), sequenceElement);
                continue;
            }
            this.buildElement(sdaDiagram, sdaForBlock, sequenceElement);
        }
        return sdaForBlock;
    }

    public SdaWhileBlock buildWhileBlock(SdaDiagram sdaDiagram, SdaElement sdaElement, StatementBlock statementBlock) {
        SdaWhileBlock sdaWhileBlock = new SdaWhileBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaWhileBlock);
        sdaElement.addChild(sdaWhileBlock);
        sdaWhileBlock.setParent(sdaElement);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            String string = sequenceElement.getProperty("blockPartId");
            if ("ExpressionPart".equals(string)) {
                this.buildElement(sdaDiagram, sdaWhileBlock.getExpressionPart(), sequenceElement);
                continue;
            }
            this.buildElement(sdaDiagram, sdaWhileBlock, sequenceElement);
        }
        return sdaWhileBlock;
    }

    public SdaDoBlock buildDoBlock(SdaDiagram sdaDiagram, SdaElement sdaElement, StatementBlock statementBlock) {
        SdaDoBlock sdaDoBlock = new SdaDoBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaDoBlock);
        sdaElement.addChild(sdaDoBlock);
        sdaDoBlock.setParent(sdaElement);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            String string = sequenceElement.getProperty("blockPartId");
            if ("ExpressionPart".equals(string)) {
                this.buildElement(sdaDiagram, sdaDoBlock.getExpressionPart(), sequenceElement);
                continue;
            }
            this.buildElement(sdaDiagram, sdaDoBlock, sequenceElement);
        }
        return sdaDoBlock;
    }

    public SdaTryBlock buildFakeTryBlock(SdaDiagram sdaDiagram, SdaElement sdaElement) {
        FakeTryBlock fakeTryBlock = new FakeTryBlock(sdaDiagram);
        sdaElement.addChild(fakeTryBlock);
        fakeTryBlock.setParent(sdaElement);
        return fakeTryBlock;
    }

    public SdaTryBlock buildTryBlock(SdaDiagram sdaDiagram, SdaElement sdaElement, StatementBlock statementBlock) {
        SdaTryBlock sdaTryBlock = new SdaTryBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaTryBlock);
        sdaElement.addChild(sdaTryBlock);
        sdaTryBlock.setParent(sdaElement);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            this.buildElement(sdaDiagram, sdaTryBlock, sequenceElement);
        }
        return sdaTryBlock;
    }

    public SdaCatchBlock buildCatchBlock(SdaDiagram sdaDiagram, SdaTryBlock sdaTryBlock, StatementBlock statementBlock) {
        SdaCatchBlock sdaCatchBlock = new SdaCatchBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaCatchBlock);
        sdaTryBlock.addCatchBlock(sdaCatchBlock);
        sdaCatchBlock.setParent(sdaTryBlock);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            this.buildElement(sdaDiagram, sdaCatchBlock, sequenceElement);
        }
        return sdaCatchBlock;
    }

    public SdaFinallyBlock buildFinallyBlock(SdaDiagram sdaDiagram, SdaTryBlock sdaTryBlock, StatementBlock statementBlock) {
        SdaFinallyBlock sdaFinallyBlock = new SdaFinallyBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaFinallyBlock);
        sdaTryBlock.setFinallyBlock(sdaFinallyBlock);
        sdaFinallyBlock.setParent(sdaTryBlock);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            this.buildElement(sdaDiagram, sdaFinallyBlock, sequenceElement);
        }
        return sdaFinallyBlock;
    }

    public SdaSwitchBlock buildSwitchBlock(SdaDiagram sdaDiagram, SdaElement sdaElement, StatementBlock statementBlock) {
        SdaSwitchBlock sdaSwitchBlock = new SdaSwitchBlock(sdaDiagram, statementBlock);
        sdaDiagram.registerElement(sdaSwitchBlock);
        sdaElement.addChild(sdaSwitchBlock);
        sdaSwitchBlock.setParent(sdaElement);
        Iterator iterator = statementBlock.subsequentElements();
        while (iterator.hasNext()) {
            SequenceElement sequenceElement = (SequenceElement)iterator.next();
            String string = sequenceElement.getProperty("blockPartId");
            if ("ExpressionPart".equals(string)) {
                this.buildElement(sdaDiagram, sdaSwitchBlock.getExpressionPart(), sequenceElement);
                continue;
            }
            this.buildElement(sdaDiagram, sdaSwitchBlock, sequenceElement);
        }
        return sdaSwitchBlock;
    }
}

